/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.blockentity.grid.portable;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.grid.GridType;
import com.refinedmods.refinedstorage.api.network.grid.ICraftingGridListener;
import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.api.network.grid.IGridTab;
import com.refinedmods.refinedstorage.api.network.grid.handler.IFluidGridHandler;
import com.refinedmods.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.refinedmods.refinedstorage.api.storage.AccessType;
import com.refinedmods.refinedstorage.api.storage.StorageType;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCache;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCacheListener;
import com.refinedmods.refinedstorage.api.storage.cache.InvalidateCause;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskContainerContext;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskProvider;
import com.refinedmods.refinedstorage.api.storage.disk.StorageDiskSyncData;
import com.refinedmods.refinedstorage.api.util.IFilter;
import com.refinedmods.refinedstorage.api.util.IStackList;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.grid.handler.PortableFluidGridHandler;
import com.refinedmods.refinedstorage.apiimpl.network.grid.handler.PortableItemGridHandler;
import com.refinedmods.refinedstorage.apiimpl.storage.cache.PortableFluidStorageCache;
import com.refinedmods.refinedstorage.apiimpl.storage.cache.PortableItemStorageCache;
import com.refinedmods.refinedstorage.apiimpl.storage.cache.listener.PortableFluidGridStorageCacheListener;
import com.refinedmods.refinedstorage.apiimpl.storage.cache.listener.PortableItemGridStorageCacheListener;
import com.refinedmods.refinedstorage.apiimpl.storage.disk.PortableFluidStorageDisk;
import com.refinedmods.refinedstorage.apiimpl.storage.disk.PortableItemStorageDisk;
import com.refinedmods.refinedstorage.apiimpl.storage.tracker.FluidStorageTracker;
import com.refinedmods.refinedstorage.apiimpl.storage.tracker.ItemStorageTracker;
import com.refinedmods.refinedstorage.blockentity.grid.portable.IPortableGrid;
import com.refinedmods.refinedstorage.blockentity.grid.portable.PortableGridDiskState;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.FilterItemHandler;
import com.refinedmods.refinedstorage.inventory.item.validator.StorageDiskItemValidator;
import com.refinedmods.refinedstorage.inventory.player.PlayerSlot;
import com.refinedmods.refinedstorage.item.WirelessGridItem;
import com.refinedmods.refinedstorage.item.blockitem.PortableGridBlockItem;
import com.refinedmods.refinedstorage.network.grid.PortableGridSettingsUpdateMessage;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.grid.GridScreen;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class PortableGrid
implements IGrid,
IPortableGrid,
IStorageDiskContainerContext {
    static final String NBT_ITEM_STORAGE_TRACKER_ID = "ItemStorageTrackerId";
    static final String NBT_FLUID_STORAGE_TRACKER_ID = "FluidStorageTrackerId";
    private final PortableItemGridHandler itemHandler = new PortableItemGridHandler(this, this);
    private final PortableFluidGridHandler fluidHandler = new PortableFluidGridHandler(this);
    private final PlayerSlot slot;
    private final List<IFilter> filters = new ArrayList<IFilter>();
    private final List<IGridTab> tabs = new ArrayList<IGridTab>();
    @Nullable
    private IStorageDisk storage;
    @Nullable
    private IStorageCache cache;
    @Nullable
    private Player player;
    private ItemStack stack;
    private final FilterItemHandler filter = (FilterItemHandler)new FilterItemHandler(this.filters, this.tabs).addListener((handler, slot, reading) -> {
        if (!this.stack.m_41782_()) {
            this.stack.m_41751_(new CompoundTag());
        }
        StackUtils.writeItems((IItemHandler)handler, 0, this.stack.m_41783_());
    });
    private int sortingType;
    private int sortingDirection;
    private int searchBoxMode;
    private int tabSelected;
    private int tabPage;
    private int size;
    private ItemStorageTracker itemStorageTracker;
    private UUID itemStorageTrackerId;
    private FluidStorageTracker fluidStorageTracker;
    private UUID fluidStorageTrackerId;
    private final BaseItemHandler disk = new BaseItemHandler(1).addValidator(new StorageDiskItemValidator()).addListener((handler, slot, reading) -> {
        if (this.player != null && !this.player.m_9236_().f_46443_) {
            ItemStack diskStack = handler.getStackInSlot(slot);
            if (diskStack.m_41619_()) {
                this.storage = null;
                this.cache = null;
            } else {
                IStorageDisk diskInSlot = API.instance().getStorageDiskManager((ServerLevel)this.player.m_9236_()).getByStack(this.getDiskInventory().getStackInSlot(0));
                if (diskInSlot != null) {
                    StorageType type = ((IStorageDiskProvider)this.getDiskInventory().getStackInSlot(0).m_41720_()).getType();
                    if (type == StorageType.ITEM) {
                        this.storage = new PortableItemStorageDisk(diskInSlot, this);
                        this.cache = new PortableItemStorageCache(this);
                    } else if (type == StorageType.FLUID) {
                        this.storage = new PortableFluidStorageDisk(diskInSlot, this);
                        this.cache = new PortableFluidStorageCache(this);
                    }
                    this.storage.setSettings(null, this);
                } else {
                    this.storage = null;
                    this.cache = null;
                }
            }
            if (this.cache != null) {
                this.cache.invalidate(InvalidateCause.DISK_INVENTORY_CHANGED);
            }
            StackUtils.writeItems((IItemHandler)handler, 4, this.stack.m_41783_());
        }
    });

    public PortableGrid(@Nullable Player player, ItemStack stack, PlayerSlot slot2) {
        this.player = player;
        this.stack = stack;
        this.slot = slot2;
        this.sortingType = WirelessGridItem.getSortingType(stack);
        this.sortingDirection = WirelessGridItem.getSortingDirection(stack);
        this.searchBoxMode = WirelessGridItem.getSearchBoxMode(stack);
        this.tabSelected = WirelessGridItem.getTabSelected(stack);
        this.tabPage = WirelessGridItem.getTabPage(stack);
        this.size = WirelessGridItem.getSize(stack);
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        if (player != null) {
            UUID id;
            if (stack.m_41783_().m_128441_(NBT_ITEM_STORAGE_TRACKER_ID)) {
                this.itemStorageTrackerId = stack.m_41783_().m_128342_(NBT_ITEM_STORAGE_TRACKER_ID);
            } else {
                id = UUID.randomUUID();
                stack.m_41783_().m_128362_(NBT_ITEM_STORAGE_TRACKER_ID, id);
                this.itemStorageTrackerId = id;
            }
            if (stack.m_41783_().m_128441_(NBT_FLUID_STORAGE_TRACKER_ID)) {
                this.fluidStorageTrackerId = stack.m_41783_().m_128342_(NBT_FLUID_STORAGE_TRACKER_ID);
            } else {
                id = UUID.randomUUID();
                stack.m_41783_().m_128362_(NBT_FLUID_STORAGE_TRACKER_ID, id);
                this.fluidStorageTrackerId = id;
            }
        }
        StackUtils.readItems(this.disk, 4, stack.m_41783_());
        StackUtils.readItems(this.filter, 0, stack.m_41783_());
    }

    public void onOpen() {
        this.drainEnergy(RS.SERVER_CONFIG.getPortableGrid().getOpenUsage());
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    @Nullable
    public IStorageCache getCache() {
        return this.cache;
    }

    @Override
    @Nullable
    public IStorageDisk getStorage() {
        return this.storage;
    }

    @Override
    public void drainEnergy(int energy) {
        if (RS.SERVER_CONFIG.getPortableGrid().getUseEnergy() && ((PortableGridBlockItem)this.stack.m_41720_()).getType() != PortableGridBlockItem.Type.CREATIVE) {
            this.stack.getCapability(ForgeCapabilities.ENERGY, null).ifPresent(energyStorage -> energyStorage.extractEnergy(energy, false));
        }
    }

    @Override
    public int getEnergy() {
        if (RS.SERVER_CONFIG.getPortableGrid().getUseEnergy() && ((PortableGridBlockItem)this.stack.m_41720_()).getType() != PortableGridBlockItem.Type.CREATIVE) {
            return this.stack.getCapability(ForgeCapabilities.ENERGY, null).map(IEnergyStorage::getEnergyStored).orElse(RS.SERVER_CONFIG.getPortableGrid().getCapacity());
        }
        return RS.SERVER_CONFIG.getPortableGrid().getCapacity();
    }

    @Override
    public BaseItemHandler getDiskInventory() {
        return this.disk;
    }

    public Player getPlayer() {
        return this.player;
    }

    @Override
    public GridType getGridType() {
        return this.getDiskInventory().getStackInSlot(0).m_41619_() || ((IStorageDiskProvider)this.getDiskInventory().getStackInSlot(0).m_41720_()).getType() == StorageType.ITEM ? GridType.NORMAL : GridType.FLUID;
    }

    @Override
    @Nullable
    public IStorageCache getStorageCache() {
        return this.storage != null ? this.cache : null;
    }

    @Override
    public IStorageCacheListener createListener(ServerPlayer player) {
        return this.getGridType() == GridType.FLUID ? new PortableFluidGridStorageCacheListener(this, player) : new PortableItemGridStorageCacheListener(this, player);
    }

    @Override
    @Nullable
    public IItemGridHandler getItemHandler() {
        return this.itemHandler;
    }

    @Override
    @Nullable
    public IFluidGridHandler getFluidHandler() {
        return this.fluidHandler;
    }

    @Override
    public void addCraftingListener(ICraftingGridListener listener) {
    }

    @Override
    public void removeCraftingListener(ICraftingGridListener listener) {
    }

    @Override
    public Component getTitle() {
        return Component.m_237115_((String)"gui.refinedstorage.portable_grid");
    }

    @Override
    public int getViewType() {
        return -1;
    }

    @Override
    public int getSortingType() {
        return this.sortingType;
    }

    @Override
    public int getSortingDirection() {
        return this.sortingDirection;
    }

    @Override
    public int getSearchBoxMode() {
        return this.searchBoxMode;
    }

    @Override
    public int getTabSelected() {
        return this.tabSelected;
    }

    @Override
    public int getTabPage() {
        return Math.min(this.tabPage, this.getTotalTabPages());
    }

    @Override
    public int getTotalTabPages() {
        return (int)Math.floor((float)Math.max(0, this.tabs.size() - 1) / 5.0f);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void onViewTypeChanged(int type) {
    }

    @Override
    public void onSortingTypeChanged(int type) {
        RS.NETWORK_HANDLER.sendToServer(new PortableGridSettingsUpdateMessage(this.getViewType(), this.getSortingDirection(), type, this.getSearchBoxMode(), this.getSize(), this.getTabSelected(), this.getTabPage()));
        this.sortingType = type;
        BaseScreen.executeLater(GridScreen.class, grid -> grid.getView().sort());
    }

    @Override
    public void onSortingDirectionChanged(int direction) {
        RS.NETWORK_HANDLER.sendToServer(new PortableGridSettingsUpdateMessage(this.getViewType(), direction, this.getSortingType(), this.getSearchBoxMode(), this.getSize(), this.getTabSelected(), this.getTabPage()));
        this.sortingDirection = direction;
        BaseScreen.executeLater(GridScreen.class, grid -> grid.getView().sort());
    }

    @Override
    public void onSearchBoxModeChanged(int searchBoxMode) {
        RS.NETWORK_HANDLER.sendToServer(new PortableGridSettingsUpdateMessage(this.getViewType(), this.getSortingDirection(), this.getSortingType(), searchBoxMode, this.getSize(), this.getTabSelected(), this.getTabPage()));
        this.searchBoxMode = searchBoxMode;
    }

    @Override
    public void onSizeChanged(int size) {
        RS.NETWORK_HANDLER.sendToServer(new PortableGridSettingsUpdateMessage(this.getViewType(), this.getSortingDirection(), this.getSortingType(), this.getSearchBoxMode(), size, this.getTabSelected(), this.getTabPage()));
        this.size = size;
        BaseScreen.executeLater(GridScreen.class, BaseScreen::m_7856_);
    }

    @Override
    public void onTabSelectionChanged(int tab) {
        this.tabSelected = tab == this.tabSelected ? -1 : tab;
        RS.NETWORK_HANDLER.sendToServer(new PortableGridSettingsUpdateMessage(this.getViewType(), this.getSortingDirection(), this.getSortingType(), this.getSearchBoxMode(), this.getSize(), this.tabSelected, this.getTabPage()));
        BaseScreen.executeLater(GridScreen.class, grid -> grid.getView().sort());
    }

    @Override
    public void onTabPageChanged(int page) {
        if (page >= 0 && page <= this.getTotalTabPages()) {
            RS.NETWORK_HANDLER.sendToServer(new PortableGridSettingsUpdateMessage(this.getViewType(), this.getSortingDirection(), this.getSortingType(), this.getSearchBoxMode(), this.getSize(), this.getTabSelected(), page));
            this.tabPage = page;
        }
    }

    @Override
    public List<IFilter> getFilters() {
        return this.filters;
    }

    @Override
    public List<IGridTab> getTabs() {
        return this.tabs;
    }

    @Override
    public IItemHandlerModifiable getFilter() {
        return this.filter;
    }

    public ItemStorageTracker getItemStorageTracker() {
        if (this.itemStorageTracker == null && this.player != null) {
            if (this.itemStorageTrackerId == null) {
                this.itemStorageTrackerId = UUID.randomUUID();
            }
            this.itemStorageTracker = (ItemStorageTracker)API.instance().getStorageTrackerManager((ServerLevel)this.player.m_9236_()).getOrCreate(this.itemStorageTrackerId, StorageType.ITEM);
        }
        return this.itemStorageTracker;
    }

    public FluidStorageTracker getFluidStorageTracker() {
        if (this.fluidStorageTracker == null && this.player != null) {
            if (this.fluidStorageTrackerId == null) {
                this.fluidStorageTrackerId = UUID.randomUUID();
            }
            this.fluidStorageTracker = (FluidStorageTracker)API.instance().getStorageTrackerManager((ServerLevel)this.player.m_9236_()).getOrCreate(this.fluidStorageTrackerId, StorageType.FLUID);
        }
        return this.fluidStorageTracker;
    }

    @Override
    public CraftingContainer getCraftingMatrix() {
        return null;
    }

    @Override
    public ResultContainer getCraftingResult() {
        return null;
    }

    @Override
    public void onCraftingMatrixChanged() {
    }

    @Override
    public void onCrafted(Player player, @Nullable IStackList<ItemStack> availableItems, @Nullable IStackList<ItemStack> usedItems) {
    }

    @Override
    public void onClear(Player player) {
    }

    @Override
    public void onCraftedShift(Player player) {
    }

    @Override
    public void onRecipeTransfer(Player player, ItemStack[][] recipe) {
    }

    @Override
    public void onClosed(Player player) {
        if (!player.m_20193_().f_46443_) {
            StackUtils.writeItems((IItemHandler)this.disk, 4, this.stack.m_41783_());
        }
    }

    private boolean hasDisk() {
        return !this.disk.getStackInSlot(0).m_41619_();
    }

    @Override
    public boolean isGridActive() {
        if (RS.SERVER_CONFIG.getPortableGrid().getUseEnergy() && ((PortableGridBlockItem)this.stack.m_41720_()).getType() != PortableGridBlockItem.Type.CREATIVE && ((IEnergyStorage)this.stack.getCapability(ForgeCapabilities.ENERGY).orElse(null)).getEnergyStored() <= RS.SERVER_CONFIG.getPortableGrid().getOpenUsage()) {
            return false;
        }
        return this.hasDisk();
    }

    @Override
    public int getSlotId() {
        return this.slot.getSlotIdInPlayerInventory();
    }

    @Nullable
    private UUID getDiskId() {
        return !this.hasDisk() ? null : ((IStorageDiskProvider)this.disk.getStackInSlot(0).m_41720_()).getId(this.disk.getStackInSlot(0));
    }

    private int getStored() {
        API.instance().getStorageDiskSync().sendRequest(this.getDiskId());
        StorageDiskSyncData data = API.instance().getStorageDiskSync().getData(this.getDiskId());
        return data == null ? 0 : data.getStored();
    }

    private int getCapacity() {
        API.instance().getStorageDiskSync().sendRequest(this.getDiskId());
        StorageDiskSyncData data = API.instance().getStorageDiskSync().getData(this.getDiskId());
        return data == null ? 0 : data.getCapacity();
    }

    @Override
    public PortableGridDiskState getDiskState() {
        int capacity;
        if (!this.hasDisk()) {
            return PortableGridDiskState.NONE;
        }
        if (!this.isGridActive()) {
            return PortableGridDiskState.DISCONNECTED;
        }
        int stored = this.getStored();
        if (stored == (capacity = this.getCapacity())) {
            return PortableGridDiskState.FULL;
        }
        if ((int)((float)stored / (float)capacity * 100.0f) >= 75) {
            return PortableGridDiskState.NEAR_CAPACITY;
        }
        return PortableGridDiskState.NORMAL;
    }

    @Override
    public AccessType getAccessType() {
        return AccessType.INSERT_EXTRACT;
    }
}

