/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.network.grid;

import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.blockentity.grid.WirelessFluidGrid;
import com.refinedmods.refinedstorage.container.GridContainerMenu;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class WirelessFluidGridSettingsUpdateMessage {
    private final int sortingDirection;
    private final int sortingType;
    private final int searchBoxMode;
    private final int size;
    private final int tabSelected;
    private final int tabPage;

    public WirelessFluidGridSettingsUpdateMessage(int sortingDirection, int sortingType, int searchBoxMode, int size, int tabSelected, int tabPage) {
        this.sortingDirection = sortingDirection;
        this.sortingType = sortingType;
        this.searchBoxMode = searchBoxMode;
        this.size = size;
        this.tabSelected = tabSelected;
        this.tabPage = tabPage;
    }

    public static WirelessFluidGridSettingsUpdateMessage decode(FriendlyByteBuf buf) {
        return new WirelessFluidGridSettingsUpdateMessage(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void encode(WirelessFluidGridSettingsUpdateMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.sortingDirection);
        buf.writeInt(message.sortingType);
        buf.writeInt(message.searchBoxMode);
        buf.writeInt(message.size);
        buf.writeInt(message.tabSelected);
        buf.writeInt(message.tabPage);
    }

    public static void handle(WirelessFluidGridSettingsUpdateMessage message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = ctx.get().getSender();
        if (player != null) {
            ctx.get().enqueueWork(() -> WirelessFluidGridSettingsUpdateMessage.lambda$handle$0((Player)player, message));
        }
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$handle$0(Player player, WirelessFluidGridSettingsUpdateMessage message) {
        IGrid grid;
        if (player.f_36096_ instanceof GridContainerMenu && (grid = ((GridContainerMenu)player.f_36096_).getGrid()) instanceof WirelessFluidGrid) {
            ItemStack stack = ((WirelessFluidGrid)grid).getStack();
            if (IGrid.isValidSortingDirection(message.sortingDirection)) {
                stack.m_41783_().m_128405_("SortingDirection", message.sortingDirection);
            }
            if (IGrid.isValidSortingType(message.sortingType)) {
                stack.m_41783_().m_128405_("SortingType", message.sortingType);
            }
            if (IGrid.isValidSearchBoxMode(message.searchBoxMode)) {
                stack.m_41783_().m_128405_("SearchBoxMode", message.searchBoxMode);
            }
            if (IGrid.isValidSize(message.size)) {
                stack.m_41783_().m_128405_("Size", message.size);
            }
            stack.m_41783_().m_128405_("TabSelected", message.tabSelected);
            stack.m_41783_().m_128405_("TabPage", message.tabPage);
        }
    }
}

