/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.furniture.refurbished.block.BathBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.BathBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.FluidContainer;
import com.mrcrayfish.furniture.refurbished.client.util.SimpleFluidRenderer;
import java.util.Objects;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class BathBlockEntityRenderer
implements BlockEntityRenderer<BathBlockEntity> {
    public BathBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(BathBlockEntity bath, float partialTick, PoseStack poseStack, MultiBufferSource source, int light, int overlay) {
        FluidContainer container = bath.getFluidContainer();
        if (container == null || container.isEmpty()) {
            return;
        }
        BlockState state = bath.m_58900_();
        if (!state.m_61138_((Property)BathBlock.DIRECTION)) {
            return;
        }
        Direction direction = (Direction)state.m_61143_((Property)BathBlock.DIRECTION);
        Level level = Objects.requireNonNull(bath.m_58904_());
        AABB box = this.getFluidBox(bath, direction);
        SimpleFluidRenderer.drawContainer(level, bath.m_58899_(), container, box, poseStack, source, light);
    }

    private AABB getFluidBox(BathBlockEntity bath, Direction direction) {
        if (bath.isHead()) {
            return SimpleFluidRenderer.createRotatedBox(direction, 0.0, 4.0, 2.0, 12.0, 15.0, 14.0);
        }
        return SimpleFluidRenderer.createRotatedBox(direction, 2.0, 4.0, 2.0, 16.0, 15.0, 14.0);
    }
}

