/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.block;

import com.github.mnesikos.simplycats.block.CatBowlBlock;
import com.github.mnesikos.simplycats.block.CatTreeBlock;
import com.github.mnesikos.simplycats.block.CatnipBlock;
import com.github.mnesikos.simplycats.block.LitterBoxBlock;
import com.github.mnesikos.simplycats.block.ScratchingPostBlock;
import com.github.mnesikos.simplycats.block.ShelterBookBlock;
import com.github.mnesikos.simplycats.block.WindowPerchBlock;
import com.github.mnesikos.simplycats.item.SCItems;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class SCBlocks {
    public static final DeferredRegister<Block> REGISTRAR;
    public static final RegistryObject<Block> CATNIP_CROP;
    public static final RegistryObject<Block> POTTED_CATNIP;
    public static final RegistryObject<Block> SHELTER_BOOK;
    public static final Map<DyeColor, RegistryObject<Block>> CAT_BOWLS;
    public static final Map<DyeColor, RegistryObject<Block>> LITTER_BOXES;
    public static final Map<DyeColor, RegistryObject<Block>> CAT_TREE_BEDS;
    public static final Map<DyeColor, RegistryObject<Block>> CAT_TREE_POSTS;
    public static final Map<DyeColor, RegistryObject<Block>> CAT_TREE_BOXES;
    public static final Map<String, RegistryObject<Block>> SCRATCHING_POSTS;
    public static final Map<String, RegistryObject<Block>> WINDOW_PERCHES;

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> block) {
        RegistryObject registryObject = REGISTRAR.register(name, block);
        SCItems.REGISTRAR.register(name, () -> new BlockItem((Block)registryObject.get(), new Item.Properties()));
        return registryObject;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setRenderLayers() {
        RenderType cutout = RenderType.m_110463_();
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)POTTED_CATNIP.get()), (RenderType)cutout);
    }

    static {
        String[] woodTypes;
        REGISTRAR = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"simplycats");
        CATNIP_CROP = REGISTRAR.register("catnip", () -> new CatnipBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_)));
        POTTED_CATNIP = REGISTRAR.register("potted_catnip", () -> new FlowerPotBlock((Block)CATNIP_CROP.get(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50233_)));
        SHELTER_BOOK = SCBlocks.register("shelter_book", ShelterBookBlock::new);
        CAT_BOWLS = new HashMap<DyeColor, RegistryObject<Block>>();
        LITTER_BOXES = new HashMap<DyeColor, RegistryObject<Block>>();
        CAT_TREE_BEDS = new HashMap<DyeColor, RegistryObject<Block>>();
        CAT_TREE_POSTS = new HashMap<DyeColor, RegistryObject<Block>>();
        CAT_TREE_BOXES = new HashMap<DyeColor, RegistryObject<Block>>();
        SCRATCHING_POSTS = new HashMap<String, RegistryObject<Block>>();
        WINDOW_PERCHES = new HashMap<String, RegistryObject<Block>>();
        for (DyeColor color : DyeColor.values()) {
            CAT_BOWLS.put(color, SCBlocks.register(color.m_41065_() + "_cat_bowl", CatBowlBlock::new));
            LITTER_BOXES.put(color, SCBlocks.register(color.m_41065_() + "_litter_box", LitterBoxBlock::new));
            CAT_TREE_BEDS.put(color, SCBlocks.register(color.m_41065_() + "_cat_tree_bed", () -> new CatTreeBlock.Bed(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0))));
            CAT_TREE_POSTS.put(color, SCBlocks.register(color.m_41065_() + "_cat_tree_post", () -> new CatTreeBlock(Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0))));
            CAT_TREE_BOXES.put(color, SCBlocks.register(color.m_41065_() + "_cat_tree_box", CatTreeBlock.Box::new));
        }
        for (String woodType : woodTypes = new String[]{"oak", "spruce", "birch", "acacia", "jungle", "dark_oak", "crimson", "warped"}) {
            SCRATCHING_POSTS.put(woodType, SCBlocks.register(woodType + "_scratching_post", ScratchingPostBlock::new));
            WINDOW_PERCHES.put(woodType, SCBlocks.register(woodType + "_window_perch", WindowPerchBlock::new));
        }
    }
}

