/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.client.render.entity;

import com.github.mnesikos.simplycats.SCReference;
import com.github.mnesikos.simplycats.client.model.entity.SimplyCatModel;
import com.github.mnesikos.simplycats.client.render.entity.LayeredTexture;
import com.github.mnesikos.simplycats.entity.SimplyCatEntity;
import com.github.mnesikos.simplycats.entity.core.Genetics;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class SimplyCatRenderer
extends MobRenderer<SimplyCatEntity, SimplyCatModel<SimplyCatEntity>> {
    private static final Map<String, ResourceLocation> LAYERED_LOCATION_CACHE = Maps.newHashMap();

    public SimplyCatRenderer(EntityRendererProvider.Context context) {
        super(context, new SimplyCatModel(context.m_174023_(SimplyCatModel.LAYER_LOCATION)), 0.4f);
    }

    public void render(SimplyCatEntity cat, float v, float v1, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int i) {
        ((SimplyCatModel)this.f_115290_).isBobtail = cat.isBobtail();
        ((SimplyCatModel)this.f_115290_).isLongFur = cat.isLongFur();
        ((SimplyCatModel)this.f_115290_).ageScale = cat.getAgeScale();
        super.m_7392_((Mob)cat, v, v1, matrixStack, renderTypeBuffer, i);
    }

    protected void scale(SimplyCatEntity entity, PoseStack matrixStack, float partialTickTime) {
        matrixStack.m_85841_(0.8f, 0.9f, 0.8f);
        super.m_7546_((LivingEntity)entity, matrixStack, partialTickTime);
    }

    public ResourceLocation getTextureLocation(SimplyCatEntity entity) {
        String name;
        if (entity.m_8077_() && entity.m_7770_() != null && entity.m_21805_() != null && (name = SCReference.getCustomCats().get(entity.m_21805_())) != null && name.equalsIgnoreCase(entity.m_7770_().getString())) {
            return new ResourceLocation("simplycats", "textures/entity/cat/custom/" + name + ".png");
        }
        String s = entity.getCatTexture();
        ResourceLocation resourceLocation = LAYERED_LOCATION_CACHE.get(s);
        if (resourceLocation == null) {
            resourceLocation = new ResourceLocation(s);
            Minecraft.m_91087_().m_91097_().m_118495_(resourceLocation, (AbstractTexture)new LayeredTexture(entity.getTexturePaths()));
            LAYERED_LOCATION_CACHE.put(s, resourceLocation);
        }
        return resourceLocation;
    }

    protected void renderNameTag(SimplyCatEntity cat, Component textComponent, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int p_225629_5_) {
        super.m_7649_((Entity)cat, textComponent, matrixStack, renderTypeBuffer, p_225629_5_);
        double distance = this.f_114476_.m_114471_((Entity)cat);
        if (ForgeHooksClient.isNameplateInRenderDistance((Entity)cat, (double)distance) && this.f_114476_.f_114358_.m_90592_().m_6144_() && !cat.isFixed() && !cat.m_6162_()) {
            boolean catNotSneaking = !cat.m_20163_();
            float height = cat.m_20206_() + 0.62f;
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, (double)height, 0.0);
            matrixStack.m_252781_(this.f_114476_.m_253208_());
            matrixStack.m_85841_(-0.012f, -0.012f, 0.012f);
            Matrix4f matrix4f = matrixStack.m_85850_().m_252922_();
            float backgroundOpacity = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
            int j = (int)(backgroundOpacity * 255.0f) << 24;
            MutableComponent info = Component.m_237110_((String)(cat.getSex() == Genetics.Sex.FEMALE ? (cat.getBreedingStatus(SimplyCatEntity.BreedingStatus.HEAT) ? "chat.info.in_heat" : "chat.info.not_in_heat") : "chat.info.male"), (Object[])new Object[]{cat.getMateTimer()});
            if (cat.getBreedingStatus(SimplyCatEntity.BreedingStatus.PREGNANT)) {
                info = Component.m_237110_((String)(cat.getBreedingStatus(SimplyCatEntity.BreedingStatus.HEAT) ? "chat.info.pregnant_heat" : "chat.info.pregnant"), (Object[])new Object[]{cat.getMateTimer()});
            }
            Font fontRenderer = this.m_114481_();
            float centeredPos = -fontRenderer.m_92852_((FormattedText)info) / 2;
            fontRenderer.m_272077_((Component)info, centeredPos, 0.0f, 0x20FFFFFF, false, matrix4f, renderTypeBuffer, catNotSneaking ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, j, p_225629_5_);
            if (catNotSneaking) {
                fontRenderer.m_272077_((Component)info, centeredPos, 0.0f, -1, false, matrix4f, renderTypeBuffer, Font.DisplayMode.NORMAL, 0, p_225629_5_);
            }
            matrixStack.m_85849_();
        }
    }
}

