/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.entity.goal;

import com.github.mnesikos.simplycats.SimplyCats;
import com.github.mnesikos.simplycats.configuration.SCConfig;
import com.github.mnesikos.simplycats.entity.SimplyCatEntity;
import com.github.mnesikos.simplycats.entity.core.Genetics;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.eventbus.api.Event;

public class CatBirthGoal
extends Goal {
    private final SimplyCatEntity mother;
    private SimplyCatEntity father;
    Level level;

    public CatBirthGoal(SimplyCatEntity catEntity) {
        this.mother = catEntity;
        this.level = catEntity.m_9236_();
    }

    public boolean m_8036_() {
        if (this.mother.getSex() != Genetics.Sex.FEMALE || !this.mother.getBreedingStatus(SimplyCatEntity.BreedingStatus.PREGNANT) || this.mother.getBreedingStatus(SimplyCatEntity.BreedingStatus.HEAT)) {
            return false;
        }
        if (this.mother.getMateTimer() >= 0) {
            return false;
        }
        return !this.mother.m_21824_() || this.mother.m_269323_() != null;
    }

    public boolean m_8045_() {
        return this.mother.getBreedingStatus(SimplyCatEntity.BreedingStatus.PREGNANT);
    }

    public void m_8041_() {
        this.father = null;
    }

    public void m_8037_() {
        for (int i = 0; i < this.mother.getKittens(); ++i) {
            this.father = new SimplyCatEntity((EntityType<? extends TamableAnimal>)((EntityType)SimplyCats.CAT.get()), this.level);
            this.father.m_20258_(this.mother.getFather(i));
            this.spawnBaby(this.father);
            this.mother.getPersistentData().m_128473_("Father" + i);
        }
        this.mother.setKittens(0);
        this.mother.setBreedingStatus(SimplyCatEntity.BreedingStatus.PREGNANT, false);
        this.mother.setHeatCycle(false, (Integer)SCConfig.heat_cooldown.get());
    }

    private void spawnBaby(SimplyCatEntity father) {
        ServerLevel serverWorld = (ServerLevel)this.level;
        SimplyCatEntity child = (SimplyCatEntity)this.mother.m_142606_(serverWorld, (AgeableMob)father);
        BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((Mob)this.mother, (Mob)father, (AgeableMob)child);
        boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)event);
        child = (SimplyCatEntity)event.getChild();
        if (cancelled) {
            return;
        }
        if (child != null) {
            child.m_146762_(-((Integer)SCConfig.kitten_mature_timer.get()).intValue());
            child.setMatureTimer(((Integer)SCConfig.kitten_mature_timer.get()).intValue());
            child.m_7678_(this.mother.m_20185_(), this.mother.m_20186_(), this.mother.m_20189_(), 0.0f, 0.0f);
            child.setFather(this.father.m_20148_());
            child.setMother(this.mother.m_20148_());
            serverWorld.m_47205_((Entity)child);
            serverWorld.m_7605_((Entity)this.mother, (byte)18);
            RandomSource random = this.mother.m_217043_();
            for (int i = 0; i < 7; ++i) {
                double d0 = random.m_188583_() * 0.02;
                double d1 = random.m_188583_() * 0.02;
                double d2 = random.m_188583_() * 0.02;
                this.level.m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.mother.m_20208_(1.0), this.mother.m_20187_() + 0.5, this.mother.m_20262_(1.0), d0, d1, d2);
            }
            if (serverWorld.m_46469_().m_46207_(GameRules.f_46135_)) {
                serverWorld.m_7967_((Entity)new ExperienceOrb((Level)serverWorld, this.mother.m_20185_(), this.mother.m_20186_(), this.mother.m_20189_(), this.mother.m_217043_().m_188503_(2) + 1));
            }
        }
    }
}

