/*
 * Decompiled with CFR 0.152.
 */
package com.tatnux.crafter.modules.crafter.blocks;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.tatnux.crafter.config.Config;
import com.tatnux.crafter.lib.list.NonNullListFactory;
import com.tatnux.crafter.lib.menu.InventoryTools;
import com.tatnux.crafter.lib.menu.UndoableItemHandler;
import com.tatnux.crafter.modules.crafter.SmartCrafterModule;
import com.tatnux.crafter.modules.crafter.blocks.SmartCrafterBlock;
import com.tatnux.crafter.modules.crafter.blocks.SmartCrafterMenu;
import com.tatnux.crafter.modules.crafter.blocks.inventory.AutomationInventory;
import com.tatnux.crafter.modules.crafter.blocks.inventory.CrafterInventory;
import com.tatnux.crafter.modules.crafter.blocks.inventory.WorkingCraftingInventory;
import com.tatnux.crafter.modules.crafter.data.CraftMode;
import com.tatnux.crafter.modules.crafter.data.CrafterRecipe;
import com.tatnux.crafter.modules.crafter.data.GhostSlots;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartCrafterBlockEntity
extends KineticBlockEntity
implements MenuProvider {
    public final CrafterInventory inventory;
    private final AutomationInventory automationInventory;
    private final LazyOptional<IItemHandler> inventoryProvider;
    public final NonNullList<CrafterRecipe> recipes;
    public byte selectedRecipeIndex = 0;
    public boolean keepMode = false;
    public GhostSlots ghostSlots;
    private final CraftingContainer workInventory = new WorkingCraftingInventory();
    private float craftingProgress = 0.0f;
    private boolean cannotCraftCurrently = false;

    public SmartCrafterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inventory = new CrafterInventory(this);
        this.automationInventory = new AutomationInventory(this.inventory);
        this.inventoryProvider = LazyOptional.of(() -> this.automationInventory);
        this.ghostSlots = new GhostSlots();
        this.recipes = NonNullListFactory.fill(9, CrafterRecipe::new);
    }

    public void select(byte index) {
        if (this.selectedRecipeIndex == index) {
            return;
        }
        this.selectedRecipeIndex = index;
        CrafterRecipe crafterRecipe = this.getSelectedRecipe();
        this.inventory.setStackInSlot(0, crafterRecipe.getOutput());
        for (int i = 0; i < crafterRecipe.getItems().size(); ++i) {
            this.inventory.setStackInSlot(1 + i, (ItemStack)crafterRecipe.getItems().get(i));
        }
    }

    public void reset(byte index) {
        if (this.selectedRecipeIndex != index) {
            return;
        }
        this.transferRecipe((NonNullList<ItemStack>)NonNullList.m_122780_((int)10, (Object)ItemStack.f_41583_));
        this.retryCrafting();
    }

    public void retryCrafting() {
        this.cannotCraftCurrently = false;
    }

    public void setCraftMode(CraftMode mode) {
        this.getSelectedRecipe().setCraftMode(mode);
        this.notifyUpdate();
    }

    public void setKeepMode(boolean keep) {
        this.keepMode = keep;
        this.notifyUpdate();
    }

    public CrafterRecipe getSelectedRecipe() {
        return (CrafterRecipe)this.recipes.get((int)this.selectedRecipeIndex);
    }

    public void saveRecipe(CraftingRecipe recipe, List<ItemStack> items, ItemStack output) {
        this.getSelectedRecipe().setCraftingGrid(items, output);
        this.getSelectedRecipe().setRecipe(recipe);
        this.inventory.setStackInSlot(0, output);
        this.retryCrafting();
    }

    public void updateGhostItems(boolean reset) {
        if (reset) {
            this.ghostSlots.clear();
        } else {
            for (byte i = 10; i < 32; i = (byte)((byte)(i + 1))) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                this.ghostSlots.addSlot(stack.m_255036_(1), i);
            }
        }
        this.notifyUpdate();
        this.retryCrafting();
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (slot >= 10 && slot < 32) {
            return this.ghostSlots.mayPlace((byte)slot, stack);
        }
        return true;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.isItemHandlerCap(cap)) {
            return this.inventoryProvider.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryProvider.invalidate();
    }

    @NotNull
    public Component m_5446_() {
        return ((SmartCrafterBlock)((Object)SmartCrafterModule.SMART_CRAFTER.get())).m_49954_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inv, @NotNull Player player) {
        return SmartCrafterMenu.create(id, inv, this);
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.m_5776_() || this.getSpeed() == 0.0f || this.cannotCraftCurrently || this.f_58857_.m_277086_(this.f_58858_) > 0) {
            return;
        }
        float speedFactor = Math.abs(this.getSpeed()) / (float)((Integer)Config.common().speedRatio.get()).intValue();
        this.craftingProgress += speedFactor;
        float progressNeeded = ((Integer)Config.common().crafterProgressNeeded.get()).intValue();
        while (this.craftingProgress >= progressNeeded) {
            if (!this.attemptCrafting()) {
                this.cannotCraftCurrently = true;
                break;
            }
            this.craftingProgress -= progressNeeded;
        }
    }

    private boolean attemptCrafting() {
        return this.recipes.stream().anyMatch(this::craftRecipe);
    }

    private boolean craftRecipe(CrafterRecipe recipe) {
        Optional<CraftingRecipe> optionalRecipe = recipe.getCachedRecipe(this.f_58857_);
        if (optionalRecipe.isEmpty()) {
            return false;
        }
        UndoableItemHandler undoHandler = new UndoableItemHandler((IItemHandlerModifiable)this.inventory);
        if (!this.canCraft(recipe, undoHandler)) {
            undoHandler.restore();
            return false;
        }
        CraftingRecipe craftingRecipe = optionalRecipe.get();
        ItemStack result = craftingRecipe.m_5874_((Container)this.workInventory, this.f_58857_.m_9598_());
        CraftMode mode = recipe.getCraftMode();
        if (!result.m_41619_() && this.placeResult(mode, undoHandler, result)) {
            NonNullList remainingItems = craftingRecipe.m_7457_((Container)this.workInventory);
            CraftMode remainingMode = mode == CraftMode.EXTC ? CraftMode.INT : mode;
            for (ItemStack item : remainingItems) {
                if (item.m_41619_() || this.placeResult(remainingMode, undoHandler, item)) continue;
                return false;
            }
            return true;
        }
        undoHandler.restore();
        return false;
    }

    private boolean canCraft(CrafterRecipe crafterRecipe, UndoableItemHandler undoHandler) {
        int n;
        int width;
        int keepCount = this.keepMode ? 1 : 0;
        for (int i = 0; i < this.workInventory.m_6643_(); ++i) {
            this.workInventory.m_6836_(i, ItemStack.f_41583_);
        }
        CraftingRecipe recipe = crafterRecipe.getRecipe();
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shaped = (ShapedRecipe)recipe;
            v0 = shaped.getRecipeWidth();
        } else {
            v0 = width = 3;
        }
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shaped = (ShapedRecipe)recipe;
            n = shaped.getRecipeHeight();
        } else {
            n = 3;
        }
        int height = n;
        NonNullList ingredients = recipe.m_7527_();
        for (int x = 0; x < width; ++x) {
            block2: for (int y = 0; y < height; ++y) {
                int index = y * width + x;
                if (index >= ingredients.size() || ingredients.get(index) == Ingredient.f_43901_) continue;
                Ingredient ingredient = (Ingredient)ingredients.get(index);
                for (int j = 0; j < 18; ++j) {
                    int slot = 10 + j;
                    ItemStack input = undoHandler.getStackInSlot(slot);
                    if (input.m_41619_() || input.m_41613_() <= keepCount || !ingredient.test(input)) continue;
                    undoHandler.remember(slot);
                    ItemStack consumed = input.m_41620_(1);
                    this.workInventory.m_6836_(y * 3 + x, consumed);
                    continue block2;
                }
            }
        }
        return recipe.m_5818_((Container)this.workInventory, this.f_58857_);
    }

    private boolean placeResult(CraftMode mode, IItemHandlerModifiable undoHandler, ItemStack result) {
        int stop;
        int start = mode == CraftMode.INT ? 10 : 28;
        ItemStack remaining = InventoryTools.insertItemRanged((IItemHandler)undoHandler, result, start, stop = mode == CraftMode.INT ? 28 : 32, true);
        if (remaining.m_41619_()) {
            InventoryTools.insertItemRanged((IItemHandler)undoHandler, result, start, stop, false);
            return true;
        }
        return false;
    }

    public void updateWorkInventory() {
        if (this.m_58904_().f_46443_) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            this.workInventory.m_6836_(i, this.inventory.getStackInSlot(i + 1));
        }
        CrafterRecipe.findRecipe(this.m_58904_(), this.workInventory).ifPresentOrElse(recipe -> {
            ItemStack result = recipe.m_5874_((Container)this.workInventory, this.m_58904_().m_9598_());
            this.saveRecipe((CraftingRecipe)recipe, this.workInventory.m_280657_(), result);
        }, () -> this.saveRecipe(null, this.workInventory.m_280657_(), ItemStack.f_41583_));
    }

    public void transferRecipe(NonNullList<ItemStack> stacks) {
        if (stacks.isEmpty()) {
            return;
        }
        this.inventory.setStackInSlot(0, (ItemStack)stacks.get(0));
        for (int i = 1; i < stacks.size(); ++i) {
            this.inventory.setStackInSlot(1 + i - 1, (ItemStack)stacks.get(i));
        }
        this.updateWorkInventory();
        this.m_6596_();
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        tag.m_128344_("SelectedRecipe", this.selectedRecipeIndex);
        ListTag recipesTag = new ListTag();
        for (CrafterRecipe recipe : this.recipes) {
            CompoundTag recipeTag = new CompoundTag();
            recipeTag.m_128365_("Recipe", (Tag)recipe.serializeNBT());
            recipesTag.add((Object)recipeTag);
        }
        tag.m_128365_("Recipes", (Tag)recipesTag);
        tag.m_128379_("KeepMode", this.keepMode);
        tag.m_128365_("GhostSlots", (Tag)this.ghostSlots.serializeNBT());
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.inventory.deserializeNBT(tag.m_128469_("Inventory"));
        this.selectedRecipeIndex = tag.m_128445_("SelectedRecipe");
        ListTag recipesTag = tag.m_128437_("Recipes", 10);
        for (int i = 0; i < recipesTag.size(); ++i) {
            CompoundTag recipeTag = recipesTag.m_128728_(i);
            ((CrafterRecipe)this.recipes.get(i)).deserializeNBT(recipeTag.m_128469_("Recipe"));
        }
        this.keepMode = tag.m_128471_("KeepMode");
        this.ghostSlots.deserializeNBT(tag.m_128437_("GhostSlots", 10));
    }
}

