/*
 * Decompiled with CFR 0.152.
 */
package com.tatnux.crafter.modules.crafter.blocks.inventory;

import com.tatnux.crafter.modules.crafter.blocks.SmartCrafterBlockEntity;
import com.tatnux.crafter.modules.crafter.blocks.slots.ItemValidator;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class CrafterInventory
extends ItemStackHandler
implements ItemValidator {
    private final SmartCrafterBlockEntity blockEntity;

    public CrafterInventory(SmartCrafterBlockEntity blockEntity) {
        super(32);
        this.blockEntity = blockEntity;
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        super.setStackInSlot(slot, stack);
        this.blockEntity.sendData();
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.blockEntity.sendData();
        this.blockEntity.m_6596_();
        this.blockEntity.retryCrafting();
    }

    public boolean canAutomationInsert(int slot) {
        return slot >= 10 && slot < 28;
    }

    public boolean canAutomationExtract(int slot) {
        return slot >= 28 && slot < 32;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.isItemValidForSlot(slot, stack);
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return this.blockEntity.isItemValidForSlot(slot, stack);
    }
}

