/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.misc.concrete_hose;

import com.drmangotea.tfmg.content.decoration.concrete.ConcreteloggedBlock;
import com.drmangotea.tfmg.content.machinery.misc.concrete_hose.TFMGFluidManipulationBehaviour;
import com.drmangotea.tfmg.registry.TFMGFluids;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.BBHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraft.world.ticks.LevelTicks;

public class ConcreteFillingBehavior
extends TFMGFluidManipulationBehaviour {
    public static final BehaviourType<ConcreteFillingBehavior> TYPE = new BehaviourType();
    PriorityQueue<TFMGFluidManipulationBehaviour.BlockPosEntry> queue = new ObjectHeapPriorityQueue((p, p2) -> -this.comparePositions((TFMGFluidManipulationBehaviour.BlockPosEntry)p, (TFMGFluidManipulationBehaviour.BlockPosEntry)p2));
    List<TFMGFluidManipulationBehaviour.BlockPosEntry> infinityCheckFrontier;
    Set<BlockPos> infinityCheckVisited;

    public ConcreteFillingBehavior(SmartBlockEntity be) {
        super(be);
        this.revalidateIn = 1;
        this.infinityCheckFrontier = new ArrayList<TFMGFluidManipulationBehaviour.BlockPosEntry>();
        this.infinityCheckVisited = new HashSet<BlockPos>();
    }

    public void tick() {
        Fluid fluid;
        super.tick();
        if (!this.infinityCheckFrontier.isEmpty() && this.rootPos != null && (fluid = this.getWorld().m_6425_(this.rootPos).m_76152_()) != Fluids.f_76191_) {
            this.continueValidation(fluid);
        }
        if (this.revalidateIn > 0) {
            --this.revalidateIn;
        }
    }

    protected void continueValidation(Fluid fluid) {
        try {
            this.search(fluid, this.infinityCheckFrontier, this.infinityCheckVisited, (p, d) -> this.infinityCheckFrontier.add(new TFMGFluidManipulationBehaviour.BlockPosEntry((BlockPos)p, (int)d)), true);
        }
        catch (TFMGFluidManipulationBehaviour.ChunkNotLoadedException e) {
            this.infinityCheckFrontier.clear();
            this.infinityCheckVisited.clear();
            this.setLongValidationTimer();
            return;
        }
        int maxBlocks = this.maxBlocks();
        if (this.infinityCheckVisited.size() > maxBlocks && maxBlocks != -1 && !this.fillInfinite()) {
            if (!this.infinite) {
                this.reset();
                this.infinite = true;
                this.blockEntity.sendData();
            }
            this.infinityCheckFrontier.clear();
            this.setLongValidationTimer();
            return;
        }
        if (!this.infinityCheckFrontier.isEmpty()) {
            return;
        }
        if (this.infinite) {
            this.reset();
            return;
        }
        this.infinityCheckVisited.clear();
    }

    public boolean tryDeposit(Fluid fluid, BlockPos root, boolean simulate) {
        if (!Objects.equals(root, this.rootPos)) {
            this.reset();
            this.rootPos = root;
            this.queue.enqueue((Object)new TFMGFluidManipulationBehaviour.BlockPosEntry(root, 0));
            this.affectedArea = BoundingBox.m_162375_((Vec3i)this.rootPos, (Vec3i)this.rootPos);
            return false;
        }
        if (this.counterpartActed) {
            this.counterpartActed = false;
            this.softReset(root);
            return false;
        }
        if (this.affectedArea == null) {
            this.affectedArea = BoundingBox.m_162375_((Vec3i)root, (Vec3i)root);
        }
        Level world = this.getWorld();
        int maxRange = this.maxRange();
        int maxRangeSq = maxRange * maxRange;
        int maxBlocks = this.maxBlocks();
        boolean evaporate = world.m_6042_().f_63857_() && FluidHelper.isTag((Fluid)fluid, (TagKey)FluidTags.f_13131_);
        boolean canPlaceSources = (Boolean)AllConfigs.server().fluids.fluidFillPlaceFluidSourceBlocks.get();
        if (!this.fillInfinite() && this.infinite || evaporate || !canPlaceSources) {
            FluidState fluidState = world.m_6425_(this.rootPos);
            boolean equivalentTo = fluidState.m_76152_().m_6212_(fluid);
            if (!equivalentTo && !evaporate && canPlaceSources) {
                return false;
            }
            if (simulate) {
                return true;
            }
            this.playEffect(world, root, fluid, false);
            if (evaporate) {
                int i = root.m_123341_();
                int j = root.m_123342_();
                int k = root.m_123343_();
                world.m_6263_(null, (double)i, (double)j, (double)k, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.8f);
            }
            return true;
        }
        boolean success = false;
        for (int i = 0; !success && !this.queue.isEmpty() && i < 1024; ++i) {
            SpaceType spaceType;
            TFMGFluidManipulationBehaviour.BlockPosEntry entry = (TFMGFluidManipulationBehaviour.BlockPosEntry)this.queue.first();
            BlockPos currentPos = entry.pos();
            if (this.visited.contains(currentPos)) {
                this.queue.dequeue();
                continue;
            }
            if (!simulate) {
                this.visited.add(currentPos);
            }
            if (this.visited.size() >= maxBlocks && maxBlocks != -1) {
                this.infinite = true;
                if (!this.fillInfinite()) {
                    this.visited.clear();
                    this.queue.clear();
                    return false;
                }
            }
            if ((spaceType = this.getAtPos(world, currentPos, fluid)) == SpaceType.BLOCKING) continue;
            if (spaceType == SpaceType.FILLABLE) {
                success = true;
                if (!simulate) {
                    LevelTickAccess pendingFluidTicks;
                    this.playEffect(world, currentPos, fluid, false);
                    BlockState blockState = world.m_8055_(currentPos);
                    if (blockState.m_61138_((Property)ConcreteloggedBlock.CONCRETELOGGED) && fluid.m_6212_((Fluid)TFMGFluids.LIQUID_CONCRETE.getSource())) {
                        if (!this.blockEntity.isVirtual()) {
                            world.m_7731_(currentPos, (BlockState)blockState.m_61124_((Property)ConcreteloggedBlock.CONCRETELOGGED, (Comparable)Boolean.valueOf(true)), 18);
                        }
                    } else {
                        this.replaceBlock(world, currentPos, blockState);
                        if (!this.blockEntity.isVirtual()) {
                            world.m_7731_(currentPos, FluidHelper.convertToStill((Fluid)fluid).m_76145_().m_76188_(), 18);
                        }
                    }
                    if ((pendingFluidTicks = world.m_183324_()) instanceof LevelTicks) {
                        LevelTicks serverTickList = (LevelTicks)pendingFluidTicks;
                        serverTickList.m_193234_(new BoundingBox(currentPos));
                    }
                    this.affectedArea = BBHelper.encapsulate((BoundingBox)this.affectedArea, (BlockPos)currentPos);
                }
            }
            if (simulate && success) {
                return true;
            }
            this.visited.add(currentPos);
            this.queue.dequeue();
            for (Direction side : Iterate.directions) {
                SpaceType nextSpaceType;
                BlockPos offsetPos;
                if (side == Direction.UP || this.visited.contains(offsetPos = currentPos.m_121945_(side)) || offsetPos.m_123331_((Vec3i)this.rootPos) > (double)maxRangeSq || (nextSpaceType = this.getAtPos(world, offsetPos, fluid)) == SpaceType.BLOCKING) continue;
                this.queue.enqueue((Object)new TFMGFluidManipulationBehaviour.BlockPosEntry(offsetPos, entry.distance() + 1));
            }
        }
        if (!simulate && success) {
            this.blockEntity.award(AllAdvancements.HOSE_PULLEY);
        }
        return success;
    }

    protected void softReset(BlockPos root) {
        this.visited.clear();
        this.queue.clear();
        this.queue.enqueue((Object)new TFMGFluidManipulationBehaviour.BlockPosEntry(root, 0));
        this.infinite = false;
        this.setValidationTimer();
        this.blockEntity.sendData();
    }

    protected SpaceType getAtPos(Level world, BlockPos pos, Fluid toFill) {
        BlockState blockState = world.m_8055_(pos);
        if (pos == this.rootPos) {
            return SpaceType.FILLED;
        }
        if (blockState.m_61138_((Property)ConcreteloggedBlock.CONCRETELOGGED)) {
            return toFill.m_6212_((Fluid)TFMGFluids.LIQUID_CONCRETE.getSource()) ? (((Boolean)blockState.m_61143_((Property)ConcreteloggedBlock.CONCRETELOGGED)).booleanValue() ? SpaceType.FILLED : SpaceType.FILLABLE) : SpaceType.BLOCKING;
        }
        return SpaceType.BLOCKING;
    }

    protected void replaceBlock(Level world, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = state.m_155947_() ? world.m_7702_(pos) : null;
        Block.m_49892_((BlockState)state, (LevelAccessor)world, (BlockPos)pos, (BlockEntity)blockEntity);
    }

    @Override
    public void reset() {
        super.reset();
        this.queue.clear();
        this.infinityCheckFrontier.clear();
        this.infinityCheckVisited.clear();
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    static enum SpaceType {
        FILLABLE,
        FILLED,
        BLOCKING;

    }
}

