/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.yaf.block;

import com.starfish_studios.yaf.block.properties.ColorList;
import com.starfish_studios.yaf.registry.YAFSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LampBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final EnumProperty<LampType> LAMP_TYPE = EnumProperty.m_61587_((String)"lamp_type", LampType.class);
    public static final EnumProperty<ColorList> LAMPSHADE = EnumProperty.m_61587_((String)"lampshade", ColorList.class);
    protected static final VoxelShape SINGLE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0);
    protected static final VoxelShape TOP = Block.m_49796_((double)3.0, (double)7.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    protected static final VoxelShape MIDDLE = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    protected static final VoxelShape BOTTOM = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0);

    public LampBlock(BlockBehaviour.Properties properties) {
        super(properties);
        ((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_(LAMP_TYPE, (Comparable)((Object)LampType.SINGLE))).m_61124_(LAMPSHADE, (Comparable)((Object)ColorList.WHITE));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch (((LampType)((Object)state.m_61143_(LAMP_TYPE))).ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> Shapes.m_83124_((VoxelShape)SINGLE, (VoxelShape[])new VoxelShape[]{MIDDLE, TOP});
            case 1 -> Shapes.m_83110_((VoxelShape)BOTTOM, (VoxelShape)MIDDLE);
            case 2 -> MIDDLE;
            case 3 -> Shapes.m_83110_((VoxelShape)TOP, (VoxelShape)MIDDLE);
        };
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_) {
            BlockItem blockItem;
            ItemStack heldItem = player.m_21120_(hand);
            Item item = heldItem.m_41720_();
            if (item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof LampBlock) {
                BlockPos currentPos = pos.m_7494_();
                while (level.m_8055_(currentPos).m_60734_() instanceof LampBlock) {
                    currentPos = currentPos.m_7494_();
                }
                if (level.m_8055_(currentPos).m_247087_() && currentPos.m_123342_() <= level.m_151558_()) {
                    BlockPos topLampPos = currentPos.m_7495_();
                    BlockState topLampState = level.m_8055_(topLampPos);
                    if (topLampState.m_61143_(LAMP_TYPE) == LampType.SINGLE) {
                        level.m_7731_(topLampPos, (BlockState)topLampState.m_61124_(LAMP_TYPE, (Comparable)((Object)LampType.BOTTOM)), 3);
                    } else {
                        level.m_7731_(topLampPos, (BlockState)topLampState.m_61124_(LAMP_TYPE, (Comparable)((Object)LampType.MIDDLE)), 3);
                    }
                    level.m_7731_(currentPos, (BlockState)state.m_61124_(LAMP_TYPE, (Comparable)((Object)LampType.TOP)), 3);
                }
            } else {
                float f;
                BlockPos topLampPos = pos;
                while (level.m_8055_(topLampPos.m_7494_()).m_60734_() instanceof LampBlock) {
                    topLampPos = topLampPos.m_7494_();
                }
                float f2 = f = (Boolean)level.m_8055_(topLampPos).m_61143_((Property)LIT) != false ? 0.8f : 0.7f;
                if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                    level.m_5594_(null, pos, (SoundEvent)YAFSoundEvents.LAMP_OFF.get(), SoundSource.BLOCKS, f, 1.0f);
                } else {
                    level.m_5594_(null, pos, (SoundEvent)YAFSoundEvents.LAMP_ON.get(), SoundSource.BLOCKS, f, 1.0f);
                }
                level.m_7731_(topLampPos, (BlockState)level.m_8055_(topLampPos).m_61122_((Property)LIT), 3);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        boolean waterlogged = level.m_6425_(pos).m_76152_().m_6212_((Fluid)Fluids.f_76193_);
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_(LAMPSHADE, (Comparable)((Object)ColorList.WHITE))).m_61124_(LAMP_TYPE, (Comparable)((Object)LampType.SINGLE));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, LIT, LAMP_TYPE, LAMPSHADE});
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            level.m_186460_(pos, (Block)this, 1);
        }
        LampType thisType = (LampType)((Object)state.m_61143_(LAMP_TYPE));
        BlockState aboveState = level.m_8055_(pos.m_7494_());
        if (!(aboveState.m_60734_() instanceof LampBlock)) {
            if (thisType == LampType.MIDDLE) {
                level.m_7731_(pos, (BlockState)state.m_61124_(LAMP_TYPE, (Comparable)((Object)LampType.TOP)), 3);
            }
            if (thisType == LampType.BOTTOM) {
                level.m_7731_(pos, (BlockState)state.m_61124_(LAMP_TYPE, (Comparable)((Object)LampType.SINGLE)), 3);
            }
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        LampType type = (LampType)((Object)state.m_61143_(LAMP_TYPE));
        boolean belowIsLamp = level.m_8055_(pos.m_7495_()).m_60734_() instanceof LampBlock;
        boolean aboveIsLamp = level.m_8055_(pos.m_7494_()).m_60734_() instanceof LampBlock;
        return switch (type.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> super.m_7898_(state, level, pos);
            case 2, 3 -> belowIsLamp;
            case 1 -> aboveIsLamp;
        };
    }

    public static enum LampType implements StringRepresentable
    {
        SINGLE("single"),
        BOTTOM("bottom"),
        MIDDLE("middle"),
        TOP("top");

        private final String name;

        private LampType(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

