/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.blocks;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.gearbox.GearboxBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import fr.iglee42.createcasing.config.ModConfigs;
import fr.iglee42.createcasing.registries.EncasedBlockEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;

public class ConfigurableGearboxBlock
extends KineticBlock
implements IBE<GearboxBlockEntity> {
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final BooleanProperty DOWN = BlockStateProperties.f_61367_;

    public ConfigurableGearboxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return Direction.Axis.Y;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Direction face = context.m_43719_();
        if (!((Boolean)state.m_61143_((Property)ConfigurableGearboxBlock.getPropertyByDirection(face))).booleanValue()) {
            if (((Boolean)ModConfigs.common().kinetics.configurableGearboxRequiresShaft.get()).booleanValue()) {
                return super.onSneakWrenched(state, context);
            }
            state = (BlockState)state.m_61124_((Property)ConfigurableGearboxBlock.getPropertyByDirection(face), (Comparable)Boolean.valueOf(true));
            if (((Boolean)ModConfigs.common().kinetics.configurableGearboxChangeTwoFaces.get()).booleanValue()) {
                state = (BlockState)state.m_61124_((Property)ConfigurableGearboxBlock.getPropertyByDirection(face.m_122424_()), (Comparable)Boolean.valueOf(true));
            }
        } else {
            state = (BlockState)state.m_61124_((Property)ConfigurableGearboxBlock.getPropertyByDirection(face), (Comparable)Boolean.valueOf(false));
            if (((Boolean)ModConfigs.common().kinetics.configurableGearboxChangeTwoFaces.get()).booleanValue()) {
                state = (BlockState)state.m_61124_((Property)ConfigurableGearboxBlock.getPropertyByDirection(face.m_122424_()), (Comparable)Boolean.valueOf(false));
            }
            if (((Boolean)ModConfigs.common().kinetics.configurableGearboxRequiresShaft.get()).booleanValue() && context.m_43723_() != null && !context.m_43723_().m_7500_()) {
                context.m_43723_().m_36356_(AllBlocks.SHAFT.asStack());
            }
        }
        return super.onWrenched(state, context);
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        if (context.m_43725_().f_46443_) {
            return InteractionResult.m_19078_((boolean)true);
        }
        Direction face = context.m_43719_().m_122424_();
        if (!((Boolean)state.m_61143_((Property)ConfigurableGearboxBlock.getPropertyByDirection(face))).booleanValue()) {
            if (((Boolean)ModConfigs.common().kinetics.configurableGearboxRequiresShaft.get()).booleanValue()) {
                return super.onSneakWrenched(state, context);
            }
            state = (BlockState)state.m_61124_((Property)ConfigurableGearboxBlock.getPropertyByDirection(face), (Comparable)Boolean.valueOf(true));
            if (((Boolean)ModConfigs.common().kinetics.configurableGearboxChangeTwoFaces.get()).booleanValue()) {
                state = (BlockState)state.m_61124_((Property)ConfigurableGearboxBlock.getPropertyByDirection(face.m_122424_()), (Comparable)Boolean.valueOf(true));
            }
        } else {
            state = (BlockState)state.m_61124_((Property)ConfigurableGearboxBlock.getPropertyByDirection(face), (Comparable)Boolean.valueOf(false));
            if (((Boolean)ModConfigs.common().kinetics.configurableGearboxChangeTwoFaces.get()).booleanValue()) {
                state = (BlockState)state.m_61124_((Property)ConfigurableGearboxBlock.getPropertyByDirection(face.m_122424_()), (Comparable)Boolean.valueOf(false));
            }
            if (((Boolean)ModConfigs.common().kinetics.configurableGearboxRequiresShaft.get()).booleanValue() && context.m_43723_() != null && !context.m_43723_().m_7500_()) {
                context.m_43723_().m_36356_(AllBlocks.SHAFT.asStack());
            }
        }
        KineticBlockEntity.switchToBlockState((Level)context.m_43725_(), (BlockPos)context.m_8083_(), (BlockState)state);
        return InteractionResult.SUCCESS;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (level.f_46443_) {
            return InteractionResult.m_19078_((boolean)true);
        }
        if (player.m_21120_(hand).m_41619_()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        Direction face = result.m_82434_();
        if (!stack.m_150930_(AllBlocks.SHAFT.m_5456_())) {
            return InteractionResult.PASS;
        }
        if (player.m_6047_()) {
            face = face.m_122424_();
        }
        if (!((Boolean)state.m_61143_((Property)ConfigurableGearboxBlock.getPropertyByDirection(face))).booleanValue()) {
            if (!((Boolean)ModConfigs.common().kinetics.configurableGearboxRequiresShaft.get()).booleanValue()) {
                return InteractionResult.PASS;
            }
            state = (BlockState)state.m_61124_((Property)ConfigurableGearboxBlock.getPropertyByDirection(face), (Comparable)Boolean.valueOf(true));
            if (((Boolean)ModConfigs.common().kinetics.configurableGearboxChangeTwoFaces.get()).booleanValue()) {
                state = (BlockState)state.m_61124_((Property)ConfigurableGearboxBlock.getPropertyByDirection(face.m_122424_()), (Comparable)Boolean.valueOf(true));
            }
            KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)pos, (BlockState)state);
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return (Boolean)state.m_61143_((Property)ConfigurableGearboxBlock.getPropertyByDirection(face));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN});
        super.m_7926_(builder);
    }

    protected boolean areStatesKineticallyEquivalent(BlockState oldState, BlockState newState) {
        return super.areStatesKineticallyEquivalent(oldState, newState) && oldState.m_61148_().equals((Object)newState.m_61148_());
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        List stacks = super.m_49635_(state, builder);
        if (!((Boolean)ModConfigs.common().kinetics.configurableGearboxRequiresShaft.get()).booleanValue()) {
            return stacks;
        }
        int shaftCount = 0;
        if (((Boolean)ModConfigs.common().kinetics.configurableGearboxChangeTwoFaces.get()).booleanValue()) {
            if (((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
                ++shaftCount;
            }
            if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
                ++shaftCount;
            }
            if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
                ++shaftCount;
            }
        } else {
            if (((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
                ++shaftCount;
            }
            if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
                ++shaftCount;
            }
            if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
                ++shaftCount;
            }
            if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
                ++shaftCount;
            }
            if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
                ++shaftCount;
            }
            if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
                ++shaftCount;
            }
        }
        if (shaftCount > 0) {
            stacks.add(AllBlocks.SHAFT.asStack(shaftCount));
        }
        return stacks;
    }

    public static BooleanProperty getPropertyByDirection(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> DOWN;
            case Direction.UP -> UP;
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            case Direction.EAST -> EAST;
        };
    }

    public Class<GearboxBlockEntity> getBlockEntityClass() {
        return GearboxBlockEntity.class;
    }

    public BlockEntityType<? extends GearboxBlockEntity> getBlockEntityType() {
        return (BlockEntityType)EncasedBlockEntities.CONFIGURABLE_GEARBOX.get();
    }
}

