/*
 * Decompiled with CFR 0.152.
 */
package snownee.drawer;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import snownee.drawer.ModTags;

public class DrawerIngredient
extends Ingredient {
    private final Ingredient ingredient;
    private final int amount;

    private DrawerIngredient(Ingredient ingredient, int amount) {
        super(Stream.of(new DrawerList(ingredient, amount)));
        this.ingredient = ingredient;
        this.amount = amount;
    }

    public boolean isSimple() {
        return false;
    }

    public Serializer getSerializer() {
        return Serializer.INSTANCE;
    }

    public boolean test(ItemStack stack) {
        if (!stack.m_204117_(ModTags.DRAWERS)) {
            return false;
        }
        try {
            CompoundTag tile = stack.m_41737_("tile");
            if (tile == null || !tile.m_128441_("Drawers")) {
                return false;
            }
            for (Tag nbt : tile.m_128437_("Drawers", 10)) {
                ItemStack content;
                CompoundTag tag = (CompoundTag)nbt;
                int amount = tag.m_128451_("Count");
                if (amount < this.amount || !this.ingredient.test(content = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Item")))) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static class DrawerList
    implements Ingredient.Value {
        public static final Item ITEM = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("storagedrawers", "oak_full_drawers_1"));
        private final Ingredient ingredient;
        private final int amount;

        private DrawerList(Ingredient ingredient, int amount) {
            this.ingredient = ingredient;
            this.amount = amount;
        }

        public Collection<ItemStack> m_6223_() {
            CompoundTag itemTag = new CompoundTag();
            ItemStack[] stacks = this.ingredient.m_43908_();
            if (stacks.length > 0) {
                itemTag.m_128405_("Count", this.amount);
                itemTag.m_128365_("Item", (Tag)stacks[0].serializeNBT());
            }
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("tile", (Tag)new CompoundTag());
            tag.m_128469_("tile").m_128365_("Drawers", (Tag)new ListTag());
            tag.m_128469_("tile").m_128437_("Drawers", 10).add((Object)itemTag);
            ArrayList list = Lists.newArrayList();
            ItemStack stack = new ItemStack((ItemLike)ITEM);
            stack.m_41751_(tag);
            list.add(stack);
            if (list.size() == 0) {
                list.add(new ItemStack((ItemLike)Blocks.f_50375_).m_41714_((Component)Component.m_237113_((String)("Empty Tag: " + ModTags.DRAWERS.f_203868_()))));
            }
            return list;
        }

        public JsonObject m_6544_() {
            return new JsonObject();
        }
    }

    public static enum Serializer implements IIngredientSerializer<DrawerIngredient>
    {
        INSTANCE;


        public DrawerIngredient parse(FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int amount = buffer.m_130242_();
            return new DrawerIngredient(ingredient, amount);
        }

        public DrawerIngredient parse(JsonObject json) {
            Ingredient ingredient = CraftingHelper.getIngredient((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"content"), (boolean)false);
            int amount = GsonHelper.m_13927_((JsonObject)json, (String)"amount");
            return new DrawerIngredient(ingredient, amount);
        }

        public void write(FriendlyByteBuf buffer, DrawerIngredient ingredient) {
            ingredient.ingredient.m_43923_(buffer);
            buffer.m_130130_(ingredient.amount);
        }
    }
}

