/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.fluiddrawerslegacy.api.drawer;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import xueluoanping.fluiddrawerslegacy.ModConstants;
import xueluoanping.fluiddrawerslegacy.api.drawer.DrawerDistanceBook;
import xueluoanping.fluiddrawerslegacy.api.drawer.FluidHolder;
import xueluoanping.fluiddrawerslegacy.block.blockentity.BlockEntityFluidDrawer;

public class betterFluidManager<T extends BlockEntity>
implements IFluidHandler {
    private List<FluidStack> fluidRecord = new ArrayList<FluidStack>();
    private FluidStack fluid = FluidStack.EMPTY;
    private final T tile;

    public betterFluidManager(T tile) {
        if (tile == null) {
            throw new RuntimeException("BlockEntity must implement IDrawerGroup");
        }
        this.tile = tile;
    }

    public void setFluid(FluidStack loadFluidStackFromNBT) {
        this.fluid = loadFluidStackFromNBT;
    }

    public CompoundTag writeToNBT(CompoundTag compoundTag) {
        return this.fluid.writeToNBT(compoundTag);
    }

    public int getDistance(BlockPos pos1, BlockPos pos2) {
        return Math.abs(pos1.m_123341_() - pos2.m_123341_()) + Math.abs(pos1.m_123342_() - pos2.m_123342_()) + Math.abs(pos1.m_123343_() - pos2.m_123343_());
    }

    public List<BlockEntityFluidDrawer.FluidDrawerData> getFluidDrawerDataList() {
        try {
            long startTime = System.currentTimeMillis();
            ArrayList<BlockEntityFluidDrawer.FluidDrawerData> listNew = new ArrayList();
            ArrayList<DrawerDistanceBook> listW = new ArrayList<DrawerDistanceBook>();
            IDrawerGroup handler = (IDrawerGroup)ModConstants.DRAWER_GROUP_CAPABILITY.getCapability(this.tile);
            if (handler != null) {
                int size = handler.getDrawerCount();
                for (int i = 0; i < size; ++i) {
                    IDrawer iDrawer = handler.getDrawer(i);
                    if (!(iDrawer instanceof BlockEntityFluidDrawer.FluidDrawerData)) continue;
                    BlockEntityFluidDrawer.FluidDrawerData fluidDrawerData = (BlockEntityFluidDrawer.FluidDrawerData)iDrawer;
                    int d = this.getDistance(this.tile.m_58899_(), fluidDrawerData.getDrawerPos());
                    listW.add(new DrawerDistanceBook(fluidDrawerData, d));
                }
                Collections.sort(listW);
                listNew = listW.stream().map(DrawerDistanceBook::fluidDrawerData).toList();
                long endTime = System.currentTimeMillis();
                long duration = endTime - startTime;
                return listNew;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ArrayList<BlockEntityFluidDrawer.FluidDrawerData>();
    }

    public List<FluidHolder> getFluidMap(List<BlockEntityFluidDrawer.FluidDrawerData> listNew) {
        LinkedHashMap fluidMap = new LinkedHashMap();
        long startTime = System.currentTimeMillis();
        listNew.forEach(ele -> {
            boolean notEmpty;
            FluidStack fluidStack = ele.getTank().getFluid();
            int capacity = ele.getMaxTankCapacity();
            List<Integer> integerList = new ArrayList<Integer>();
            boolean isEmptyLockWithFluid = ele.isLock() && fluidStack.isEmpty() && !ele.getTank().getCacheFluid().isEmpty();
            boolean bl = notEmpty = fluidStack.getAmount() > 0 && fluidStack != FluidStack.EMPTY;
            if (isEmptyLockWithFluid) {
                fluidStack = ele.getTank().getCacheFluid();
                fluidStack.setAmount(0);
            }
            FluidStack fluidStackKey = fluidStack.copy();
            if (notEmpty && !isEmptyLockWithFluid) {
                fluidStackKey.setAmount(1);
            }
            if (!notEmpty && !isEmptyLockWithFluid) {
                fluidStackKey = FluidStack.EMPTY;
            }
            if (fluidMap.containsKey(fluidStackKey)) {
                integerList = (List)fluidMap.get(fluidStackKey);
                integerList.set(0, (Integer)integerList.get(0) + fluidStack.getAmount());
                integerList.set(1, (Integer)integerList.get(1) + capacity);
                fluidMap.replace(fluidStackKey, (List)fluidMap.get(fluidStackKey), integerList);
            } else {
                integerList.add(fluidStack.getAmount());
                integerList.add(capacity);
                fluidMap.put(fluidStackKey, integerList);
            }
        });
        this.fluidRecord.removeIf(a -> fluidMap.keySet().stream().noneMatch(b -> b.equals(a)));
        this.fluidRecord.addAll(fluidMap.keySet());
        this.fluidRecord = new ArrayList(fluidMap.keySet());
        this.fluidRecord = this.fluidRecord.stream().distinct().collect(Collectors.toList());
        boolean removeEmptyKey = this.fluidRecord.removeIf(FluidStack::isEmpty);
        if (removeEmptyKey) {
            this.fluidRecord.add(FluidStack.EMPTY);
        }
        ArrayList<FluidHolder> fluidHolderList = new ArrayList<FluidHolder>();
        this.fluidRecord.forEach(fluidStack -> {
            FluidHolder holder = new FluidHolder((FluidStack)fluidStack, (Integer)((List)fluidMap.get(fluidStack)).get(0), (Integer)((List)fluidMap.get(fluidStack)).get(1));
            fluidHolderList.add(holder);
        });
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        return fluidHolderList;
    }

    protected int fillByOrder(List<BlockEntityFluidDrawer.FluidDrawerData> drawerDataList, List<Integer> priorityList, FluidStack resource, IFluidHandler.FluidAction action, int order) {
        if (drawerDataList.size() == 0) {
            return 0;
        }
        for (int i = 0; i < drawerDataList.size(); ++i) {
            FluidStack tankFluid;
            if (priorityList.get(i) != order) continue;
            FluidStack tankCacheFluid = drawerDataList.get(i).getTank().getCacheFluid();
            if (drawerDataList.get(i).isLock() && !tankCacheFluid.isEmpty() && !tankCacheFluid.isFluidEqual(resource) || !(tankFluid = drawerDataList.get(i).getTank().getFluid()).isFluidEqual(resource) && !tankFluid.isEmpty()) continue;
            if (resource.getAmount() + drawerDataList.get(i).getTank().getFluid().getAmount() <= drawerDataList.get(i).getTank().getCapacity() || drawerDataList.get(i).isVoid()) {
                if (action.execute()) {
                    drawerDataList.get(i).getTank().fill(resource, IFluidHandler.FluidAction.EXECUTE);
                }
                return resource.getAmount();
            }
            FluidStack fluidStack = resource;
            fluidStack.setAmount(drawerDataList.get(i).getTank().getCapacity() - drawerDataList.get(i).getTank().getFluid().getAmount());
            if (action.execute()) {
                drawerDataList.get(i).getTank().fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            }
            return resource.getAmount() - fluidStack.getAmount();
        }
        return 0;
    }

    private int getFluidDrawerPriority(BlockEntityFluidDrawer.FluidDrawerData data) {
        if (data.getTank().isFull()) {
            return data.isVoid() ? 3 : 6;
        }
        if (data.getTank().isEmpty()) {
            if (data.isLock()) {
                return 5;
            }
            return 4;
        }
        if (!data.isLock()) {
            if (data.isVoid()) {
                return 3;
            }
            return 2;
        }
        if (data.isVoid()) {
            return 1;
        }
        if (data.isLock()) {
            return 0;
        }
        return -1;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        List<BlockEntityFluidDrawer.FluidDrawerData> drawerDataList = this.getFluidDrawerDataList();
        int result = 0;
        int amount = resource.getAmount();
        int amountF = amount;
        if (amountF > 0) {
            ArrayList<Integer> priorityList = new ArrayList<Integer>();
            for (int i = 0; i < drawerDataList.size(); ++i) {
                priorityList.add(this.getFluidDrawerPriority(drawerDataList.get(i)));
            }
            if (drawerDataList.size() == priorityList.size() && drawerDataList.size() > 0) {
                for (int j = 0; j < 6; ++j) {
                    if ((amount -= this.fillByOrder(drawerDataList, priorityList, resource, action, j)) != 0) continue;
                    result = amountF;
                    break;
                }
            }
            if (amount > 0) {
                result = amountF - amount;
            }
        }
        return result;
    }

    public int getTanks() {
        List<BlockEntityFluidDrawer.FluidDrawerData> drawerDataList = this.getFluidDrawerDataList();
        return this.getFluidMap(drawerDataList).size();
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        List<BlockEntityFluidDrawer.FluidDrawerData> drawerDataList = this.getFluidDrawerDataList();
        FluidHolder fluidHolder = this.getFluidMap(drawerDataList).get(tank);
        return new FluidStack(fluidHolder.fluid(), fluidHolder.fluidAmount());
    }

    public int getTankCapacity(int tank) {
        List<BlockEntityFluidDrawer.FluidDrawerData> drawerDataList = this.getFluidDrawerDataList();
        FluidHolder fluidHolder = this.getFluidMap(drawerDataList).get(tank);
        return fluidHolder.tankCapacity();
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        List<BlockEntityFluidDrawer.FluidDrawerData> drawerDataList = this.getFluidDrawerDataList();
        FluidHolder fluidHolder = this.getFluidMap(drawerDataList).get(tank);
        return stack.isFluidEqual(fluidHolder.fluid()) && stack.getAmount() + fluidHolder.fluidAmount() <= fluidHolder.tankCapacity();
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        List<BlockEntityFluidDrawer.FluidDrawerData> drawerDataList = this.getFluidDrawerDataList();
        FluidStack result = FluidStack.EMPTY;
        FluidStack resourceCopy = resource.copy();
        if (!resourceCopy.isEmpty() && resourceCopy.getAmount() > 0) {
            for (int i = 0; i < drawerDataList.size() && resourceCopy.getAmount() > 0; ++i) {
                FluidStack temp;
                int drawerFluidAmount = drawerDataList.get(i).getTank().getFluid().getAmount();
                if (drawerDataList.get(i).getTank().getFluid().isEmpty() || !drawerDataList.get(i).getTank().getFluid().isFluidEqual(resourceCopy) || drawerFluidAmount <= 0 || (temp = drawerDataList.get(i).getTank().drain(resourceCopy, action)).getAmount() <= 0) continue;
                if (result == FluidStack.EMPTY) {
                    result = temp;
                } else {
                    result.grow(temp.getAmount());
                }
                resourceCopy.shrink(temp.getAmount());
            }
        }
        return result;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        List<BlockEntityFluidDrawer.FluidDrawerData> drawerDataList = this.getFluidDrawerDataList();
        List<FluidHolder> fluidHolder = this.getFluidMap(drawerDataList);
        FluidStack result = FluidStack.EMPTY;
        if (maxDrain > 0 && drawerDataList.size() > 0 && fluidHolder.size() > 0) {
            if (this.tile.m_58904_() instanceof ServerLevel && (this.fluid.isEmpty() || !this.fluidRecord.contains(this.fluid))) {
                this.fluid = fluidHolder.get(0).fluid();
            }
            for (int i = 0; i < drawerDataList.size() && maxDrain > 0; ++i) {
                if (drawerDataList.get(i).getTank().getFluid().getFluid() == Fluids.f_76191_ || drawerDataList.get(i).getTank().getFluid().getAmount() <= 0 || !result.isEmpty() && !result.isFluidEqual(drawerDataList.get(i).getTank().getFluid())) continue;
                FluidStack temp = new FluidStack(!result.isEmpty() ? result : this.fluid, maxDrain);
                temp = drawerDataList.get(i).getTank().drain(temp, action);
                if (temp.getAmount() <= 0) continue;
                if (result == FluidStack.EMPTY) {
                    result = temp;
                } else {
                    result.grow(temp.getAmount());
                }
                maxDrain -= temp.getAmount();
            }
        }
        return result;
    }
}

