/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.fluiddrawerslegacy.block;

import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlock;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedSourceBlock;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.block.tile.util.FrameHelper;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeRemote;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import xueluoanping.fluiddrawerslegacy.FluidDrawersLegacyMod;
import xueluoanping.fluiddrawerslegacy.ModContents;
import xueluoanping.fluiddrawerslegacy.api.exchange.FluidExchangeHandlerManager;
import xueluoanping.fluiddrawerslegacy.block.blockentity.BlockEntityFluidDrawer;
import xueluoanping.fluiddrawerslegacy.client.gui.ContainerFluiDrawer;
import xueluoanping.fluiddrawerslegacy.config.General;
import xueluoanping.fluiddrawerslegacy.util.MathUtils;

public class BlockFluidDrawer
extends HorizontalDirectionalBlock
implements INetworked,
EntityBlock,
IFramedSourceBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape shape;
    private static final VoxelShape shapef;
    public final Map<Direction, VoxelShape> getShape;
    private final int slotCount;
    private final boolean half;

    public BlockFluidDrawer(BlockBehaviour.Properties properties, int slotCount, boolean half) {
        super(properties);
        this.slotCount = slotCount;
        this.half = half;
        this.getShape = new HashMap<Direction, VoxelShape>(){
            {
                VoxelShape s = BlockFluidDrawer.this.isHalf() ? shapef : shape;
                this.put(Direction.EAST, MathUtils.getShapefromAngle(s, 270));
                this.put(Direction.SOUTH, MathUtils.getShapefromAngle(s, 180));
                this.put(Direction.WEST, MathUtils.getShapefromAngle(s, 90));
                this.put(Direction.NORTH, s);
            }
        };
    }

    private boolean isHalf() {
        return this.half;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_49915_) {
        super.m_7926_(p_49915_.m_61104_(new Property[]{FACING}));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.getShape.get(state.m_61143_((Property)FACING));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Direction playerFrom = hit.m_82434_();
        if (playerFrom == Direction.UP || playerFrom == Direction.DOWN) {
            return InteractionResult.PASS;
        }
        if (this.isHalf() && playerFrom != facing) {
            return InteractionResult.PASS;
        }
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity instanceof BlockEntityFluidDrawer) {
            final BlockEntityFluidDrawer tile = (BlockEntityFluidDrawer)tileEntity;
            ItemStack heldStack = player.m_21120_(hand);
            ItemStack offhandStack = player.m_21206_();
            if (facing == playerFrom && heldStack.m_41619_() && player.m_6144_()) {
                if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.enableUI.get()).booleanValue() && !world.m_5776_()) {
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                        public Component m_5446_() {
                            return BlockFluidDrawer.this.m_49954_();
                        }

                        @Nullable
                        public AbstractContainerMenu m_7208_(int windowId, Inventory playerInv, Player playerEntity) {
                            return new ContainerFluiDrawer((MenuType)ModContents.containerType.get(), windowId, playerInv, tile);
                        }
                    }, extraData -> extraData.m_130064_(pos));
                    return InteractionResult.SUCCESS;
                }
            } else if (facing == playerFrom && heldStack.m_41720_() instanceof ItemUpgrade) {
                if (tile.upgrades().canAddUpgrade(heldStack)) {
                    Item item = heldStack.m_41720_();
                    if (item instanceof ItemUpgradeRemote) {
                        ItemUpgradeRemote remote = (ItemUpgradeRemote)item;
                        if (tile.upgrades().hasRemoteUpgrade() && remote.isBound()) {
                            tile.upgrades().updateRemoteUpgradeBinding(heldStack);
                            BlockPos boundPosition = ItemUpgradeRemote.getBoundPosition((ItemStack)heldStack);
                            if (boundPosition != null) {
                                player.m_5661_((Component)Component.m_237110_((String)"message.storagedrawers.updated_remote_binding", (Object[])new Object[]{boundPosition.m_123341_(), boundPosition.m_123342_(), boundPosition.m_123343_()}), true);
                            }
                            return InteractionResult.SUCCESS;
                        }
                    }
                    if (tile.upgrades().addUpgrade(heldStack)) {
                        if (!player.m_7500_()) {
                            heldStack.m_41774_(1);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    if (!world.m_5776_()) {
                        player.m_5661_((Component)Component.m_237115_((String)"message.storagedrawers.max_upgrades"), true);
                    }
                } else if (!world.m_5776_()) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.storagedrawers.cannot_add_upgrade"), true);
                }
            } else if (offhandStack == ItemStack.f_41583_ && !player.m_6144_()) {
                IFluidHandler tank;
                Vec3 loc = hit.m_82450_().m_82520_((double)(-pos.m_123341_()), (double)(-pos.m_123342_()), (double)(-pos.m_123343_()));
                int tankSlot = BlockFluidDrawer.getSlotByVec(loc, facing, playerFrom, this.getSlotCount());
                IFluidHandler iFluidHandler = tank = tankSlot == -1 ? tile.getTank() : (IFluidHandler)tile.getDrawer(tankSlot).getTank();
                if (FluidExchangeHandlerManager.tryHandleByMod(tank, player, hand)) {
                    return InteractionResult.SUCCESS;
                }
                if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)tank)) {
                    return InteractionResult.SUCCESS;
                }
                if (FluidExchangeHandlerManager.mayConsume(player, hand)) {
                    return InteractionResult.CONSUME;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public static int getSlotByVec(Vec3 loc, Direction facing, Direction playerFrom, int slotCount) {
        int tankSlot = 0;
        if (slotCount == 2) {
            tankSlot = loc.m_7098_() > 0.5 ? 0 : 1;
        } else if (slotCount == 4) {
            int angle = (int)(facing.m_122435_() - playerFrom.m_122435_());
            if (angle == 0) {
                MathUtils.Point p = new MathUtils.Point(loc);
                FluidDrawersLegacyMod.logger(facing, p.x, p.y, p.z);
                switch (facing) {
                    case EAST: {
                        p = new MathUtils.Point(p.z, p.y, 0.0);
                        break;
                    }
                    case SOUTH: {
                        p = new MathUtils.Point(1.0 - p.x, p.y, 0.0);
                        break;
                    }
                    case WEST: {
                        p = new MathUtils.Point(1.0 - p.z, p.y, 0.0);
                    }
                }
                int xo = p.x < 0.5 ? 1 : 0;
                int yo = p.y < 0.5 ? 2 : 0;
                tankSlot = xo + yo;
            } else {
                tankSlot = angle == 90 || angle == -270 ? (loc.m_7098_() > 0.5 ? 1 : 3) : (loc.m_7098_() > 0.5 ? 0 : 2);
            }
        }
        tankSlot = tankSlot < 0 || tankSlot >= slotCount ? -1 : tankSlot;
        return tankSlot;
    }

    public RenderShape m_7514_(BlockState p_149645_1_) {
        return RenderShape.MODEL;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        ItemStack stack = this.m_5456_().m_7968_();
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof BlockEntityFluidDrawer) {
            BlockEntityFluidDrawer tile = (BlockEntityFluidDrawer)tileEntity;
            tile.writePortable(stack.m_41784_());
        }
        return stack;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof BlockEntityFluidDrawer) {
            BlockEntityFluidDrawer tile = (BlockEntityFluidDrawer)tileEntity;
            tile.readPortable(stack.m_41784_());
        }
        super.m_6402_(level, pos, state, entity, stack);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player playerEntity) {
        BlockEntity blockEntity;
        super.m_5707_(level, pos, state, playerEntity);
        if (level instanceof ServerLevel && !((Boolean)General.retainFluid.get()).booleanValue() && (blockEntity = level.m_7702_(pos)) instanceof BlockEntityFluidDrawer) {
            BlockEntityFluidDrawer blockEntityFluidDrawer = (BlockEntityFluidDrawer)blockEntity;
            blockEntityFluidDrawer.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(iFluidHandler -> {
                for (int i = 0; i < iFluidHandler.getTanks(); ++i) {
                    iFluidHandler.drain(iFluidHandler.getFluidInTank(i), IFluidHandler.FluidAction.EXECUTE);
                }
            });
        }
    }

    public void m_6786_(LevelAccessor level, BlockPos pos, BlockState state) {
        super.m_6786_(level, pos, state);
        level.m_5594_(null, pos, Fluids.f_76193_.getFluidType().getSound(SoundActions.BUCKET_EMPTY), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int m_6378_(BlockState state, BlockGetter blockAccess, BlockPos pos, Direction side) {
        if (!this.m_7899_(state) || !(blockAccess.m_7702_(pos) instanceof BlockEntityFluidDrawer)) {
            return 0;
        }
        BlockEntityFluidDrawer tile = (BlockEntityFluidDrawer)blockAccess.m_7702_(pos);
        return tile != null && tile.isRedstone() ? tile.getRedstoneLevel() : 0;
    }

    public int m_6376_(BlockState state, BlockGetter worldIn, BlockPos pos, Direction side) {
        return side == Direction.UP ? this.m_6378_(state, worldIn, pos, side) : 0;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BlockEntityFluidDrawer(this.getSlotCount(), pos, state);
    }

    protected int getSlotCount() {
        return this.slotCount;
    }

    public ItemStack makeFramedItem(ItemStack source, ItemStack matSide, ItemStack matTrim, ItemStack matFront) {
        return FrameHelper.makeFramedItem((IFramedBlock)ModContents.get(this), (ItemStack)source, (ItemStack)matSide, (ItemStack)matTrim, (ItemStack)matFront);
    }

    static {
        VoxelShape base = Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape column1 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0);
        VoxelShape column2 = column1.m_83216_(0.9375, 0.0, 0.0);
        VoxelShape column3 = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)1.0, (double)1.0);
        VoxelShape column4 = column3.m_83216_(0.0, 0.9375, 0.0);
        VoxelShape column = Shapes.m_83124_((VoxelShape)column1, (VoxelShape[])new VoxelShape[]{column2, column3, column4});
        shape = Shapes.m_83110_((VoxelShape)base, (VoxelShape)column);
        VoxelShape basef = Block.m_49796_((double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0, (double)16.0);
        shapef = Shapes.m_83110_((VoxelShape)basef, (VoxelShape)column.m_83216_(0.0, 0.0, 0.5));
    }
}

