/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.fluiddrawerslegacy.client.gui;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.inventory.SlotUpgrade;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import xueluoanping.fluiddrawerslegacy.ModContents;
import xueluoanping.fluiddrawerslegacy.block.blockentity.BlockEntityFluidDrawer;
import xueluoanping.fluiddrawerslegacy.custom.InventoryUpgrade;

public class ContainerFluiDrawer
extends AbstractContainerMenu {
    private static final int[][] slotCoordinates = new int[][]{{80, 36}};
    private Container upgradeInventory;
    private List<Slot> upgradeSlots;
    private List<Slot> playerSlots;
    private List<Slot> hotbarSlots;
    private boolean isRemote;
    private BlockEntityFluidDrawer blockEntityFluidDrawer;

    public ContainerFluiDrawer(int windowId, Inventory playerInv, FriendlyByteBuf data) {
        this((MenuType)ModContents.containerType.get(), windowId, playerInv, ContainerFluiDrawer.getTileEntity(playerInv, data.m_130135_()));
    }

    public static BlockEntityFluidDrawer getTileEntity(Inventory playerInv, BlockPos pos) {
        BlockEntity blockEntity = playerInv.f_35978_.m_20193_().m_7702_(pos);
        if (!(blockEntity instanceof BlockEntityFluidDrawer)) {
            StorageDrawers.log.error("Expected a drawers tile entity at " + pos.toString());
            return null;
        }
        BlockEntityFluidDrawer tile = (BlockEntityFluidDrawer)blockEntity;
        return tile;
    }

    public BlockEntityFluidDrawer getTileEntityFluidDrawer() {
        return this.blockEntityFluidDrawer;
    }

    public ContainerFluiDrawer(@Nullable MenuType<?> type, int windowId, Inventory playerInventory, BlockEntityFluidDrawer tileEntity) {
        super(type, windowId);
        int i;
        this.blockEntityFluidDrawer = tileEntity;
        boolean drawerCount = true;
        this.upgradeInventory = new InventoryUpgrade(tileEntity);
        this.upgradeSlots = new ArrayList<Slot>();
        for (i = 0; i < 7; ++i) {
            this.upgradeSlots.add(this.m_38897_((Slot)new SlotUpgrade(this.upgradeInventory, i, 26 + i * 18, 86)));
        }
        this.playerSlots = new ArrayList<Slot>();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.playerSlots.add(this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 117 + i * 18)));
            }
        }
        this.hotbarSlots = new ArrayList<Slot>();
        for (i = 0; i < 9; ++i) {
            this.hotbarSlots.add(this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 175)));
        }
        this.isRemote = playerInventory.f_35978_.m_20193_().m_5776_();
    }

    protected int getStorageSlotX(int slot) {
        return slotCoordinates[slot][0];
    }

    protected int getStorageSlotY(int slot) {
        return slotCoordinates[slot][1];
    }

    public List<Slot> getUpgradeSlots() {
        return this.upgradeSlots;
    }

    @Nonnull
    public ItemStack m_7648_(Player player, int slotIndex) {
        try {
            ItemStack itemStack = ItemStack.f_41583_;
            Slot slot = (Slot)this.f_38839_.get(slotIndex);
            int upgradeStart = this.upgradeSlots.get((int)0).f_40219_;
            int upgradeEnd = this.upgradeSlots.get((int)(this.upgradeSlots.size() - 1)).f_40219_ + 1;
            int inventoryStart = this.playerSlots.get((int)0).f_40219_;
            int hotbarStart = this.hotbarSlots.get((int)0).f_40219_;
            int hotbarEnd = this.hotbarSlots.get((int)(this.hotbarSlots.size() - 1)).f_40219_ + 1;
            if (slot != null && slot.m_6657_()) {
                ItemStack slotStack = slot.m_7993_();
                itemStack = slotStack.m_41777_();
                if (slotIndex >= upgradeStart && slotIndex < upgradeEnd) {
                    if (!this.m_38903_(slotStack, inventoryStart, hotbarEnd, true)) {
                        return ItemStack.f_41583_;
                    }
                    slot.m_40234_(slotStack, itemStack);
                } else if (slotIndex >= inventoryStart && slotIndex < hotbarEnd && !slotStack.m_41619_()) {
                    if (slotStack.m_41720_() instanceof ItemUpgrade) {
                        ItemStack slotStack1 = slotStack.m_41777_();
                        slotStack1.m_41764_(1);
                        if (this.m_38903_(slotStack1, upgradeStart, upgradeEnd, false)) {
                            slotStack.m_41774_(1);
                            if (slotStack.m_41613_() == 0) {
                                slot.m_5852_(ItemStack.f_41583_);
                            } else {
                                slot.m_6654_();
                            }
                            slot.m_142406_(player, slotStack);
                            return ItemStack.f_41583_;
                        }
                        if (slotIndex >= inventoryStart && slotIndex < hotbarStart ? !this.m_38903_(slotStack, hotbarStart, hotbarEnd, false) : slotIndex >= hotbarStart && slotIndex < hotbarEnd && !this.m_38903_(slotStack, inventoryStart, hotbarStart, false)) {
                            return ItemStack.f_41583_;
                        }
                    } else if (slotIndex >= inventoryStart && slotIndex < hotbarStart ? !this.m_38903_(slotStack, hotbarStart, hotbarEnd, false) : slotIndex >= hotbarStart && slotIndex < hotbarEnd && !this.m_38903_(slotStack, inventoryStart, hotbarStart, false)) {
                        return ItemStack.f_41583_;
                    }
                } else if (!this.m_38903_(slotStack, inventoryStart, hotbarEnd, false)) {
                    return ItemStack.f_41583_;
                }
                int slotStackSize = slotStack.m_41613_();
                if (slotStackSize == 0) {
                    slot.m_5852_(ItemStack.f_41583_);
                } else {
                    slot.m_6654_();
                }
                if (slotStackSize == itemStack.m_41613_()) {
                    return ItemStack.f_41583_;
                }
                slot.m_142406_(player, slotStack);
            }
            return itemStack;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return ItemStack.f_41583_;
        }
    }

    public boolean m_6875_(Player player) {
        return this.upgradeInventory.m_6542_(player);
    }
}

