/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.fluiddrawerslegacy.client.render;

import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Vector3d;
import xueluoanping.fluiddrawerslegacy.api.drawer.IFluidDrawer;
import xueluoanping.fluiddrawerslegacy.block.BlockFluidDrawer;
import xueluoanping.fluiddrawerslegacy.block.blockentity.BlockEntityFluidDrawer;
import xueluoanping.fluiddrawerslegacy.client.render.XYZ;
import xueluoanping.fluiddrawerslegacy.client.util.TankHolder;
import xueluoanping.fluiddrawerslegacy.client.util.TankRenderUtil;
import xueluoanping.fluiddrawerslegacy.config.ClientConfig;
import xueluoanping.fluiddrawerslegacy.util.MathUtil;

public class TESRFluidDrawer
implements BlockEntityRenderer<BlockEntityFluidDrawer> {
    public static final Material BELL_RESOURCE_LOCATION = new Material(TextureAtlas.f_118259_, new ResourceLocation("entity/bell/bell_body"));
    private static final String BELL_BODY = "bell_body";
    private final ModelPart bellBody;
    private final Font font;

    public TESRFluidDrawer(BlockEntityRendererProvider.Context pContext) {
        ModelPart modelpart = pContext.m_173582_(ModelLayers.f_171269_);
        this.bellBody = modelpart.m_171324_(BELL_BODY);
        this.font = pContext.m_173586_();
    }

    public void render(BlockEntityFluidDrawer tile, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlay) {
        if (!tile.m_58898_()) {
            return;
        }
        if (tile.upgrades().hasIlluminationUpgrade()) {
            combinedLightIn = 0xF000F0;
        }
        matrixStackIn.m_85836_();
        Minecraft mc = Minecraft.m_91087_();
        long gameTime = mc.f_91073_.m_46467_();
        double animationTime = (double)gameTime + (double)partialTicks;
        this.renderFluid(tile, matrixStackIn, bufferIn, combinedLightIn, animationTime);
        matrixStackIn.m_85849_();
        List<BlockEntityFluidDrawer.FluidDrawerData> dlist = tile.getTank().getFluidDrawerDataList();
        int count = dlist.size();
        int slot = 0;
        for (BlockEntityFluidDrawer.FluidDrawerData data : dlist) {
            FluidStack fluidStackDown;
            ++slot;
            BlockEntityFluidDrawer.betterFluidHandler betterFluidHandler2 = data.getTank();
            if (betterFluidHandler2.getCacheFluid().getRawFluid() != Fluids.f_76191_ && tile.getDrawerAttributes().isConcealed()) {
                fluidStackDown = new FluidStack(betterFluidHandler2.getCacheFluid(), 1);
                String label = fluidStackDown.getDisplayName().getString();
                this.drawText(0, label, slot, count, tile, matrixStackIn, combinedLightIn);
            }
            if (tile.getDrawerAttributes().isItemLocked(LockAttribute.LOCK_EMPTY) && betterFluidHandler2.getCacheFluid().getRawFluid() != Fluids.f_76191_) {
                String label = "(" + I18n.m_118938_((String)"tooltip.storagedrawers.waila.locked", (Object[])new Object[0]) + ")";
                this.drawText(1, label, slot, count, tile, matrixStackIn, combinedLightIn);
            }
            if (!tile.getDrawerAttributes().isShowingQuantity() || betterFluidHandler2.getCacheFluid().getRawFluid() == Fluids.f_76191_) continue;
            fluidStackDown = betterFluidHandler2.getFluid();
            int amount = fluidStackDown.getAmount();
            String label = amount + "mB";
            this.drawText(2, label, slot, count, tile, matrixStackIn, combinedLightIn);
        }
        this.render(partialTicks, matrixStackIn, bufferIn, combinedLightIn, combinedOverlay);
    }

    private void drawText(int line, String label, int slot, int count, BlockEntityFluidDrawer tile, PoseStack matrixStackIn, int combinedLightIn) {
        matrixStackIn.m_85836_();
        Font fontRenderer = this.font;
        MultiBufferSource.BufferSource txtBuffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        int textWidth = fontRenderer.m_92895_(label);
        Objects.requireNonNull(this.font);
        int lh = 9;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Direction d = (Direction)tile.m_58900_().m_61143_((Property)BlockFluidDrawer.FACING);
        this.handleMatrixAngle(matrixStackIn, player, tile.m_58899_(), d);
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float scale_x = 0.007f;
        float scale_y = 0.007f;
        float scale_z = 0.007f;
        float extraHeight = 0.0f;
        if (tile.isHalf()) {
            z += 0.55f;
        }
        if (count > 1) {
            scale_x /= 2.0f;
            scale_y /= 2.0f;
            scale_z /= 2.0f;
            if (count == 4) {
                if (slot == 1) {
                    x = (float)((double)x + -0.25);
                    y = (float)((double)y + -0.4);
                }
                if (slot == 2) {
                    x = (float)((double)x + 0.25);
                    y = (float)((double)y + -0.4);
                }
                if (slot == 3) {
                    x = (float)((double)x + -0.25);
                    y = (float)((double)y + 0.08);
                }
                if (slot == 4) {
                    x = (float)((double)x + 0.25);
                    y = (float)((double)y + 0.08);
                }
                if (textWidth > 80) {
                    double r = (double)textWidth / 80.0;
                    scale_x = (float)((double)scale_x / r);
                    scale_y = (float)((double)scale_y / r);
                    scale_z = (float)((double)scale_z / r);
                    extraHeight = (float)((double)lh * (r - 1.0));
                }
            }
            if (count == 2) {
                if (slot == 1) {
                    y = (float)((double)y + -0.4);
                }
                if (slot == 2) {
                    y = (float)((double)y + 0.08);
                }
            }
        }
        if (count == 1) {
            y = (float)((double)y + 0.05);
        }
        matrixStackIn.m_252880_(x, y, z);
        matrixStackIn.m_85841_(scale_x, scale_y, scale_z);
        fontRenderer.m_271703_(label, (float)(-textWidth) / 2.0f, -18.0f - (float)lh * 1.2f * (float)line - 1.2f * extraHeight, 0xFFFFFF, false, matrixStackIn.m_85850_().m_252922_(), (MultiBufferSource)txtBuffer, Font.DisplayMode.NORMAL, 0, combinedLightIn);
        txtBuffer.m_109911_();
        matrixStackIn.m_85849_();
    }

    private void handleMatrixAngle(PoseStack matrixStackIn, LocalPlayer player, BlockPos pos, Direction d) {
        Vector3d vector3d = new Vector3d(player.m_20318_(1.0f).m_7096_() - (double)pos.m_123341_() - 0.5, player.m_20318_(0.0f).m_7098_() - (double)pos.m_123342_(), player.m_20318_(0.0f).m_7094_() - (double)pos.m_123343_() - 0.5);
        if (d == Direction.DOWN || d == Direction.UP) {
            if (vector3d.x > 0.0 && Math.abs(vector3d.x) > Math.abs(vector3d.z)) {
                d = Direction.EAST;
            }
            if (vector3d.x < 0.0 && Math.abs(vector3d.x) > Math.abs(vector3d.z)) {
                d = Direction.WEST;
            }
            if (vector3d.x > 0.0 && Math.abs(vector3d.x) < Math.abs(vector3d.z)) {
                d = Direction.SOUTH;
            }
            if (vector3d.x < 0.0 && Math.abs(vector3d.x) < Math.abs(vector3d.z)) {
                d = Direction.NORTH;
            }
        }
        if ((Integer)ClientConfig.distance.get() != -1 && MathUtil.calDistanceSelf(vector3d) > (float)((Integer)ClientConfig.distance.get()).intValue()) {
            d = Direction.DOWN;
        }
        switch (d) {
            case SOUTH: {
                matrixStackIn.m_85837_(0.5, 0.15, 1.0);
                matrixStackIn.m_252781_(XYZ.deg_to_rad(0, 180, 180));
                break;
            }
            case NORTH: {
                matrixStackIn.m_252781_(XYZ.deg_to_rad(0, 0, 180));
                matrixStackIn.m_85837_(-0.5, -0.15, 0.0);
                break;
            }
            case EAST: {
                matrixStackIn.m_252781_(XYZ.deg_to_rad(0, 270, 180));
                matrixStackIn.m_85837_(-0.5, -0.15, -1.0);
                break;
            }
            case WEST: {
                matrixStackIn.m_252781_(XYZ.deg_to_rad(0, 90, 180));
                matrixStackIn.m_85837_(0.5, -0.15, 0.0);
                break;
            }
            default: {
                matrixStackIn.m_85841_(0.01f, 0.01f, 0.01f);
            }
        }
    }

    public void render(float p_112234_, PoseStack poseStack, MultiBufferSource bufferSource, int p_112237_, int p_112238_) {
        poseStack.m_85841_(0.001f, 0.001f, 0.001f);
        VertexConsumer vertexconsumer = BELL_RESOURCE_LOCATION.m_119194_(bufferSource, RenderType::m_110446_);
        this.bellBody.m_104301_(poseStack, vertexconsumer, p_112237_, p_112238_);
    }

    private void renderFluid(BlockEntityFluidDrawer tile, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLight, double animationTime) {
        boolean isLocked = tile.getDrawerAttributes().isItemLocked(LockAttribute.LOCK_EMPTY);
        int count = tile.getDrawerCount();
        ArrayList<TankHolder> flist = new ArrayList<TankHolder>();
        for (int i = 0; i < count; ++i) {
            IFluidDrawer data = tile.getDrawer(i);
            Object betterFluidHandler2 = data.getTank();
            FluidStack fluidStackDown = betterFluidHandler2.getFluid().copy();
            FluidStack cache = data.getCacheFluid();
            int capacity = betterFluidHandler2.getCapacity();
            if (!fluidStackDown.isEmpty()) {
                fluidStackDown.setAmount(data.getFluidAnimation().getAndUpdateLastFluidAmount(fluidStackDown.getAmount(), animationTime));
            }
            if (isLocked && fluidStackDown.isEmpty() && !cache.isEmpty()) {
                fluidStackDown = new FluidStack(cache, 1000);
            }
            if (tile.upgrades().hasVendingUpgrade() && !fluidStackDown.isEmpty()) {
                fluidStackDown.setAmount(capacity);
            }
            flist.add(TankRenderUtil.of(fluidStackDown, capacity));
        }
        TankRenderUtil.renderFluid(flist, matrixStackIn, bufferIn, combinedLight, animationTime, tile.isHalf(), (Direction)tile.m_58900_().m_61143_((Property)BlockFluidDrawer.FACING));
    }
}

