/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.fluiddrawerslegacy.handler;

import com.google.common.base.Preconditions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidUtilPatch {
    public static boolean interactWithFluidHandlerAndEmpty(@NotNull Player player, @NotNull InteractionHand hand, @NotNull IFluidHandler handler, FluidStack fluidStack) {
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkNotNull((Object)hand);
        Preconditions.checkNotNull((Object)handler);
        ItemStack heldItem = player.m_21120_(hand);
        if (!heldItem.m_41619_()) {
            return player.getCapability(ForgeCapabilities.ITEM_HANDLER).map(playerInventory -> {
                FluidActionResult fluidActionResult = FluidUtilPatch.tryEmptyContainerAndStow(heldItem, handler, playerInventory, fluidStack, player, true);
                if (fluidActionResult.isSuccess()) {
                    player.m_21008_(hand, fluidActionResult.getResult());
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    public static FluidActionResult tryEmptyContainerAndStow(@NotNull ItemStack container, IFluidHandler fluidDestination, IItemHandler inventory, FluidStack fluidStack, @Nullable Player player, boolean doDrain) {
        if (container.m_41619_()) {
            return FluidActionResult.FAILURE;
        }
        if (player != null && player.m_150110_().f_35937_) {
            FluidActionResult emptiedReal = FluidUtilPatch.tryEmptyContainer(container, fluidDestination, fluidStack, player, doDrain);
            if (emptiedReal.isSuccess()) {
                return new FluidActionResult(container);
            }
        } else if (container.m_41613_() == 1) {
            FluidActionResult emptiedReal = FluidUtilPatch.tryEmptyContainer(container, fluidDestination, fluidStack, player, doDrain);
            if (emptiedReal.isSuccess()) {
                return emptiedReal;
            }
        } else {
            ItemStack remainder;
            FluidActionResult emptiedSimulated = FluidUtilPatch.tryEmptyContainer(container, fluidDestination, fluidStack, player, false);
            if (emptiedSimulated.isSuccess() && ((remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)emptiedSimulated.getResult(), (boolean)true)).m_41619_() || player != null)) {
                FluidActionResult emptiedReal = FluidUtilPatch.tryEmptyContainer(container, fluidDestination, fluidStack, player, doDrain);
                remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)emptiedReal.getResult(), (!doDrain ? 1 : 0) != 0);
                if (!remainder.m_41619_() && player != null && doDrain) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)remainder);
                }
                ItemStack containerCopy = container.m_41777_();
                containerCopy.m_41774_(1);
                return new FluidActionResult(containerCopy);
            }
        }
        return FluidActionResult.FAILURE;
    }

    @NotNull
    public static FluidActionResult tryEmptyContainer(@NotNull ItemStack container, IFluidHandler fluidDestination, FluidStack fluidStack, @Nullable Player player, boolean doDrain) {
        ItemStack containerCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)container, (int)1);
        return FluidUtilPatch.getFluidHandler(containerCopy).map(containerFluidHandler -> {
            SoundEvent soundevent;
            FluidStack transfer = FluidUtil.tryFluidTransfer((IFluidHandler)fluidDestination, (IFluidHandler)containerFluidHandler, (FluidStack)fluidStack, (boolean)doDrain);
            if (transfer.isEmpty()) {
                return FluidActionResult.FAILURE;
            }
            if (!doDrain) {
                containerFluidHandler.drain(transfer, IFluidHandler.FluidAction.EXECUTE);
            }
            if (doDrain && player != null && (soundevent = transfer.getFluid().getFluidType().getSound(transfer, SoundActions.BUCKET_EMPTY)) != null) {
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            ItemStack resultContainer = containerFluidHandler.getContainer();
            return new FluidActionResult(resultContainer);
        }).orElse(FluidActionResult.FAILURE);
    }

    public static LazyOptional<IFluidHandlerItem> getFluidHandler(@NotNull ItemStack itemStack) {
        return itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
    }
}

