/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.camo;

import com.google.common.base.Preconditions;
import com.mojang.logging.LogUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MapColor;
import org.slf4j.Logger;
import xfacthd.framedblocks.api.FramedBlocksAPI;
import xfacthd.framedblocks.api.camo.ContainerType;
import xfacthd.framedblocks.api.camo.EmptyCamoContainer;
import xfacthd.framedblocks.api.util.Utils;

public abstract class CamoContainer {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected BlockState state;

    protected CamoContainer(BlockState state) {
        this.state = state;
    }

    public BlockState getState() {
        return this.state;
    }

    public Fluid getFluid() {
        throw new UnsupportedOperationException("CamoContainer#getType() returns ContainerType.FLUID but doesn't override CamoContainer#getFluid()");
    }

    public MapColor getMapColor(BlockGetter level, BlockPos pos) {
        return this.state.m_284242_(level, pos);
    }

    public float[] getBeaconColorMultiplier(LevelReader level, BlockPos pos, BlockPos beaconPos) {
        return this.state.getBeaconColorMultiplier(level, pos, beaconPos);
    }

    public abstract int getColor(BlockAndTintGetter var1, BlockPos var2, int var3);

    public abstract ItemStack toItemStack(ItemStack var1);

    public boolean canRotateCamo() {
        return Utils.getRotatableProperty(this.getState()) != null;
    }

    public boolean rotateCamo() {
        Property<?> prop = Utils.getRotatableProperty(this.getState());
        if (prop == null) {
            return false;
        }
        this.state = (BlockState)this.state.m_61122_(prop);
        return true;
    }

    public SoundType getSoundType() {
        return this.state.m_60827_();
    }

    public boolean isSolid(BlockGetter level, BlockPos pos) {
        return this.getState().m_60804_(level, pos);
    }

    public boolean isEmpty() {
        return false;
    }

    public abstract ContainerType getType();

    public abstract Factory getFactory();

    public abstract void save(CompoundTag var1);

    public abstract void toNetwork(CompoundTag var1);

    public static CompoundTag save(CamoContainer camo) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("type", camo.getFactory().getId());
        camo.save(tag);
        return tag;
    }

    public static CompoundTag writeToNetwork(CamoContainer camo) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("type", camo.getFactory().getSyncId());
        camo.toNetwork(tag);
        return tag;
    }

    public static CamoContainer load(CompoundTag tag) {
        if (tag.m_128456_()) {
            return EmptyCamoContainer.EMPTY;
        }
        ResourceLocation id = ResourceLocation.m_135820_((String)tag.m_128461_("type"));
        Factory factory = (Factory)FramedBlocksAPI.getInstance().getCamoContainerFactoryRegistry().getValue(id);
        if (factory == null) {
            LOGGER.error("Unknown ICamoContainer with ID {}, dropping!", (Object)id);
            return EmptyCamoContainer.EMPTY;
        }
        return factory.fromNbt(tag);
    }

    public static CamoContainer readFromNetwork(CompoundTag tag) {
        if (tag.m_128456_()) {
            return EmptyCamoContainer.EMPTY;
        }
        int id = tag.m_128451_("type");
        Factory factory = Utils.getValue(FramedBlocksAPI.getInstance().getCamoContainerFactoryRegistry(), id);
        if (factory == null) {
            LOGGER.error("Unknown ICamoContainer with ID {}, dropping!", (Object)id);
            return EmptyCamoContainer.EMPTY;
        }
        return factory.fromNetwork(tag);
    }

    public static abstract class Factory {
        private String id;
        private int syncId = -1;

        public final String getId() {
            if (this.id == null) {
                this.id = FramedBlocksAPI.getInstance().getCamoContainerFactoryRegistry().getKey((Object)this).toString();
            }
            return this.id;
        }

        public final int getSyncId() {
            if (this.syncId == -1) {
                this.syncId = Utils.getId(FramedBlocksAPI.getInstance().getCamoContainerFactoryRegistry(), this);
                Preconditions.checkState((this.syncId != -1 ? 1 : 0) != 0, (Object)"Attempted to get sync ID for unregistered CamoContainer.Factory");
            }
            return this.syncId;
        }

        public abstract CamoContainer fromNbt(CompoundTag var1);

        public abstract CamoContainer fromNetwork(CompoundTag var1);

        public abstract CamoContainer fromItem(ItemStack var1);
    }
}

