/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.computer;

import java.util.function.Predicate;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.functions.ConstantPredicates;
import mekanism.common.tile.interfaces.IComparatorSupport;
import mekanism.common.tile.interfaces.ITileDirectional;
import mekanism.common.tile.interfaces.ITileRedstone;
import mekanism.common.tile.prefab.TileEntityMultiblock;
import org.jetbrains.annotations.Nullable;

public enum MethodRestriction implements Predicate<Object>
{
    NONE(ConstantPredicates.alwaysTrue()),
    DIRECTIONAL(handler -> {
        ITileDirectional directional;
        return handler instanceof ITileDirectional && (directional = (ITileDirectional)handler).isDirectional();
    }),
    ENERGY(handler -> {
        IMekanismStrictEnergyHandler energyHandler;
        return handler instanceof IMekanismStrictEnergyHandler && (energyHandler = (IMekanismStrictEnergyHandler)handler).canHandleEnergy();
    }),
    MULTIBLOCK(handler -> {
        TileEntityMultiblock multiblock;
        return handler instanceof TileEntityMultiblock && (multiblock = (TileEntityMultiblock)handler).exposesMultiblockToComputer();
    }),
    REDSTONE_CONTROL(handler -> {
        ITileRedstone redstone;
        return handler instanceof ITileRedstone && (redstone = (ITileRedstone)handler).supportsRedstone();
    }),
    COMPARATOR(handler -> {
        IComparatorSupport comparatorSupport;
        return handler instanceof IComparatorSupport && (comparatorSupport = (IComparatorSupport)handler).supportsComparator();
    });

    private final Predicate<Object> validator;

    private MethodRestriction(Predicate<Object> validator) {
        this.validator = validator;
    }

    @Override
    public boolean test(@Nullable Object handler) {
        return this.validator.test(handler);
    }
}

