/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.manager;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import mekanism.api.recipes.FluidToFluidRecipe;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.recipe.manager.MekanismRecipeManager;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.impl.FluidToFluidIRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.recipe.manager.FluidToFluid")
public abstract class FluidToFluidRecipeManager
extends MekanismRecipeManager<FluidToFluidRecipe> {
    protected FluidToFluidRecipeManager(IMekanismRecipeTypeProvider<FluidToFluidRecipe, ?> recipeType) {
        super(recipeType);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, FluidStackIngredient input, IFluidStack output) {
        this.addRecipe(this.makeRecipe(this.getAndValidateName(name), input, output));
    }

    public final FluidToFluidIRecipe makeRecipe(ResourceLocation id, FluidStackIngredient input, IFluidStack output) {
        return this.makeRecipe(id, input, this.getAndValidateNotEmpty(output));
    }

    protected abstract FluidToFluidIRecipe makeRecipe(ResourceLocation var1, FluidStackIngredient var2, FluidStack var3);

    @Override
    protected String describeOutputs(FluidToFluidRecipe recipe) {
        return CrTUtils.describeOutputs(recipe.getOutputDefinition(), IFluidStack::of);
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.manager.FluidToFluid.Evaporating")
    public static class EvaporatingRecipeManager
    extends FluidToFluidRecipeManager {
        public static final EvaporatingRecipeManager INSTANCE = new EvaporatingRecipeManager();

        private EvaporatingRecipeManager() {
            super((IMekanismRecipeTypeProvider<FluidToFluidRecipe, ?>)MekanismRecipeType.EVAPORATING);
        }

        @Override
        protected FluidToFluidIRecipe makeRecipe(ResourceLocation id, FluidStackIngredient input, FluidStack output) {
            return new FluidToFluidIRecipe(id, input, output);
        }
    }
}

