/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.ohthetreesyoullgrow.world.level.levelgen.feature.configurations.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.corgitaco.ohthetreesyoullgrow.world.level.levelgen.feature.configurations.treedecorators.TYGTreeDecoratorTypes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.AttachedToLeavesDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import org.jetbrains.annotations.NotNull;

public class AttachedToFruitLeavesDecorator
extends AttachedToLeavesDecorator {
    public static final Codec<AttachedToFruitLeavesDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(decorator -> Float.valueOf(decorator.f_225980_)), (App)Codec.intRange((int)0, (int)16).fieldOf("exclusion_radius_xz").forGetter(decorator -> decorator.f_225981_), (App)Codec.intRange((int)0, (int)16).fieldOf("exclusion_radius_y").forGetter(decorator -> decorator.f_225982_), (App)BuiltInRegistries.f_256975_.m_194605_().fieldOf("leaves_block").forGetter(decorator -> decorator.leavesBlock), (App)BlockStateProvider.f_68747_.fieldOf("block_provider").forGetter(decorator -> decorator.f_225983_), (App)Codec.intRange((int)1, (int)16).fieldOf("required_empty_blocks").forGetter(decorator -> decorator.f_225984_), (App)ExtraCodecs.m_144637_((Codec)Direction.f_175356_.listOf()).fieldOf("directions").forGetter(decorator -> decorator.f_225985_)).apply((Applicative)instance, AttachedToFruitLeavesDecorator::new));
    private final Block leavesBlock;

    public AttachedToFruitLeavesDecorator(float probability, int exclusionRadiusXZ, int exclusionRadiusY, Block leavesBlock, BlockStateProvider blockProvider, int requiredEmptyBlocks, List<Direction> directions) {
        super(probability, exclusionRadiusXZ, exclusionRadiusY, blockProvider, requiredEmptyBlocks, directions);
        this.leavesBlock = leavesBlock;
    }

    @NotNull
    protected TreeDecoratorType<?> m_6663_() {
        return TYGTreeDecoratorTypes.ATTACHED_TO_FRUIT_LEAVES.get();
    }

    public void m_214187_(@NotNull TreeDecorator.Context context) {
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        RandomSource random = context.m_226067_();
        ArrayList<BlockPos> leavesPositions = new ArrayList<BlockPos>();
        for (BlockPos pos : context.m_226069_()) {
            if (!context.m_226058_().m_7433_(pos, state -> state.m_60713_(this.leavesBlock))) continue;
            leavesPositions.add(pos);
        }
        List shuffledLeaves = Util.m_214681_((Object[])leavesPositions.toArray(new BlockPos[0]), (RandomSource)random);
        for (BlockPos pos : shuffledLeaves) {
            Direction direction;
            BlockPos relativePos = pos.m_121945_(direction = (Direction)Util.m_214621_((List)this.f_225985_, (RandomSource)random));
            if (positions.contains(relativePos) || !(random.m_188501_() < this.f_225980_) || !this.hasRequiredEmptyBlocks(context, pos, direction)) continue;
            BlockPos minXZ = relativePos.m_7918_(-this.f_225981_, -this.f_225982_, -this.f_225981_);
            BlockPos maxXZ = relativePos.m_7918_(this.f_225981_, this.f_225982_, this.f_225981_);
            for (BlockPos blockPos : BlockPos.m_121940_((BlockPos)minXZ, (BlockPos)maxXZ)) {
                positions.add(blockPos.m_7949_());
            }
            context.m_226061_(relativePos, this.f_225983_.m_213972_(random, relativePos));
        }
    }

    private boolean hasRequiredEmptyBlocks(TreeDecorator.Context context, BlockPos pos, Direction direction) {
        for (int i = 1; i <= this.f_225984_; ++i) {
            BlockPos relativePos = pos.m_5484_(direction, i);
            if (context.m_226059_(relativePos)) continue;
            return false;
        }
        return true;
    }
}

