/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.xkdeco.client.model;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.model.ModelHelper;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.MultiPartBakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import snownee.kiwi.util.NotNullByDefault;

@NotNullByDefault
public class MimicWallBakedModel
extends ForwardingBakedModel {
    private static final List<EnumProperty<WallSide>> WALL_SIDE_PROPERTIES = List.of(WallBlock.f_57951_, WallBlock.f_57950_, WallBlock.f_57952_, WallBlock.f_57953_);
    private final WallBlock base;

    public MimicWallBakedModel(WallBlock base, BakedModel baked) {
        this.base = base;
        BakedModel bakedModel = this.wrapped = baked;
        if (bakedModel instanceof MultiPartBakedModel) {
            MultiPartBakedModel multiPart = (MultiPartBakedModel)bakedModel;
            RandomSource random = RandomSource.m_216335_((long)42L);
            BlockState blockState = base.m_49966_();
            EnumMap culledFaces = Maps.newEnumMap(Direction.class);
            for (Direction direction : Direction.values()) {
                culledFaces.put(direction, multiPart.m_213637_(blockState, direction, random));
            }
            this.wrapped = new SimpleBakedModel(this.wrapped.m_213637_(blockState, null, random), (Map)culledFaces, this.wrapped.m_7541_(), this.wrapped.m_7547_(), this.wrapped.m_7539_(), this.wrapped.m_6160_(), this.wrapped.m_7442_(), this.wrapped.m_7343_());
        }
    }

    public void emitBlockQuads(BlockAndTintGetter blockView, BlockState state, BlockPos pos, Supplier<RandomSource> randomSupplier, RenderContext context) {
        ((FabricBakedModel)this.wrapped).emitBlockQuads(blockView, this.base.m_49966_(), pos, randomSupplier, context);
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            WallSide wallSide;
            BlockState blockState = blockView.m_8055_((BlockPos)mutable.m_122173_(direction));
            mutable.m_122190_((Vec3i)pos);
            if (!(blockState.m_60734_() instanceof WallBlock) || !blockState.m_204336_(BlockTags.f_13032_) || (wallSide = (WallSide)blockState.m_61143_((Property)WALL_SIDE_PROPERTIES.get(direction.m_122416_()))) == WallSide.NONE) continue;
            blockState = (BlockState)((BlockState)blockState.m_60734_().m_49966_().m_61124_((Property)WallBlock.f_57949_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WALL_SIDE_PROPERTIES.get(direction.m_122424_().m_122416_()), (Comparable)wallSide);
            BakedModel model = Minecraft.m_91087_().m_91304_().m_119430_().m_110893_(blockState);
            ((FabricBakedModel)model).emitBlockQuads(blockView, blockState, pos, randomSupplier, context);
        }
    }

    public ItemTransforms m_7442_() {
        return ModelHelper.MODEL_TRANSFORM_BLOCK;
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public BakedModel applyTransform(ItemDisplayContext transformType, PoseStack poseStack, boolean applyLeftHandTransform) {
        this.m_7442_().m_269404_(transformType).m_111763_(applyLeftHandTransform, poseStack);
        return this.wrapped instanceof MultiPartBakedModel ? super.applyTransform(transformType, poseStack, applyLeftHandTransform) : this;
    }
}

