/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.common.entity.vehicle;

import com.alekiponi.alekiships.common.block.AlekiShipsBlocks;
import com.alekiponi.alekiships.common.block.AngledBoatFrameBlock;
import com.alekiponi.alekiships.common.entity.vehicle.AbstractUnderConstructionEntity;
import com.alekiponi.alekiships.common.entity.vehicle.AbstractVehicle;
import com.alekiponi.alekiships.common.item.AlekiShipsItems;
import com.alekiponi.alekiships.util.BoatMaterial;
import com.alekiponi.alekiships.util.advancements.AlekiShipsAdvancements;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import oshi.util.tuples.Pair;

public class SloopUnderConstructionEntity
extends AbstractUnderConstructionEntity {
    public final BoatMaterial boatMaterial;
    private static final int KEEL_ITEM_NUMBER = 8;
    private static final int DECK_ITEM_NUMBER = 20;
    private static final int BOWSPRIT_ITEM_NUMBER = 6;
    private static final int MAST_ITEM_NUMBER = 12;
    private static final int BOOM_ITEM_NUMER = 8;
    private static final int MAINSAIL_ITEM_NUMBER = 16;
    private static final int JIBSAIL_ITEM_NUMBER = 8;
    private static final int STERN_RAILING_ITEM_NUMBER = 8;
    private static final int BOW_RAILING_ITEM_NUMBER = 8;
    private static final int ANCHOR_ITEM_NUMBER = 1;
    private static final int RIGGING_ITEM_NUMBER = 8;
    private static final EntityDataAccessor<ItemStack> DATA_ID_KEEL = SynchedEntityData.m_135353_(SloopUnderConstructionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<ItemStack> DATA_ID_DECK = SynchedEntityData.m_135353_(SloopUnderConstructionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<ItemStack> DATA_ID_BOWSPRIT = SynchedEntityData.m_135353_(SloopUnderConstructionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<ItemStack> DATA_ID_MAST = SynchedEntityData.m_135353_(SloopUnderConstructionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<ItemStack> DATA_ID_BOOM = SynchedEntityData.m_135353_(SloopUnderConstructionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<ItemStack> DATA_ID_MAINSAIL = SynchedEntityData.m_135353_(SloopUnderConstructionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<ItemStack> DATA_ID_JIBSAIL = SynchedEntityData.m_135353_(SloopUnderConstructionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<ItemStack> DATA_ID_RAILINGS_STERN = SynchedEntityData.m_135353_(SloopUnderConstructionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<ItemStack> DATA_ID_RAILINGS_BOW = SynchedEntityData.m_135353_(SloopUnderConstructionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<ItemStack> DATA_ID_ANCHOR = SynchedEntityData.m_135353_(SloopUnderConstructionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<ItemStack> DATA_ID_RIGGING = SynchedEntityData.m_135353_(SloopUnderConstructionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Integer> DATA_ID_CONSTRUCTION_STAGE = SynchedEntityData.m_135353_(SloopUnderConstructionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public SloopUnderConstructionEntity(EntityType<? extends SloopUnderConstructionEntity> entityType, Level level, BoatMaterial boatMaterial) {
        super(entityType, level);
        this.boatMaterial = boatMaterial;
    }

    public Pair<Item, Integer> getBowRailingsItem() {
        return new Pair((Object)this.boatMaterial.getRailing(), (Object)8);
    }

    public Pair<Item, Integer> getSternRailingsItem() {
        return new Pair((Object)this.boatMaterial.getRailing(), (Object)8);
    }

    public Pair<Item, Integer> getMainsailItem() {
        return new Pair((Object)Items.f_41870_, (Object)16);
    }

    public Pair<Item, Integer> getJibsailItem() {
        return new Pair((Object)Items.f_41870_, (Object)8);
    }

    public Pair<Item, Integer> getRiggingItem() {
        return new Pair((Object)Items.f_42655_, (Object)8);
    }

    public Pair<Item, Integer> getAnchorItem() {
        return new Pair((Object)((Item)AlekiShipsItems.ANCHOR.get()), (Object)1);
    }

    public Pair<Item, Integer> getDeckItem() {
        return new Pair((Object)this.boatMaterial.getDeckItem(), (Object)20);
    }

    public Pair<Item, Integer> getMastItem() {
        return new Pair((Object)this.boatMaterial.getStrippedLog(), (Object)12);
    }

    public Pair<Item, Integer> getKeelItem() {
        return new Pair((Object)this.boatMaterial.getStrippedLog(), (Object)8);
    }

    public Pair<Item, Integer> getBowspritItem() {
        return new Pair((Object)this.boatMaterial.getStrippedLog(), (Object)6);
    }

    public Pair<Item, Integer> getBoomItem() {
        return new Pair((Object)this.boatMaterial.getStrippedLog(), (Object)8);
    }

    @Override
    public int[] getColliderIndices() {
        return new int[0];
    }

    @Override
    public int[] getConstructionIndices() {
        return new int[]{0};
    }

    @Override
    public float renderSizeForCompartments() {
        return 0.0f;
    }

    @Override
    public int getCompartmentRotation(int i) {
        return 0;
    }

    @Override
    public float getPassengerSizeLimit() {
        return 0.0f;
    }

    @Override
    public int[][] getCompartmentRotationsArray() {
        return new int[0][];
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_KEEL, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_ID_DECK, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_ID_BOWSPRIT, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_ID_MAST, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_ID_BOOM, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_ID_MAINSAIL, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_ID_JIBSAIL, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_ID_RAILINGS_STERN, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_ID_RAILINGS_BOW, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_ID_ANCHOR, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_ID_RIGGING, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_ID_CONSTRUCTION_STAGE, (Object)0);
    }

    public ItemStack getKeel() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_ID_KEEL);
    }

    public void setKeel(ItemStack itemStack) {
        this.f_19804_.m_135381_(DATA_ID_KEEL, (Object)itemStack.m_41777_());
    }

    public ItemStack getDeck() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_ID_DECK);
    }

    public void setDeck(ItemStack itemStack) {
        this.f_19804_.m_135381_(DATA_ID_DECK, (Object)itemStack.m_41777_());
    }

    public ItemStack getBowsprit() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_ID_BOWSPRIT);
    }

    public void setBowsprit(ItemStack itemStack) {
        this.f_19804_.m_135381_(DATA_ID_BOWSPRIT, (Object)itemStack.m_41777_());
    }

    public ItemStack getMast() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_ID_MAST);
    }

    public void setMast(ItemStack itemStack) {
        this.f_19804_.m_135381_(DATA_ID_MAST, (Object)itemStack.m_41777_());
    }

    public ItemStack getBoom() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_ID_BOOM);
    }

    public void setBoom(ItemStack itemStack) {
        this.f_19804_.m_135381_(DATA_ID_BOOM, (Object)itemStack.m_41777_());
    }

    public ItemStack getMainsail() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_ID_MAINSAIL);
    }

    public void setMainsail(ItemStack itemStack) {
        this.f_19804_.m_135381_(DATA_ID_MAINSAIL, (Object)itemStack.m_41777_());
    }

    public ItemStack getJibsail() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_ID_JIBSAIL);
    }

    public void setJibsail(ItemStack itemStack) {
        this.f_19804_.m_135381_(DATA_ID_JIBSAIL, (Object)itemStack.m_41777_());
    }

    public ItemStack getRailingsStern() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_ID_RAILINGS_STERN);
    }

    public void setRailingsStern(ItemStack itemStack) {
        this.f_19804_.m_135381_(DATA_ID_RAILINGS_STERN, (Object)itemStack.m_41777_());
    }

    public ItemStack getRailingsBow() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_ID_RAILINGS_BOW);
    }

    public void setRailingsBow(ItemStack itemStack) {
        this.f_19804_.m_135381_(DATA_ID_RAILINGS_BOW, (Object)itemStack.m_41777_());
    }

    public ItemStack getAnchor() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_ID_ANCHOR);
    }

    public void setAnchor(ItemStack itemStack) {
        this.f_19804_.m_135381_(DATA_ID_ANCHOR, (Object)itemStack.m_41777_());
    }

    public ItemStack getRigging() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_ID_RIGGING);
    }

    public void setRigging(ItemStack itemStack) {
        this.f_19804_.m_135381_(DATA_ID_RIGGING, (Object)itemStack.m_41777_());
    }

    public ConstructionState getConstructionStage() {
        return ConstructionState.getByOrdinal((Integer)this.f_19804_.m_135370_(DATA_ID_CONSTRUCTION_STAGE));
    }

    public void setConstructionStage(ConstructionState stage) {
        this.f_19804_.m_135381_(DATA_ID_CONSTRUCTION_STAGE, (Object)stage.ordinal());
    }

    @Override
    protected void m_7378_(CompoundTag compoundTag) {
        this.setKeel(ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("keel")));
        this.setDeck(ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("deck")));
        this.setBowsprit(ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("bowsprit")));
        this.setMast(ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("mast")));
        this.setBoom(ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("boom")));
        this.setMainsail(ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("mainsail")));
        this.setJibsail(ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("jibsail")));
        this.setRailingsBow(ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("railingsBow")));
        this.setRailingsStern(ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("railingStern")));
        this.setAnchor(ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("anchor")));
        this.setRigging(ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("rigging")));
        this.setConstructionStage(ConstructionState.getByOrdinal(compoundTag.m_128451_("stage")));
    }

    @Override
    protected void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128365_("keel", (Tag)this.getKeel().m_41739_(new CompoundTag()));
        compoundTag.m_128365_("deck", (Tag)this.getDeck().m_41739_(new CompoundTag()));
        compoundTag.m_128365_("bowsprit", (Tag)this.getBowsprit().m_41739_(new CompoundTag()));
        compoundTag.m_128365_("mast", (Tag)this.getMast().m_41739_(new CompoundTag()));
        compoundTag.m_128365_("boom", (Tag)this.getBoom().m_41739_(new CompoundTag()));
        compoundTag.m_128365_("mainsail", (Tag)this.getMainsail().m_41739_(new CompoundTag()));
        compoundTag.m_128365_("jibsail", (Tag)this.getJibsail().m_41739_(new CompoundTag()));
        compoundTag.m_128365_("railingsBow", (Tag)this.getRailingsBow().m_41739_(new CompoundTag()));
        compoundTag.m_128365_("railingsStern", (Tag)this.getRailingsStern().m_41739_(new CompoundTag()));
        compoundTag.m_128365_("anchor", (Tag)this.getAnchor().m_41739_(new CompoundTag()));
        compoundTag.m_128365_("rigging", (Tag)this.getRigging().m_41739_(new CompoundTag()));
        compoundTag.m_128405_("stage", this.getConstructionStage().ordinal());
    }

    @Override
    public int[] getCompartmentIndices() {
        return new int[0];
    }

    @Override
    public boolean isFunctional() {
        return true;
    }

    @Override
    protected Vec3 positionRiderByIndex(int index) {
        float localX = 0.0f;
        float localZ = 0.0f;
        float localY = (float)(this.m_213877_() ? (double)0.01f : this.m_6048_());
        ConstructionState stage = this.getConstructionStage();
        switch (stage) {
            case KEEL: {
                localX = 0.0f;
                localZ = 0.0f;
                localY += -0.0f;
                break;
            }
            case DECK: {
                localX = -1.0f;
                localZ = 0.0f;
                localY += 0.5f;
                break;
            }
            case BOWSPRIT: {
                localX = 4.0f;
                localZ = 0.0f;
                localY += 0.7f;
                break;
            }
            case MAST: {
                localX = 2.0f;
                localZ = 0.0f;
                localY += 2.0f;
                break;
            }
            case BOOM: {
                localX = 1.8f;
                localZ = 0.0f;
                localY += 2.25f;
                break;
            }
            case MAINSAIL: {
                localX = 1.5f;
                localZ = 0.0f;
                localY += 2.5f;
                break;
            }
            case JIBSAIl: {
                localX = 3.0f;
                localZ = 0.0f;
                localY += 0.5f;
                break;
            }
            case RAILINGS_STERN: {
                localX = -3.0f;
                localZ = 0.0f;
                localY += 0.8f;
                break;
            }
            case RAILINGS_BOW: {
                localX = 4.0f;
                localZ = 0.0f;
                localY += 0.8f;
                break;
            }
            case ANCHOR: {
                localZ = -1.34f;
                localX = 2.52f;
                localY += 0.7f;
                break;
            }
            case RIGGING: {
                localX = 1.5f;
                localZ = 0.0f;
                localY += 1.5f;
            }
        }
        return new Vec3((double)localX, (double)localY, (double)localZ);
    }

    @Override
    public float getDamageThreshold() {
        return 40.0f;
    }

    @Override
    public float getDeathDamageThreshold() {
        return this.getDamageThreshold() * 1.25f;
    }

    @Override
    public float getDamageRecovery() {
        return 10.0f;
    }

    public Item getCurrentRequiredItem() {
        ConstructionState stage = this.getConstructionStage();
        switch (stage) {
            case KEEL: 
            case BOWSPRIT: 
            case MAST: 
            case BOOM: {
                return (Item)this.getBoomItem().getA();
            }
            case DECK: {
                return (Item)this.getDeckItem().getA();
            }
            case MAINSAIL: {
                return (Item)this.getMainsailItem().getA();
            }
            case JIBSAIl: {
                return (Item)this.getJibsailItem().getA();
            }
            case RAILINGS_STERN: {
                return (Item)this.getSternRailingsItem().getA();
            }
            case RAILINGS_BOW: {
                return (Item)this.getBowRailingsItem().getA();
            }
            case ANCHOR: {
                return (Item)this.getAnchorItem().getA();
            }
            case RIGGING: {
                return (Item)this.getRiggingItem().getA();
            }
        }
        return null;
    }

    public int getNumberItemsLeft() {
        ConstructionState stage = this.getConstructionStage();
        switch (stage) {
            case KEEL: {
                return (Integer)this.getKeelItem().getB() - this.getKeel().m_41613_();
            }
            case DECK: {
                return (Integer)this.getDeckItem().getB() - this.getDeck().m_41613_();
            }
            case BOWSPRIT: {
                return (Integer)this.getBowspritItem().getB() - this.getBowsprit().m_41613_();
            }
            case MAST: {
                return (Integer)this.getMastItem().getB() - this.getMast().m_41613_();
            }
            case BOOM: {
                return (Integer)this.getBoomItem().getB() - this.getBoom().m_41613_();
            }
            case MAINSAIL: {
                return (Integer)this.getMainsailItem().getB() - this.getMainsail().m_41613_();
            }
            case JIBSAIl: {
                return (Integer)this.getJibsailItem().getB() - this.getJibsail().m_41613_();
            }
            case RAILINGS_STERN: {
                return (Integer)this.getSternRailingsItem().getB() - this.getRailingsStern().m_41613_();
            }
            case RAILINGS_BOW: {
                return (Integer)this.getBowRailingsItem().getB() - this.getRailingsBow().m_41613_();
            }
            case ANCHOR: {
                return (Integer)this.getAnchorItem().getB() - this.getAnchor().m_41613_();
            }
            case RIGGING: {
                return (Integer)this.getRiggingItem().getB() - this.getRigging().m_41613_();
            }
        }
        return -1;
    }

    @Override
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        return InteractionResult.PASS;
    }

    @Override
    public void interactFromConstructionEntity(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        ConstructionState stage = this.getConstructionStage();
        BlockPos thisPos = this.m_20183_();
        Direction thisDir = this.m_6350_();
        thisPos = thisPos.m_5484_(thisDir, 4);
        thisPos = thisPos.m_5484_(thisDir.m_122428_(), 2);
        switch (stage) {
            case KEEL: {
                if (!stack.m_150930_((Item)this.getKeelItem().getA())) break;
                this.setKeel(new ItemStack((ItemLike)stack.m_41620_(1).m_41720_(), this.getKeel().m_41613_() + 1));
                this.m_216990_(SoundEvents.f_12635_);
                if (this.getKeel().m_41613_() < (Integer)this.getKeelItem().getB()) break;
                this.setConstructionStage(ConstructionState.DECK);
                for (int x = 0; x < 4; ++x) {
                    for (int y = 0; y < 7; ++y) {
                        this.m_216990_(SoundEvents.f_12630_);
                        this.m_9236_().m_142052_(thisPos.m_5484_(thisDir.m_122424_(), y).m_5484_(thisDir.m_122427_(), x), this.boatMaterial.getDeckBlock());
                    }
                }
                break;
            }
            case DECK: {
                if (!stack.m_150930_((Item)this.getDeckItem().getA())) break;
                this.setDeck(new ItemStack((ItemLike)stack.m_41620_(1).m_41720_(), this.getDeck().m_41613_() + 1));
                this.m_216990_(SoundEvents.f_12635_);
                if (this.getDeck().m_41613_() < (Integer)this.getDeckItem().getB()) break;
                this.setConstructionStage(ConstructionState.BOWSPRIT);
                for (int x = 0; x < 4; ++x) {
                    for (int y = 0; y < 7; ++y) {
                        this.m_216990_(SoundEvents.f_12630_);
                        this.m_9236_().m_142052_(thisPos.m_5484_(thisDir.m_122424_(), y).m_5484_(thisDir.m_122427_(), x), this.boatMaterial.getDeckBlock());
                    }
                }
                break;
            }
            case BOWSPRIT: {
                if (!stack.m_150930_((Item)this.getBowspritItem().getA())) break;
                this.setBowsprit(new ItemStack((ItemLike)stack.m_41620_(1).m_41720_(), this.getBowsprit().m_41613_() + 1));
                this.m_216990_(SoundEvents.f_12635_);
                if (this.getBowsprit().m_41613_() < (Integer)this.getBowspritItem().getB()) break;
                this.setConstructionStage(ConstructionState.MAST);
                for (int x = 0; x < 4; ++x) {
                    for (int y = 0; y < 7; ++y) {
                        this.m_216990_(SoundEvents.f_12630_);
                        this.m_9236_().m_142052_(thisPos.m_5484_(thisDir.m_122424_(), y).m_5484_(thisDir.m_122427_(), x), this.boatMaterial.getDeckBlock());
                    }
                }
                break;
            }
            case MAST: {
                if (!stack.m_150930_((Item)this.getMastItem().getA())) break;
                this.setMast(new ItemStack((ItemLike)stack.m_41620_(1).m_41720_(), this.getMast().m_41613_() + 1));
                this.m_216990_(SoundEvents.f_12635_);
                if (this.getMast().m_41613_() < (Integer)this.getMastItem().getB()) break;
                this.setConstructionStage(ConstructionState.BOOM);
                for (int x = 0; x < 4; ++x) {
                    for (int y = 0; y < 7; ++y) {
                        this.m_216990_(SoundEvents.f_12630_);
                        this.m_9236_().m_142052_(thisPos.m_5484_(thisDir.m_122424_(), y).m_5484_(thisDir.m_122427_(), x), this.boatMaterial.getDeckBlock());
                    }
                }
                break;
            }
            case BOOM: {
                if (!stack.m_150930_((Item)this.getBoomItem().getA())) break;
                this.setBoom(new ItemStack((ItemLike)stack.m_41620_(1).m_41720_(), this.getBoom().m_41613_() + 1));
                this.m_216990_(SoundEvents.f_12635_);
                if (this.getBoom().m_41613_() < (Integer)this.getBoomItem().getB()) break;
                this.setConstructionStage(ConstructionState.MAINSAIL);
                for (int x = 0; x < 4; ++x) {
                    for (int y = 0; y < 7; ++y) {
                        this.m_216990_(SoundEvents.f_12630_);
                        this.m_9236_().m_142052_(thisPos.m_5484_(thisDir.m_122424_(), y).m_5484_(thisDir.m_122427_(), x), this.boatMaterial.getDeckBlock());
                    }
                }
                break;
            }
            case MAINSAIL: {
                if (!stack.m_150930_((Item)this.getMainsailItem().getA())) break;
                this.setMainsail(new ItemStack((ItemLike)stack.m_41620_(1).m_41720_(), this.getMainsail().m_41613_() + 1));
                this.m_216990_(SoundEvents.f_12642_);
                if (this.getMainsail().m_41613_() < (Integer)this.getMainsailItem().getB()) break;
                this.setConstructionStage(ConstructionState.JIBSAIl);
                for (int x = 0; x < 4; ++x) {
                    for (int y = 0; y < 7; ++y) {
                        this.m_216990_(SoundEvents.f_12639_);
                        this.m_9236_().m_142052_(thisPos.m_5484_(thisDir.m_122424_(), y).m_5484_(thisDir.m_122427_(), x), Blocks.f_50041_.m_49966_());
                    }
                }
                break;
            }
            case JIBSAIl: {
                if (!stack.m_150930_((Item)this.getJibsailItem().getA())) break;
                this.setJibsail(new ItemStack((ItemLike)stack.m_41620_(1).m_41720_(), this.getJibsail().m_41613_() + 1));
                this.m_216990_(SoundEvents.f_12642_);
                if (this.getJibsail().m_41613_() < (Integer)this.getJibsailItem().getB()) break;
                this.setConstructionStage(ConstructionState.RAILINGS_STERN);
                for (int x = 0; x < 4; ++x) {
                    for (int y = 0; y < 7; ++y) {
                        this.m_216990_(SoundEvents.f_12639_);
                        this.m_9236_().m_142052_(thisPos.m_5484_(thisDir.m_122424_(), y).m_5484_(thisDir.m_122427_(), x), Blocks.f_50041_.m_49966_());
                    }
                }
                break;
            }
            case RAILINGS_STERN: {
                if (!stack.m_150930_((Item)this.getSternRailingsItem().getA())) break;
                this.setRailingsStern(new ItemStack((ItemLike)stack.m_41620_(1).m_41720_(), this.getRailingsStern().m_41613_() + 1));
                this.m_216990_(SoundEvents.f_12635_);
                if (this.getRailingsStern().m_41613_() < (Integer)this.getSternRailingsItem().getB()) break;
                this.setConstructionStage(ConstructionState.RAILINGS_BOW);
                for (int x = 0; x < 4; ++x) {
                    for (int y = 0; y < 7; ++y) {
                        this.m_216990_(SoundEvents.f_12630_);
                        this.m_9236_().m_142052_(thisPos.m_5484_(thisDir.m_122424_(), y).m_5484_(thisDir.m_122427_(), x), this.boatMaterial.getDeckBlock());
                    }
                }
                break;
            }
            case RAILINGS_BOW: {
                if (!stack.m_150930_((Item)this.getBowRailingsItem().getA())) break;
                this.setRailingsBow(new ItemStack((ItemLike)stack.m_41620_(1).m_41720_(), this.getRailingsBow().m_41613_() + 1));
                this.m_216990_(SoundEvents.f_12635_);
                if (this.getRailingsBow().m_41613_() < (Integer)this.getBowRailingsItem().getB()) break;
                this.setConstructionStage(ConstructionState.ANCHOR);
                for (int x = 0; x < 4; ++x) {
                    for (int y = 0; y < 7; ++y) {
                        this.m_216990_(SoundEvents.f_12630_);
                        this.m_9236_().m_142052_(thisPos.m_5484_(thisDir.m_122424_(), y).m_5484_(thisDir.m_122427_(), x), this.boatMaterial.getDeckBlock());
                    }
                }
                break;
            }
            case ANCHOR: {
                if (!stack.m_150930_((Item)this.getAnchorItem().getA())) break;
                this.setAnchor(new ItemStack((ItemLike)stack.m_41620_(1).m_41720_(), this.getAnchor().m_41613_() + 1));
                this.m_216990_(SoundEvents.f_12065_);
                if (this.getAnchor().m_41613_() < (Integer)this.getAnchorItem().getB()) break;
                this.setConstructionStage(ConstructionState.RIGGING);
                for (int x = 0; x < 4; ++x) {
                    for (int y = 0; y < 7; ++y) {
                        this.m_216990_(SoundEvents.f_12630_);
                        this.m_9236_().m_142052_(thisPos.m_5484_(thisDir.m_122424_(), y).m_5484_(thisDir.m_122427_(), x), this.boatMaterial.getDeckBlock());
                    }
                }
                break;
            }
            case RIGGING: {
                if (!stack.m_150930_((Item)this.getRiggingItem().getA())) break;
                this.setRigging(new ItemStack((ItemLike)stack.m_41620_(1).m_41720_(), this.getRigging().m_41613_() + 1));
                this.m_216990_(SoundEvents.f_12087_);
                if (this.getRigging().m_41613_() < (Integer)this.getRiggingItem().getB()) break;
                this.boatMaterial.getEntityType(BoatMaterial.BoatType.SLOOP).ifPresent(entityType -> {
                    AbstractVehicle sloop = (AbstractVehicle)entityType.m_20615_(this.m_9236_());
                    if (sloop != null) {
                        sloop.m_146922_(this.m_146908_());
                        sloop.m_146884_(this.m_20318_(0.0f));
                        this.m_9236_().m_7967_((Entity)sloop);
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            AlekiShipsAdvancements.SLOOP_COMPLETED.trigger(serverPlayer);
                        }
                    }
                });
                for (int x = 0; x < 4; ++x) {
                    for (int y = 0; y < 7; ++y) {
                        for (int z = 0; z < 11; ++z) {
                            this.m_216990_(SoundEvents.f_12630_);
                            this.m_9236_().m_142052_(thisPos.m_5484_(thisDir.m_122424_(), y).m_5484_(thisDir.m_122427_(), x).m_5484_(Direction.UP, z), this.boatMaterial.getDeckBlock());
                            this.m_9236_().m_142052_(thisPos.m_5484_(thisDir.m_122424_(), y).m_5484_(thisDir.m_122427_(), x).m_5484_(Direction.UP, z), ((AngledBoatFrameBlock)((Object)AlekiShipsBlocks.BOAT_FRAME_ANGLED.get())).m_49966_());
                        }
                    }
                }
                this.m_6074_();
            }
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.getDamage() > this.getDamageThreshold()) {
            this.m_6074_();
            this.m_19983_(this.getKeel());
            this.m_19983_(this.getDeck());
            this.m_19983_(this.getBowsprit());
            this.m_19983_(this.getMast());
            this.m_19983_(this.getBoom());
            this.m_19983_(this.getMainsail());
            this.m_19983_(this.getJibsail());
            this.m_19983_(this.getAnchor());
            this.m_19983_(this.getRigging());
        }
    }

    public static enum ConstructionState {
        KEEL,
        DECK,
        BOWSPRIT,
        MAST,
        BOOM,
        MAINSAIL,
        JIBSAIl,
        RAILINGS_STERN,
        RAILINGS_BOW,
        ANCHOR,
        RIGGING,
        COMPLETE;

        private static final ConstructionState[] BY_ORDINAL;

        public static ConstructionState getByOrdinal(int ordinal) {
            return BY_ORDINAL[ordinal % BY_ORDINAL.length];
        }

        static {
            BY_ORDINAL = (ConstructionState[])Arrays.stream(ConstructionState.values()).sorted(Comparator.comparingInt(Enum::ordinal)).toArray(ConstructionState[]::new);
        }
    }
}

