/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.common.entity.vehiclehelper;

import com.alekiponi.alekiships.client.IngameOverlays;
import com.alekiponi.alekiships.common.entity.IHaveIcons;
import com.alekiponi.alekiships.common.entity.vehicle.AbstractVehicle;
import com.alekiponi.alekiships.common.entity.vehiclehelper.AbstractPassthroughHelper;
import com.alekiponi.alekiships.network.ClientBoundCleatLinkPacket;
import com.alekiponi.alekiships.network.PacketHandler;
import com.alekiponi.alekiships.util.CommonHelper;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class CleatEntity
extends AbstractPassthroughHelper
implements IHaveIcons {
    protected static final EntityDataAccessor<Integer> DATA_ID_LEASHHOLDER_ID = SynchedEntityData.m_135353_(CleatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    private Entity leashHolder;
    private int delayedLeashHolderId;
    @Nullable
    private CompoundTag leashInfoTag;
    protected int lerpSteps;
    protected double lerpX;
    protected double lerpY;
    protected double lerpZ;
    protected double lerpYRot;
    protected double lerpXRot;

    public CleatEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public void m_8119_() {
        if (!this.m_20159_()) {
            this.dropLeash(true, true);
            this.m_6074_();
        }
        super.m_8119_();
        this.tickLerp();
        this.tickLeash();
        if (this.f_19797_ < 2) {
            if (!this.m_9236_().m_5776_()) {
                if (this.leashHolder != null) {
                    this.setLeashHolderId(this.leashHolder.m_19879_());
                }
            } else if (this.m_9236_().m_6815_(this.getLeashHolderId()) != null) {
                this.leashHolder = this.m_9236_().m_6815_(this.getLeashHolderId());
            }
        }
    }

    @Override
    public final InteractionResult m_6096_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (this.getLeashHolder() == pPlayer) {
            this.dropLeash(true, !pPlayer.m_150110_().f_35937_);
            this.m_146852_(GameEvent.f_223708_, (Entity)pPlayer);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemstack.m_150930_(Items.f_42655_) && this.canBeLeashed(pPlayer)) {
            this.setLeashedTo((Entity)pPlayer, true);
            itemstack.m_41774_(1);
            this.m_5496_(SoundEvents.f_12087_, 1.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return InteractionResult.PASS;
    }

    protected void tickLeash() {
        Entity leashHolder;
        if (this.leashInfoTag != null) {
            this.restoreLeashFromSave();
        }
        if ((leashHolder = this.getLeashHolder()) != null) {
            LeashFenceKnotEntity leashFenceKnotEntity;
            if (!this.m_6084_() || !leashHolder.m_6084_()) {
                this.dropLeash(true, true);
            }
            if (leashHolder instanceof LeashFenceKnotEntity && !(leashFenceKnotEntity = (LeashFenceKnotEntity)leashHolder).m_7088_()) {
                this.dropLeash(true, true);
            }
            if (this.m_20270_(leashHolder) > 10.0f) {
                if (leashHolder instanceof Player) {
                    Player player = (Player)leashHolder;
                    this.dropLeash(true, !player.m_150110_().f_35937_);
                } else {
                    this.dropLeash(true, true);
                }
            }
        }
    }

    protected void tickLerp() {
        if (this.m_6109_()) {
            this.lerpSteps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.lerpSteps > 0) {
            double d0 = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double d1 = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double d2 = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            double d3 = Mth.m_14175_((double)(this.lerpYRot - (double)this.m_146908_()));
            this.m_146922_(this.m_146908_() + (float)d3 / (float)this.lerpSteps);
            this.m_146926_(this.m_146909_() + (float)(this.lerpXRot - (double)this.m_146909_()) / (float)this.lerpSteps);
            --this.lerpSteps;
            this.m_6034_(d0, d1, d2);
        }
    }

    public void dropLeash(boolean pBroadcastPacket, boolean pDropLeash) {
        if (this.leashHolder != null) {
            if (!this.m_9236_().f_46443_ && pDropLeash) {
                this.m_5496_(SoundEvents.f_12033_, 1.0f, 1.0f);
                Entity entity = this.leashHolder;
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    CommonHelper.giveItemToPlayer(player, Items.f_42655_.m_7968_());
                } else {
                    this.m_19998_((ItemLike)Items.f_42655_);
                    if (this.leashHolder instanceof LeashFenceKnotEntity) {
                        this.leashHolder.m_6074_();
                    }
                }
            }
            this.leashHolder = null;
            this.leashInfoTag = null;
            if (!this.m_9236_().m_5776_() && pBroadcastPacket && this.m_9236_() instanceof ServerLevel) {
                PacketHandler.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), new ClientBoundCleatLinkPacket(this, null));
            }
        }
    }

    protected void m_6089_() {
        super.m_6089_();
        this.dropLeash(true, false);
    }

    public boolean canBeLeashed(Player pPlayer) {
        return !this.isLeashed();
    }

    public boolean isLeashed() {
        return this.leashHolder != null;
    }

    @Nullable
    public Entity getLeashHolder() {
        if (this.leashHolder == null && this.delayedLeashHolderId != 0 && this.m_9236_().f_46443_) {
            this.leashHolder = this.m_9236_().m_6815_(this.delayedLeashHolderId);
        }
        return this.leashHolder;
    }

    public void setLeashedTo(Entity pLeashHolder, boolean pBroadcastPacket) {
        this.leashHolder = pLeashHolder;
        this.leashInfoTag = null;
        if (!this.m_9236_().m_5776_() && pBroadcastPacket && this.m_9236_() instanceof ServerLevel) {
            PacketHandler.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), new ClientBoundCleatLinkPacket(this, this.leashHolder));
        }
    }

    public void setDelayedLeashHolderId(int pLeashHolderID) {
        this.delayedLeashHolderId = pLeashHolderID;
        this.dropLeash(false, false);
    }

    private void restoreLeashFromSave() {
        if (this.leashInfoTag != null && this.m_9236_() instanceof ServerLevel) {
            if (this.leashInfoTag.m_128403_("UUID")) {
                UUID uuid = this.leashInfoTag.m_128342_("UUID");
                Entity entity = ((ServerLevel)this.m_9236_()).m_8791_(uuid);
                if (entity != null) {
                    this.setLeashedTo(entity, true);
                    return;
                }
            } else if (this.leashInfoTag.m_128425_("X", 99) && this.leashInfoTag.m_128425_("Y", 99) && this.leashInfoTag.m_128425_("Z", 99)) {
                BlockPos blockpos = NbtUtils.m_129239_((CompoundTag)this.leashInfoTag);
                this.setLeashedTo((Entity)LeashFenceKnotEntity.m_31844_((Level)this.m_9236_(), (BlockPos)blockpos), true);
                return;
            }
            if (this.f_19797_ > 100) {
                this.m_19998_((ItemLike)Items.f_42655_);
                this.leashInfoTag = null;
            }
        }
    }

    @Override
    public boolean m_6087_() {
        return !this.m_213877_();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ID_LEASHHOLDER_ID, (Object)-1);
    }

    protected void m_7378_(CompoundTag pCompound) {
        if (pCompound.m_128425_("Leash", 10)) {
            this.leashInfoTag = pCompound.m_128469_("Leash");
        }
    }

    public Vec3 m_245894_(float pPartialTick) {
        return new Vec3(0.0, 0.0, 0.0);
    }

    protected void m_7380_(CompoundTag pCompound) {
        if (this.leashHolder != null) {
            CompoundTag compoundtag2 = new CompoundTag();
            if (this.leashHolder instanceof LivingEntity) {
                UUID uuid = this.leashHolder.m_20148_();
                compoundtag2.m_128362_("UUID", uuid);
            } else if (this.leashHolder instanceof HangingEntity) {
                BlockPos blockpos = ((HangingEntity)this.leashHolder).m_31748_();
                compoundtag2.m_128405_("X", blockpos.m_123341_());
                compoundtag2.m_128405_("Y", blockpos.m_123342_());
                compoundtag2.m_128405_("Z", blockpos.m_123343_());
            }
            pCompound.m_128365_("Leash", (Tag)compoundtag2);
        } else if (this.leashInfoTag != null) {
            pCompound.m_128365_("Leash", (Tag)this.leashInfoTag.m_6426_());
        }
    }

    public AABB m_6921_() {
        float bbRadius = 21.0f;
        Vec3 startingPoint = new Vec3(this.m_20185_() - (double)bbRadius, this.m_20186_() - (double)bbRadius, this.m_20189_() - (double)bbRadius);
        Vec3 endingPoint = new Vec3(this.m_20185_() + (double)bbRadius, this.m_20186_() + (double)bbRadius, this.m_20189_() + (double)bbRadius);
        return new AABB(startingPoint, endingPoint);
    }

    public void setLeashHolderId(int id) {
        this.f_19804_.m_135381_(DATA_ID_LEASHHOLDER_ID, (Object)id);
    }

    public int getLeashHolderId() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_LEASHHOLDER_ID);
    }

    @Override
    public ArrayList<IngameOverlays.IconState> getIconStates(Player player) {
        ArrayList<IngameOverlays.IconState> states = new ArrayList<IngameOverlays.IconState>();
        if (this.m_20159_() && !this.isLeashed() && this.m_20201_() instanceof AbstractVehicle) {
            states.add(IngameOverlays.IconState.LEAD);
        }
        return states;
    }
}

