/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.vanilla;

import com.alekiponi.alekiships.common.entity.vehiclehelper.CompartmentType;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.BlockCompartment;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.ContainerCompartmentEntity;
import com.alekiponi.alekiships.util.CommonHelper;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractFurnaceMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class AbstractFurnaceCompartmentEntity
extends ContainerCompartmentEntity.ContainerMenuCompartmentEntity
implements WorldlyContainer,
RecipeHolder,
StackedContentsCompatible,
BlockCompartment {
    public static final int SLOT_COUNT = 3;
    public static final String BURN_TIME_KEY = "BurnTime";
    public static final String COOK_TIME_KEY = "CookTime";
    public static final String COOK_TIME_TOTAL_KEY = "CookTimeTotal";
    public static final String RECIPES_USED_KEY = "RecipesUsed";
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_FUEL = 1;
    public static final int SLOT_RESULT = 2;
    private static final EntityDataAccessor<BlockState> DATA_ID_DISPLAY_BLOCK = SynchedEntityData.m_135353_(AbstractFurnaceCompartmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135034_);
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_FOR_SIDES = new int[]{1};
    private final RecipeType<? extends AbstractCookingRecipe> recipeType;
    private final RecipeManager.CachedCheck<Container, ? extends AbstractCookingRecipe> quickCheck;
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    protected int litTime;
    protected int litDuration;
    protected int cookingProgress;
    protected int cookingTotalTime;
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int dataType) {
            return switch (dataType) {
                case 0 -> AbstractFurnaceCompartmentEntity.this.litTime;
                case 1 -> AbstractFurnaceCompartmentEntity.this.litDuration;
                case 2 -> AbstractFurnaceCompartmentEntity.this.cookingProgress;
                case 3 -> AbstractFurnaceCompartmentEntity.this.cookingTotalTime;
                default -> 0;
            };
        }

        public void m_8050_(int dataType, int dataValue) {
            switch (dataType) {
                case 0: {
                    AbstractFurnaceCompartmentEntity.this.litTime = dataValue;
                    break;
                }
                case 1: {
                    AbstractFurnaceCompartmentEntity.this.litDuration = dataValue;
                    break;
                }
                case 2: {
                    AbstractFurnaceCompartmentEntity.this.cookingProgress = dataValue;
                    break;
                }
                case 3: {
                    AbstractFurnaceCompartmentEntity.this.cookingTotalTime = dataValue;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };
    private LazyOptional<? extends IItemHandler>[] directionalHandlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    protected AbstractFurnaceCompartmentEntity(CompartmentType<? extends AbstractFurnaceCompartmentEntity> compartmentType, Level level, RecipeType<? extends AbstractCookingRecipe> recipeType) {
        super((CompartmentType<? extends ContainerCompartmentEntity.ContainerMenuCompartmentEntity>)compartmentType, level, 3);
        this.quickCheck = RecipeManager.m_220267_(recipeType);
        this.recipeType = recipeType;
    }

    protected AbstractFurnaceCompartmentEntity(CompartmentType<? extends AbstractFurnaceCompartmentEntity> compartmentType, Level level, RecipeType<? extends AbstractCookingRecipe> recipeType, ItemStack itemStack) {
        super((CompartmentType<? extends ContainerCompartmentEntity.ContainerMenuCompartmentEntity>)compartmentType, level, 3, itemStack);
        this.quickCheck = RecipeManager.m_220267_(recipeType);
        this.recipeType = recipeType;
        Item item = itemStack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            this.setDisplayBlockState((BlockState)blockItem.m_40614_().m_49966_().m_61124_((Property)AbstractFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(this.isLit())));
        }
    }

    private static void createExperience(ServerLevel level, Vec3 vec3, int recipeIndex, float experience) {
        int i = Mth.m_14143_((float)((float)recipeIndex * experience));
        float f = Mth.m_14187_((float)((float)recipeIndex * experience));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        ExperienceOrb.m_147082_((ServerLevel)level, (Vec3)vec3, (int)i);
    }

    private static int getTotalCookTime(Level pLevel, AbstractFurnaceCompartmentEntity furnaceCompartment) {
        return furnaceCompartment.quickCheck.m_213657_((Container)furnaceCompartment, pLevel).map(AbstractCookingRecipe::m_43753_).orElse(200);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_DISPLAY_BLOCK, (Object)Blocks.f_50016_.m_49966_());
    }

    @Override
    public void m_8119_() {
        boolean fuelSlotEmpty;
        super.m_8119_();
        boolean isLitStart = this.isLit();
        if (this.isLit()) {
            --this.litTime;
        }
        if (this.m_9236_().m_5776_()) {
            if (!this.m_213877_() && CommonHelper.everyNthTickUnique(this.m_19879_(), this.f_19797_, 10)) {
                this.animateTick();
            }
            return;
        }
        ItemStack fuelStack = this.m_8020_(1);
        boolean inputSlotEmpty = !this.m_8020_(0).m_41619_();
        boolean bl = fuelSlotEmpty = !fuelStack.m_41619_();
        if (this.isLit() || fuelSlotEmpty && inputSlotEmpty) {
            AbstractCookingRecipe recipe = inputSlotEmpty ? (AbstractCookingRecipe)this.quickCheck.m_213657_((Container)this, this.m_9236_()).orElse(null) : null;
            int maxStackSize = this.m_6893_();
            if (!this.isLit() && this.canBurn(this.m_9236_().m_9598_(), recipe, (NonNullList<ItemStack>)this.itemStacks, maxStackSize)) {
                this.litDuration = this.litTime = this.getBurnDuration(fuelStack);
                if (this.isLit()) {
                    if (fuelStack.hasCraftingRemainingItem()) {
                        this.m_6836_(1, fuelStack.getCraftingRemainingItem());
                    } else if (fuelSlotEmpty) {
                        fuelStack.m_41774_(1);
                        if (fuelStack.m_41619_()) {
                            this.m_6836_(1, fuelStack.getCraftingRemainingItem());
                        }
                    }
                }
            }
            if (this.isLit() && this.canBurn(this.m_9236_().m_9598_(), recipe, (NonNullList<ItemStack>)this.itemStacks, maxStackSize)) {
                ++this.cookingProgress;
                if (this.cookingProgress == this.cookingTotalTime) {
                    this.cookingProgress = 0;
                    this.cookingTotalTime = AbstractFurnaceCompartmentEntity.getTotalCookTime(this.m_9236_(), this);
                    if (this.burn(this.m_9236_().m_9598_(), recipe, (NonNullList<ItemStack>)this.itemStacks, maxStackSize)) {
                        this.m_6029_((Recipe<?>)recipe);
                    }
                }
            } else {
                this.cookingProgress = 0;
            }
        } else if (!this.isLit() && this.cookingProgress > 0) {
            this.cookingProgress = Mth.m_14045_((int)(this.cookingProgress - 2), (int)0, (int)this.cookingTotalTime);
        }
        if (isLitStart != this.isLit()) {
            this.setDisplayBlockState((BlockState)this.getDisplayBlockState().m_61124_((Property)AbstractFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(this.isLit())));
        }
    }

    public void m_5809_(StackedContents stackedContents) {
        for (ItemStack itemstack : this.itemStacks) {
            stackedContents.m_36491_(itemstack);
        }
    }

    @Nullable
    public Recipe<?> m_7928_() {
        return null;
    }

    public void m_6029_(@Nullable Recipe<?> recipe) {
        if (recipe != null) {
            ResourceLocation resourceLocation = recipe.m_6423_();
            this.recipesUsed.addTo((Object)resourceLocation, 1);
        }
    }

    private boolean burn(RegistryAccess registryAccess, @Nullable AbstractCookingRecipe cookingRecipe, NonNullList<ItemStack> itemStacks, int maxStackSize) {
        if (cookingRecipe == null || !this.canBurn(registryAccess, cookingRecipe, itemStacks, maxStackSize)) {
            return false;
        }
        ItemStack inputStack = (ItemStack)itemStacks.get(0);
        ItemStack recipeOutput = cookingRecipe.m_5874_((Container)this, registryAccess);
        ItemStack outputSlot = (ItemStack)itemStacks.get(2);
        if (outputSlot.m_41619_()) {
            itemStacks.set(2, (Object)recipeOutput.m_41777_());
        } else if (outputSlot.m_150930_(recipeOutput.m_41720_())) {
            outputSlot.m_41769_(recipeOutput.m_41613_());
        }
        if (inputStack.m_150930_(Blocks.f_50057_.m_5456_()) && !((ItemStack)itemStacks.get(1)).m_41619_() && ((ItemStack)itemStacks.get(1)).m_150930_(Items.f_42446_)) {
            itemStacks.set(1, (Object)Items.f_42447_.m_7968_());
        }
        inputStack.m_41774_(1);
        return true;
    }

    protected int getBurnDuration(ItemStack itemStack) {
        return ForgeHooks.getBurnTime((ItemStack)itemStack, this.recipeType);
    }

    private boolean canBurn(RegistryAccess registryAccess, @Nullable AbstractCookingRecipe cookingRecipe, NonNullList<ItemStack> itemStacks, int maxStackSize) {
        if (((ItemStack)itemStacks.get(0)).m_41619_() || cookingRecipe == null) {
            return false;
        }
        ItemStack itemstack = cookingRecipe.m_5874_((Container)this, registryAccess);
        if (itemstack.m_41619_()) {
            return false;
        }
        ItemStack outputStack = (ItemStack)itemStacks.get(2);
        if (outputStack.m_41619_()) {
            return true;
        }
        if (!ItemStack.m_41656_((ItemStack)outputStack, (ItemStack)itemstack)) {
            return false;
        }
        if (outputStack.m_41613_() + itemstack.m_41613_() <= maxStackSize && outputStack.m_41613_() + itemstack.m_41613_() <= outputStack.m_41741_()) {
            return true;
        }
        return outputStack.m_41613_() + itemstack.m_41613_() <= itemstack.m_41741_();
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer player) {
        List<Recipe<?>> list = this.getRecipesToAwardAndPopExperience(player.m_284548_(), player.m_20182_());
        player.m_7281_(list);
        for (Recipe<?> recipe : list) {
            if (recipe == null) continue;
            player.m_280300_(recipe, (List)this.itemStacks);
        }
        this.recipesUsed.clear();
    }

    public List<Recipe<?>> getRecipesToAwardAndPopExperience(ServerLevel level, Vec3 vec3) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            level.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                AbstractFurnaceCompartmentEntity.createExperience(level, vec3, entry.getIntValue(), ((AbstractCookingRecipe)recipe).m_43750_());
            });
        }
        return list;
    }

    @Override
    protected void onHurt(DamageSource damageSource) {
        BlockCompartment.playHitSound(this);
    }

    @Override
    protected void onPlaced() {
        BlockCompartment.playPlaceSound(this);
    }

    @Override
    protected void onBreak() {
        super.onBreak();
        BlockCompartment.playBreakSound(this);
    }

    public int[] m_7071_(Direction direction) {
        if (direction == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        return direction == Direction.UP ? SLOTS_FOR_UP : SLOTS_FOR_SIDES;
    }

    public boolean m_7155_(int slotIndex, ItemStack itemStack, @Nullable Direction direction) {
        return this.m_7013_(slotIndex, itemStack);
    }

    public boolean m_7157_(int slotIndex, ItemStack itemStack, Direction direction) {
        if (direction == Direction.DOWN && slotIndex == 1) {
            return itemStack.m_150930_(Items.f_42447_) || itemStack.m_150930_(Items.f_42446_);
        }
        return true;
    }

    public boolean m_7013_(int slotIndex, ItemStack itemStack) {
        if (slotIndex == 2) {
            return false;
        }
        if (slotIndex == 1) {
            ItemStack itemstack = this.m_8020_(1);
            if (0 < ForgeHooks.getBurnTime((ItemStack)itemStack, this.recipeType)) {
                return true;
            }
            return itemStack.m_150930_(Items.f_42446_) && !itemstack.m_150930_(Items.f_42446_);
        }
        return true;
    }

    @Override
    public void m_6836_(int slotIndex, ItemStack itemStack) {
        ItemStack currentStack = this.m_8020_(slotIndex);
        boolean flag = !itemStack.m_41619_() && ItemStack.m_150942_((ItemStack)currentStack, (ItemStack)itemStack);
        super.m_6836_(slotIndex, itemStack);
        if (itemStack.m_41613_() > this.m_6893_()) {
            itemStack.m_41764_(this.m_6893_());
        }
        if (slotIndex == 0 && !flag) {
            this.cookingTotalTime = AbstractFurnaceCompartmentEntity.getTotalCookTime(this.m_9236_(), this);
            this.cookingProgress = 0;
            this.m_6596_();
        }
    }

    public int getCookTime() {
        return this.cookingProgress;
    }

    public int getTotalCookTime() {
        return this.cookingTotalTime;
    }

    public boolean isLit() {
        return this.litTime > 0;
    }

    @Override
    public double getBuoyancy() {
        return -0.03;
    }

    @Override
    public int getCompartmentBlockLight() {
        return (Boolean)this.getDisplayBlockState().m_61143_((Property)BlockStateProperties.f_61443_) != false ? 13 : 0;
    }

    @Override
    public BlockState getDisplayBlockState() {
        return (BlockState)this.f_19804_.m_135370_(DATA_ID_DISPLAY_BLOCK);
    }

    @Override
    public void setDisplayBlockState(BlockState blockState) {
        this.f_19804_.m_135381_(DATA_ID_DISPLAY_BLOCK, (Object)blockState);
    }

    @Override
    protected void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.loadCommonNBTData(compoundTag);
        BlockCompartment.readBlockstate(this, compoundTag);
    }

    @Override
    protected void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        this.saveCommonNBTData(compoundTag);
        BlockCompartment.saveBlockstate(this, compoundTag);
    }

    @Override
    public void loadFromStackNBT(CompoundTag compoundTag) {
        super.loadFromStackNBT(compoundTag);
        this.loadCommonNBTData(compoundTag);
    }

    @Override
    public CompoundTag saveForItemStack() {
        CompoundTag compoundTag = super.saveForItemStack();
        this.saveCommonNBTData(compoundTag);
        return compoundTag;
    }

    private void loadCommonNBTData(CompoundTag compoundTag) {
        if (compoundTag.m_128425_(BURN_TIME_KEY, 3)) {
            this.litTime = compoundTag.m_128451_(BURN_TIME_KEY);
        }
        if (compoundTag.m_128425_(COOK_TIME_KEY, 3)) {
            this.cookingProgress = compoundTag.m_128451_(COOK_TIME_KEY);
        }
        if (compoundTag.m_128425_(COOK_TIME_TOTAL_KEY, 3)) {
            this.cookingTotalTime = compoundTag.m_128451_(COOK_TIME_TOTAL_KEY);
        }
        this.litDuration = this.getBurnDuration(this.m_8020_(1));
        if (compoundTag.m_128425_(RECIPES_USED_KEY, 10)) {
            CompoundTag compoundtag = compoundTag.m_128469_(RECIPES_USED_KEY);
            for (String recipeKey : compoundtag.m_128431_()) {
                this.recipesUsed.put((Object)new ResourceLocation(recipeKey), compoundtag.m_128451_(recipeKey));
            }
        }
    }

    private void saveCommonNBTData(CompoundTag compoundTag) {
        compoundTag.m_128405_(BURN_TIME_KEY, this.litTime);
        compoundTag.m_128405_(COOK_TIME_KEY, this.cookingProgress);
        compoundTag.m_128405_(COOK_TIME_TOTAL_KEY, this.cookingTotalTime);
        CompoundTag compoundtag = new CompoundTag();
        this.recipesUsed.forEach((recipeKey, integer) -> compoundtag.m_128405_(recipeKey.toString(), integer.intValue()));
        compoundTag.m_128365_(RECIPES_USED_KEY, (Tag)compoundtag);
    }

    @Override
    public ItemStack getDropStack() {
        return new ItemStack((ItemLike)this.getDisplayBlockState().m_60734_());
    }

    @Override
    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)this.getDisplayBlockState().m_60734_());
    }

    protected abstract void animateTick();

    protected abstract AbstractFurnaceMenu createMenu(int var1, Inventory var2);

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.m_6084_() || facing == null || capability != ForgeCapabilities.ITEM_HANDLER) {
            return super.getCapability(capability, facing);
        }
        if (facing == Direction.UP) {
            return this.directionalHandlers[0].cast();
        }
        if (facing == Direction.DOWN) {
            return this.directionalHandlers[1].cast();
        }
        return this.directionalHandlers[2].cast();
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        Arrays.stream(this.directionalHandlers).forEach(LazyOptional::invalidate);
    }

    @Override
    public void reviveCaps() {
        super.reviveCaps();
        this.directionalHandlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    }
}

