/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.baguettelib.mixin;

import com.leclowndu93150.baguettelib.event.inventory.InventoryUpdateEvent;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class}, priority=727)
public class ItemEntityPickupMixin {
    @Inject(method={"playerTouch"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Inventory;add(Lnet/minecraft/world/item/ItemStack;)Z")})
    private void onPlayerTouch(Player player, CallbackInfo ci) {
        ItemEntity self = (ItemEntity)this;
        if (!self.m_9236_().f_46443_) {
            ItemStack newStack;
            ItemStack itemStack = self.m_32055_();
            if (itemStack.m_41619_()) {
                return;
            }
            if (self.m_32063_() || self.f_265881_ != null && !self.f_265881_.equals(player.m_20148_())) {
                return;
            }
            int targetSlot = this.findTargetSlot(player, itemStack);
            if (targetSlot == -1) {
                return;
            }
            ItemStack oldStack = player.m_150109_().m_8020_(targetSlot);
            ItemStack itemStack2 = newStack = oldStack.m_41619_() ? itemStack.m_41777_() : oldStack.m_41777_();
            if (!oldStack.m_41619_() && ItemStack.m_41656_((ItemStack)oldStack, (ItemStack)itemStack)) {
                int transferAmount = Math.min(itemStack.m_41613_(), oldStack.m_41741_() - oldStack.m_41613_());
                newStack.m_41764_(oldStack.m_41613_() + transferAmount);
            } else {
                newStack = itemStack.m_41777_();
            }
            if (targetSlot >= 0 && targetSlot < 9) {
                MinecraftForge.EVENT_BUS.post((Event)new InventoryUpdateEvent.Hotbar(player, targetSlot, oldStack, newStack));
            } else if (targetSlot >= 9 && targetSlot < 36) {
                MinecraftForge.EVENT_BUS.post((Event)new InventoryUpdateEvent.MainInventory(player, targetSlot, oldStack, newStack));
            } else if (targetSlot == 40) {
                MinecraftForge.EVENT_BUS.post((Event)new InventoryUpdateEvent.Offhand(player, targetSlot, oldStack, newStack));
            }
            MinecraftForge.EVENT_BUS.post((Event)new InventoryUpdateEvent.All(player, targetSlot, oldStack, newStack));
        }
    }

    private int findTargetSlot(Player player, ItemStack itemStack) {
        int i;
        Inventory inventory = player.m_150109_();
        for (i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack existing = inventory.m_8020_(i);
            if (existing.m_41619_() || !ItemStack.m_41656_((ItemStack)existing, (ItemStack)itemStack) || existing.m_41613_() >= existing.m_41741_()) continue;
            return i;
        }
        for (i = 0; i < inventory.m_6643_(); ++i) {
            if (!inventory.m_8020_(i).m_41619_()) continue;
            return i;
        }
        return -1;
    }
}

