/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class BjornLib {
    public static final String MOD_ID = "bjornlib";
    public static final Logger LOGGER = LogUtils.getLogger();

    public static void init() {
    }

    public static <T> T findService(Class<T> clazz, @Nullable Supplier<T> defaultImpl) {
        List<ServiceLoader.Provider<T>> providers = ServiceLoader.load(clazz).stream().toList();
        if (providers.isEmpty() && defaultImpl != null) {
            return defaultImpl.get();
        }
        if (providers.size() != 1) {
            String names = providers.stream().map(p -> p.type().getName()).collect(Collectors.joining(",", "[", "]"));
            String msg = "There should be exactly one implementation of %s on the classpath. Found: %s".formatted(clazz.getName(), names);
            throw new IllegalStateException(msg);
        }
        ServiceLoader.Provider<T> provider = providers.get(0);
        LOGGER.debug("Instantiating {} for service {}", (Object)provider.type().getName(), (Object)clazz.getName());
        return provider.get();
    }
}

