/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.registry;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class ItemRegistry {
    private static final Map<ResourceLocation, Item> ALL = new LinkedHashMap<ResourceLocation, Item>();

    public static void registerItems(BiConsumer<Item, ResourceLocation> r) {
        for (Map.Entry<ResourceLocation, Item> e : ALL.entrySet()) {
            r.accept(e.getValue(), e.getKey());
        }
    }

    private static <T extends Item> T item(ResourceLocation id, T item) {
        Item old = ALL.put(id, item);
        if (old != null) {
            throw new IllegalArgumentException("Duplicate id " + id);
        }
        return item;
    }
}

