/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.client.renderer.texture.atlas;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.blueprint.client.renderer.texture.atlas.BlueprintSpriteSources;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceType;
import net.minecraft.client.renderer.texture.atlas.SpriteSources;
import net.minecraft.client.renderer.texture.atlas.sources.LazyLoadedImage;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FastColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;

public class BlueprintPalettedPermutations
implements SpriteSource {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<BlueprintPalettedPermutations> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.mapEither((MapCodec)Codec.list((Codec)SpriteSources.f_260500_).fieldOf("sources"), (MapCodec)Codec.list((Codec)ResourceLocation.f_135803_).fieldOf("textures")).forGetter(permutations -> permutations.sourcesOrTextures), (App)ResourceLocation.f_135803_.fieldOf("palette_key").forGetter(permutations -> permutations.paletteKey), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)ResourceLocation.f_135803_).fieldOf("permutations").forGetter(permutations -> permutations.permutations)).apply((Applicative)instance, BlueprintPalettedPermutations::new));
    private final Either<List<SpriteSource>, List<ResourceLocation>> sourcesOrTextures;
    private final Map<String, ResourceLocation> permutations;
    private final ResourceLocation paletteKey;

    public BlueprintPalettedPermutations(Either<List<SpriteSource>, List<ResourceLocation>> sourcesOrTextures, ResourceLocation p_266681_, Map<String, ResourceLocation> p_266741_) {
        this.sourcesOrTextures = sourcesOrTextures;
        this.permutations = p_266741_;
        this.paletteKey = p_266681_;
    }

    public void m_260891_(ResourceManager manager, SpriteSource.Output output) {
        Supplier supplier = Suppliers.memoize(() -> BlueprintPalettedPermutations.loadPaletteEntryFromImage(manager, this.paletteKey));
        HashMap map = new HashMap();
        this.permutations.forEach((arg_0, arg_1) -> BlueprintPalettedPermutations.lambda$run$6(map, (java.util.function.Supplier)supplier, manager, arg_0, arg_1));
        Iterator locationIterator = (Iterator)this.sourcesOrTextures.map(sources -> {
            final HashMap tempOutputMap = new HashMap();
            SpriteSource.Output tempOutput = new SpriteSource.Output(){

                public void m_260840_(ResourceLocation location, SpriteSource.SpriteSupplier spriteSupplier) {
                    SpriteSource.SpriteSupplier oldSupplier = tempOutputMap.put(location, spriteSupplier);
                    if (oldSupplier != null) {
                        oldSupplier.m_260986_();
                    }
                }

                public void m_260801_(Predicate<ResourceLocation> predicate) {
                    Iterator iterator = tempOutputMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        if (!predicate.test((ResourceLocation)entry.getKey())) continue;
                        ((SpriteSource.SpriteSupplier)entry.getValue()).m_260986_();
                        iterator.remove();
                    }
                }
            };
            for (SpriteSource source : sources) {
                source.m_260891_(manager, tempOutput);
            }
            return tempOutputMap.keySet().iterator();
        }, List::iterator);
        while (locationIterator.hasNext()) {
            ResourceLocation location = (ResourceLocation)locationIterator.next();
            ResourceLocation resourcelocation1 = f_266012_.m_245698_(location);
            Optional optional = manager.m_213713_(resourcelocation1);
            if (optional.isEmpty()) {
                LOGGER.warn("Unable to find texture {}", (Object)resourcelocation1);
                continue;
            }
            LazyLoadedImage lazyloadedimage = new LazyLoadedImage(resourcelocation1, (Resource)optional.get(), map.size());
            for (Map.Entry entry : map.entrySet()) {
                ResourceLocation resourcelocation2 = location.m_266382_("_" + (String)entry.getKey());
                output.m_260840_(resourcelocation2, (SpriteSource.SpriteSupplier)new PalettedSpriteSupplier(lazyloadedimage, (java.util.function.Supplier)entry.getValue(), resourcelocation2));
            }
        }
    }

    private static IntUnaryOperator createPaletteMapping(int[] p_266839_, int[] p_266776_) {
        if (p_266776_.length != p_266839_.length) {
            LOGGER.warn("Palette mapping has different sizes: {} and {}", (Object)p_266839_.length, (Object)p_266776_.length);
            throw new IllegalArgumentException();
        }
        Int2IntOpenHashMap int2intmap = new Int2IntOpenHashMap(p_266776_.length);
        for (int i = 0; i < p_266839_.length; ++i) {
            int j = p_266839_[i];
            if (FastColor.ABGR32.m_266503_((int)j) == 0) continue;
            int2intmap.put(FastColor.ABGR32.m_266533_((int)j), p_266776_[i]);
        }
        return arg_0 -> BlueprintPalettedPermutations.lambda$createPaletteMapping$8((Int2IntMap)int2intmap, arg_0);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static int[] loadPaletteEntryFromImage(ResourceManager p_267184_, ResourceLocation p_267059_) {
        Optional optional = p_267184_.m_213713_(f_266012_.m_245698_(p_267059_));
        if (optional.isEmpty()) {
            LOGGER.error("Failed to load palette image {}", (Object)p_267059_);
            throw new IllegalArgumentException();
        }
        try (InputStream inputstream = ((Resource)optional.get()).m_215507_();){
            int[] nArray;
            block15: {
                NativeImage nativeimage = NativeImage.m_85058_((InputStream)inputstream);
                try {
                    nArray = nativeimage.m_266370_();
                    if (nativeimage == null) break block15;
                }
                catch (Throwable throwable) {
                    if (nativeimage != null) {
                        try {
                            nativeimage.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                nativeimage.close();
            }
            return nArray;
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't load texture {}", (Object)p_267059_, (Object)exception);
            throw new IllegalArgumentException();
        }
    }

    public SpriteSourceType m_260850_() {
        return BlueprintSpriteSources.PALETTED_PERMUTATIONS;
    }

    private static /* synthetic */ int lambda$createPaletteMapping$8(Int2IntMap int2intmap, int p_267899_) {
        int k = FastColor.ABGR32.m_266503_((int)p_267899_);
        if (k == 0) {
            return p_267899_;
        }
        int l = FastColor.ABGR32.m_266533_((int)p_267899_);
        int i1 = int2intmap.getOrDefault(l, FastColor.ABGR32.m_267818_((int)l));
        int j1 = FastColor.ABGR32.m_266503_((int)i1);
        return FastColor.ABGR32.m_266498_((int)(k * j1 / 255), (int)i1);
    }

    private static /* synthetic */ void lambda$run$6(Map map, java.util.function.Supplier supplier, ResourceManager manager, String p_267108_, ResourceLocation p_266969_) {
        map.put(p_267108_, Suppliers.memoize(() -> BlueprintPalettedPermutations.lambda$run$5((java.util.function.Supplier)supplier, manager, p_266969_)));
    }

    private static /* synthetic */ IntUnaryOperator lambda$run$5(java.util.function.Supplier supplier, ResourceManager manager, ResourceLocation p_266969_) {
        return BlueprintPalettedPermutations.createPaletteMapping((int[])supplier.get(), BlueprintPalettedPermutations.loadPaletteEntryFromImage(manager, p_266969_));
    }

    @OnlyIn(value=Dist.CLIENT)
    private record PalettedSpriteSupplier(LazyLoadedImage baseImage, java.util.function.Supplier<IntUnaryOperator> palette, ResourceLocation permutationLocation) implements SpriteSource.SpriteSupplier
    {
        @Nullable
        public SpriteContents get() {
            try {
                NativeImage nativeimage = this.baseImage.m_266167_().m_266528_(this.palette.get());
                SpriteContents spriteContents = new SpriteContents(this.permutationLocation, new FrameSize(nativeimage.m_84982_(), nativeimage.m_85084_()), nativeimage, AnimationMetadataSection.f_119012_);
                return spriteContents;
            }
            catch (IOException | IllegalArgumentException ioexception) {
                LOGGER.error("unable to apply palette to {}", (Object)this.permutationLocation, (Object)ioexception);
            }
            finally {
                this.baseImage.m_266458_();
            }
            return null;
        }

        public void m_260986_() {
            this.baseImage.m_266458_();
        }
    }
}

