/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.entity;

import com.teamabnormals.blueprint.core.events.FallingBlockEvent;
import com.teamabnormals.blueprint.core.registry.BlueprintEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ConcretePowderBlock;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlueprintFallingBlockEntity
extends FallingBlockEntity
implements IEntityAdditionalSpawnData {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean dropsBlockLoot = true;
    private boolean allowsPlacing = true;

    public BlueprintFallingBlockEntity(EntityType<? extends FallingBlockEntity> type, Level level) {
        super(type, level);
    }

    public BlueprintFallingBlockEntity(Level level, double x, double y, double z, BlockState state) {
        this((EntityType<? extends FallingBlockEntity>)((EntityType)BlueprintEntityTypes.FALLING_BLOCK.get()), level);
        this.f_31946_ = state;
        this.f_19850_ = true;
        this.m_6034_(x, y, z);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
        this.m_31959_(this.m_20183_());
    }

    public BlueprintFallingBlockEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType<? extends FallingBlockEntity>)((EntityType)BlueprintEntityTypes.FALLING_BLOCK.get()), level);
    }

    public static BlueprintFallingBlockEntity fall(Level level, BlockPos pos, BlockState state) {
        BlueprintFallingBlockEntity fallingblockentity = new BlueprintFallingBlockEntity(level, (double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, state.m_61138_((Property)BlockStateProperties.f_61362_) ? (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)) : state);
        FallingBlockEntity fallingblockentity1 = FallingBlockEvent.onBlockFall(level, pos, state, fallingblockentity);
        if (fallingblockentity1 instanceof BlueprintFallingBlockEntity) {
            fallingblockentity = (BlueprintFallingBlockEntity)fallingblockentity1;
        }
        level.m_7731_(pos, state.m_60819_().m_76188_(), 3);
        level.m_7967_((Entity)fallingblockentity);
        return fallingblockentity;
    }

    public void m_8119_() {
        if (this.f_31946_.m_60795_()) {
            this.m_146870_();
        } else {
            Block block = this.f_31946_.m_60734_();
            ++this.f_31942_;
            if (!this.m_20068_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            if (FallingBlockEvent.onFallingBlockTick(this)) {
                return;
            }
            if (!this.m_9236_().f_46443_) {
                BlockHitResult blockhitresult;
                BlockPos blockpos = this.m_20183_();
                boolean flag = this.f_31946_.m_60734_() instanceof ConcretePowderBlock;
                boolean flag1 = flag && this.f_31946_.canBeHydrated((BlockGetter)this.m_9236_(), blockpos, this.m_9236_().m_6425_(blockpos), blockpos);
                double d0 = this.m_20184_().m_82556_();
                if (flag && d0 > 1.0 && (blockhitresult = this.m_9236_().m_45547_(new ClipContext(new Vec3(this.f_19854_, this.f_19855_, this.f_19856_), this.m_20182_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.SOURCE_ONLY, (Entity)this))).m_6662_() != HitResult.Type.MISS && this.f_31946_.canBeHydrated((BlockGetter)this.m_9236_(), blockpos, this.m_9236_().m_6425_(blockhitresult.m_82425_()), blockhitresult.m_82425_())) {
                    blockpos = blockhitresult.m_82425_();
                    flag1 = true;
                }
                if (!this.m_20096_() && !flag1) {
                    if (!(this.m_9236_().f_46443_ || (this.f_31942_ <= 100 || blockpos.m_123342_() > this.m_9236_().m_141937_() && blockpos.m_123342_() <= this.m_9236_().m_151558_()) && this.f_31942_ <= 600)) {
                        if (this.f_31943_ && this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                            this.spawnDrops();
                        }
                        this.m_146870_();
                    }
                } else {
                    BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                    this.m_20256_(this.m_20184_().m_82542_(0.7, -0.5, 0.7));
                    if (!blockstate.m_60713_(Blocks.f_50110_)) {
                        if (!this.f_31947_) {
                            boolean flag4;
                            boolean flag2 = blockstate.m_60629_((BlockPlaceContext)new DirectionalPlaceContext(this.m_9236_(), blockpos, Direction.DOWN, ItemStack.f_41583_, Direction.UP));
                            boolean flag3 = FallingBlock.m_53241_((BlockState)this.m_9236_().m_8055_(blockpos.m_7495_())) && (!flag || !flag1);
                            boolean bl = flag4 = this.f_31946_.m_60710_((LevelReader)this.m_9236_(), blockpos) && !flag3;
                            if (flag2 && flag4) {
                                if (this.f_31946_.m_61138_((Property)BlockStateProperties.f_61362_) && this.m_9236_().m_6425_(blockpos).m_76152_() == Fluids.f_76193_) {
                                    this.f_31946_ = (BlockState)this.f_31946_.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
                                }
                                if (this.allowsPlacing && this.m_9236_().m_7731_(blockpos, this.f_31946_, 3)) {
                                    BlockEntity blockentity;
                                    ((ServerLevel)this.m_9236_()).m_7726_().f_8325_.m_140201_((Entity)this, (Packet)new ClientboundBlockUpdatePacket(blockpos, this.m_9236_().m_8055_(blockpos)));
                                    this.m_146870_();
                                    if (block instanceof Fallable) {
                                        ((Fallable)block).m_48792_(this.m_9236_(), blockpos, this.f_31946_, blockstate, (FallingBlockEntity)this);
                                    }
                                    if (this.f_31944_ != null && this.f_31946_.m_155947_() && (blockentity = this.m_9236_().m_7702_(blockpos)) != null) {
                                        CompoundTag compoundtag = blockentity.m_187482_();
                                        for (String s : this.f_31944_.m_128431_()) {
                                            compoundtag.m_128365_(s, this.f_31944_.m_128423_(s).m_6426_());
                                        }
                                        try {
                                            blockentity.m_142466_(compoundtag);
                                        }
                                        catch (Exception exception) {
                                            LOGGER.error("Failed to load block entity from falling block", (Throwable)exception);
                                        }
                                        blockentity.m_6596_();
                                    }
                                } else if (this.f_31943_ && this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                                    this.m_146870_();
                                    this.m_149650_(block, blockpos);
                                    this.spawnDrops();
                                }
                            } else {
                                this.m_146870_();
                                if (this.f_31943_ && this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                                    this.m_149650_(block, blockpos);
                                    this.spawnDrops();
                                }
                            }
                        } else {
                            this.m_146870_();
                            this.m_149650_(block, blockpos);
                        }
                    }
                }
            }
            this.m_20256_(this.m_20184_().m_82490_(0.98));
        }
    }

    public void setDropsBlockLoot(boolean dropsLoot) {
        this.dropsBlockLoot = dropsLoot;
    }

    public void setAllowsPlacing(boolean allowsPlacing) {
        this.allowsPlacing = allowsPlacing;
    }

    public void setBlockState(BlockState state) {
        this.f_31946_ = state;
    }

    protected void spawnDrops() {
        if (this.dropsBlockLoot) {
            LootParams.Builder builder = new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_);
            this.f_31946_.m_287290_(builder).forEach(arg_0 -> ((BlueprintFallingBlockEntity)this).m_19983_(arg_0));
        } else {
            this.m_19998_((ItemLike)this.f_31946_.m_60734_());
        }
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("DropsBlockLoot", this.dropsBlockLoot);
        compound.m_128379_("AllowsPlacing", this.allowsPlacing);
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("DropsBlockLoot", 99)) {
            this.dropsBlockLoot = compound.m_128471_("DropsBlockLoot");
        }
        if (compound.m_128425_("AllowsPlacing", 99)) {
            this.allowsPlacing = compound.m_128471_("AllowsPlacing");
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeInt(Block.m_49956_((BlockState)this.f_31946_));
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.f_31946_ = Block.m_49803_((int)buffer.readInt());
    }
}

