/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.multiblock;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.multiblock.MultiblockPlacer;
import org.jetbrains.annotations.Nullable;

public class MultiblockBedBlock
extends MultiblockPlacer {
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    public static final BooleanProperty OCCUPIED = BlockStateProperties.f_61445_;
    public static final IntegerProperty MULTIBLOCK_PART = IntegerProperty.m_61631_((String)"part", (int)1, (int)6);
    private static final int[][][] MULTIBLOCK_SHAPE = new int[][][]{new int[][]{{1, 3, 5}, {2, 4, 6}}};

    public MultiblockBedBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)OCCUPIED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean isBed(BlockState state, BlockGetter level, BlockPos pos, @Nullable Entity player) {
        return true;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public Direction getBedDirection(BlockState state, LevelReader level, BlockPos pos) {
        return (Direction)state.m_61143_((Property)FACING);
    }

    public void setBedOccupied(BlockState state, Level level, BlockPos pos, LivingEntity sleeper, boolean occupied) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)OCCUPIED, (Comparable)Boolean.valueOf(occupied)), 2);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.f_46443_) {
            return InteractionResult.CONSUME;
        }
        int part = (Integer)pState.m_61143_((Property)MULTIBLOCK_PART);
        if (!(part != 3 && part != 4 || (pState = pLevel.m_8055_(pPos = pPos.m_121945_((Direction)pState.m_61143_((Property)FACING)))).m_60713_((Block)this))) {
            return InteractionResult.CONSUME;
        }
        if (!(part != 1 && part != 2 || (pState = pLevel.m_8055_(pPos = pPos.m_5484_((Direction)pState.m_61143_((Property)FACING), 2))).m_60713_((Block)this))) {
            return InteractionResult.CONSUME;
        }
        if (!MultiblockBedBlock.canSetSpawn(pLevel)) {
            pLevel.m_7471_(pPos, false);
            BlockPos removePos = pPos.m_121945_(((Direction)pState.m_61143_((Property)FACING)).m_122424_());
            if (pLevel.m_8055_(removePos).m_60713_((Block)this)) {
                pLevel.m_7471_(removePos, false);
            }
            Vec3 center = pPos.m_252807_();
            pLevel.m_254951_(null, pLevel.m_269111_().m_269488_(center), null, center, 5.0f, true, Level.ExplosionInteraction.BLOCK);
        } else {
            if (((Boolean)pState.m_61143_((Property)OCCUPIED)).booleanValue()) {
                pPlayer.m_5661_((Component)Component.m_237115_((String)"block.minecraft.bed.occupied"), true);
                return InteractionResult.SUCCESS;
            }
            pPlayer.m_7720_(pPos).ifLeft(sleepingProblem -> {
                if (sleepingProblem.m_36423_() != null) {
                    pPlayer.m_5661_(sleepingProblem.m_36423_(), true);
                }
            });
        }
        return InteractionResult.SUCCESS;
    }

    public static boolean canSetSpawn(Level pLevel) {
        return pLevel.m_6042_().f_63862_();
    }

    public void m_142072_(Level pLevel, BlockState pState, BlockPos pPos, Entity pEntity, float pFallDistance) {
        super.m_142072_(pLevel, pState, pPos, pEntity, pFallDistance * 0.5f);
    }

    public void m_5548_(BlockGetter pLevel, Entity pEntity) {
        if (pEntity.m_20162_()) {
            super.m_5548_(pLevel, pEntity);
        } else {
            this.bounceUp(pEntity);
        }
    }

    private void bounceUp(Entity pEntity) {
        Vec3 $$1 = pEntity.m_20184_();
        if ($$1.f_82480_ < 0.0) {
            double $$2 = pEntity instanceof LivingEntity ? 1.0 : 0.8;
            pEntity.m_20334_($$1.f_82479_, -$$1.f_82480_ * (double)0.66f * $$2, $$1.f_82481_);
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{OCCUPIED});
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    @Override
    public IntegerProperty getMultiblockPart() {
        return MULTIBLOCK_PART;
    }

    @Override
    public int[][][] getMultiblockShape() {
        return MULTIBLOCK_SHAPE;
    }
}

