/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.cgs.client.animators;

import com.nukateam.cgs.common.faundation.registry.items.CgsAttachments;
import com.nukateam.ntgl.client.animators.WeaponAnimator;
import com.nukateam.ntgl.client.render.renderers.weapon.DynamicWeaponRenderer;
import com.nukateam.ntgl.common.data.holders.AttachmentType;
import com.nukateam.ntgl.common.util.util.WeaponStateHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;

public class FlintlockAnimator
extends WeaponAnimator {
    public static final String EMPTY = "empty";
    public static final String ONE_HAND = "_one_hand";
    public static final String SHOT_MULTI = "shot_multi";
    public static final String RELOAD_MULTI = "reload_multi";
    private boolean hasAmmo;
    private boolean hasMagazine;

    public FlintlockAnimator(ItemDisplayContext transformType, DynamicWeaponRenderer<WeaponAnimator> renderer) {
        super(transformType, renderer);
    }

    protected RawAnimation getHoldAnimation(AnimationState<WeaponAnimator> event) {
        if (!this.hasAmmo) {
            return this.playGunAnim(EMPTY, Animation.LoopType.LOOP);
        }
        return super.getHoldAnimation(event);
    }

    protected void tickStart() {
        super.tickStart();
        this.hasAmmo = WeaponStateHelper.hasAmmo((ItemStack)this.getStack());
        this.hasMagazine = this.hasRevolvingChambersEquiped();
    }

    protected RawAnimation getShootingAnimation(AnimationState<WeaponAnimator> event) {
        if (this.hasMagazine) {
            this.animationHelper.syncAnimation(event, this.rate, new String[]{SHOT_MULTI});
            return this.playGunAnim(SHOT_MULTI, Animation.LoopType.LOOP);
        }
        return super.getShootingAnimation(event);
    }

    protected RawAnimation getDefaultReloadAnimation(AnimationState<WeaponAnimator> event) {
        if (this.hasMagazine) {
            this.animationHelper.syncAnimation(event, this.reloadTime, new String[]{RELOAD_MULTI});
            return this.playGunAnim(RELOAD_MULTI, Animation.LoopType.LOOP);
        }
        return super.getDefaultReloadAnimation(event);
    }

    protected String getGunAnim(String name) {
        LivingEntity entity = this.getEntity();
        ItemStack currentItem = entity.m_21120_(this.arm);
        boolean isOneHanded = this.isOneHanded(currentItem);
        return isOneHanded && this.animationHelper.hasAnimation(name + ONE_HAND) ? name + ONE_HAND : name;
    }

    private boolean hasRevolvingChambersEquiped() {
        return WeaponStateHelper.getAttachmentItem((AttachmentType)AttachmentType.MAGAZINE, (ItemStack)this.getStack()).m_41720_() == CgsAttachments.REVOLVING_CHAMBERS.get();
    }
}

