/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.cgs.client.animators;

import com.nukateam.cgs.common.faundation.registry.items.CgsAttachments;
import com.nukateam.cgs.common.utils.GunUtils;
import com.nukateam.ntgl.client.animators.WeaponAnimator;
import com.nukateam.ntgl.client.render.renderers.weapon.DynamicWeaponRenderer;
import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.data.holders.AttachmentType;
import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import com.nukateam.ntgl.common.util.util.Cycler;
import com.nukateam.ntgl.common.util.util.WeaponModifierHelper;
import com.nukateam.ntgl.common.util.util.WeaponStateHelper;
import java.util.ArrayList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;

public class ShotgunAnimator
extends WeaponAnimator {
    public static final String SHOT_DRUM = "shot_drum";
    public static final String SHOT_PUMP = "shot_pump";
    public static final String RELOAD_DRUM = "reload_drum";
    public static final String RELOAD_PUMP_LEFT = "reload_pump_left";
    public static final String RELOAD_PUMP_RIGHT = "reload_pump_right";
    public static final String RELOAD_PUMP_START = "reload_pump_start";
    public static final String RELOAD_PUMP_END = "reload_pump_end";
    public static final String EMPTY_BOTH = "empty_both";
    public static final String FULL = "full";
    public static final String EMPTY_LEFT = "empty_left";
    public static final String SHOT_LEFT = "shot_left";
    public static final String SHOT_RIGHT = "shot_right";
    public static final String WAIT = "wait";
    public static final int SHOT_TIME = 2;
    protected final AnimationController<WeaponAnimator> COCK_CONTROLLER;
    protected final AnimationController<WeaponAnimator> FLASH_CONTROLLER;
    private int ammo;
    private boolean hasDrums;
    private boolean hasPumps;
    private Cycler cockCycler = new Cycler(1, 2);
    private boolean isAmmoEven;
    private int cockInfo;

    public ShotgunAnimator(ItemDisplayContext transformType, DynamicWeaponRenderer<WeaponAnimator> renderer) {
        super(transformType, renderer);
        this.COCK_CONTROLLER = this.createController("cock_controller", this.animateCock());
        this.FLASH_CONTROLLER = this.createController("flash_controller", this.animateFlash());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        super.registerControllers(controllerRegistrar);
        controllerRegistrar.add(new AnimationController[]{this.COCK_CONTROLLER});
        controllerRegistrar.add(new AnimationController[]{this.FLASH_CONTROLLER});
    }

    protected void tickStart() {
        super.tickStart();
        if (!this.isGun()) {
            return;
        }
        ItemStack magazine = WeaponStateHelper.getAttachmentItem((AttachmentType)AttachmentType.MAGAZINE, (ItemStack)this.getStack());
        WeaponData data = this.getGunData();
        this.ammo = WeaponStateHelper.getAmmoCount((WeaponData)data);
        this.hasDrums = magazine.m_150930_((Item)CgsAttachments.SHOTGUN_DRUM.get());
        this.hasPumps = magazine.m_150930_((Item)CgsAttachments.SHOTGUN_PUMP.get());
        this.isAmmoEven = GunUtils.isAmmoEven(data);
        this.cockInfo = GunUtils.getCock(this.getStack());
        int cooldown = this.shootingHandler.getCooldown(this.getEntity(), this.arm);
        if (this.cockCycler == null) {
            this.cockCycler = new Cycler(1, 2);
        }
        if (cooldown == this.rate) {
            this.cockCycler.cycle();
        }
    }

    protected RawAnimation getShootingAnimation(AnimationState<WeaponAnimator> event) {
        RawAnimation animation = RawAnimation.begin();
        ArrayList<String> animations = new ArrayList<String>();
        String shotAnim = this.getGunAnim("shot");
        animation.then(shotAnim, Animation.LoopType.PLAY_ONCE);
        animations.add(shotAnim);
        if ((this.hasDrums || this.hasPumps) && this.isAmmoEven && this.ammo > 0) {
            String reloadAnim = this.hasDrums ? this.getGunAnim(SHOT_DRUM) : this.getGunAnim(SHOT_PUMP);
            animation.then(reloadAnim, Animation.LoopType.PLAY_ONCE);
            animations.add(reloadAnim);
        }
        if (this.isAmmoEven) {
            this.rate = 20;
        }
        animation.then(this.getGunAnim("hold"), Animation.LoopType.LOOP);
        this.animationHelper.syncAnimation(event, this.rate, animations);
        return animation;
    }

    protected RawAnimation getStartReloadAnimation(AnimationState<WeaponAnimator> event) {
        if (this.hasPumps) {
            WeaponData data = this.getGunData();
            int time = WeaponModifierHelper.getReloadStart((WeaponData)data);
            this.animationHelper.syncAnimation(event, RELOAD_PUMP_START, time);
            return RawAnimation.begin().then(RELOAD_PUMP_START, Animation.LoopType.PLAY_ONCE);
        }
        return super.getStartReloadAnimation(event);
    }

    protected RawAnimation getDefaultReloadAnimation(AnimationState<WeaponAnimator> event) {
        WeaponData data = this.getGunData();
        int reloadTime = WeaponModifierHelper.getReloadTime((WeaponData)data);
        if (this.hasDrums) {
            this.animationHelper.syncAnimation(event, reloadTime, new String[]{RELOAD_DRUM, SHOT_DRUM});
            return RawAnimation.begin().then(RELOAD_DRUM, Animation.LoopType.PLAY_ONCE).then(SHOT_DRUM, Animation.LoopType.LOOP);
        }
        if (this.hasPumps) {
            boolean lessThenHalf = this.ammo <= WeaponModifierHelper.getMaxAmmo((WeaponData)data) / 2;
            String name = lessThenHalf ? RELOAD_PUMP_LEFT : RELOAD_PUMP_RIGHT;
            this.animationHelper.syncAnimation(event, name, reloadTime);
            return RawAnimation.begin().then(name, Animation.LoopType.LOOP);
        }
        return super.getDefaultReloadAnimation(event);
    }

    protected RawAnimation getEndReloadAnimation(AnimationState<WeaponAnimator> event) {
        if (this.hasPumps) {
            WeaponData data = this.getGunData();
            int time = WeaponModifierHelper.getReloadEnd((WeaponData)data);
            this.animationHelper.syncAnimation(event, time, new String[]{RELOAD_PUMP_END, SHOT_PUMP});
            return RawAnimation.begin().then(RELOAD_PUMP_END, Animation.LoopType.PLAY_ONCE).then(SHOT_PUMP, Animation.LoopType.PLAY_ONCE).then("hold", Animation.LoopType.LOOP);
        }
        return super.getEndReloadAnimation(event);
    }

    @NotNull
    protected WeaponData getGunData() {
        return new WeaponData(this.getStack(), this.getEntity());
    }

    private AnimationController.AnimationStateHandler<WeaponAnimator> animateCock() {
        return event -> {
            String name = "";
            switch (this.cockInfo) {
                case 0: {
                    name = EMPTY_BOTH;
                    break;
                }
                case 1: {
                    name = EMPTY_LEFT;
                    break;
                }
                case 2: {
                    name = FULL;
                }
            }
            RawAnimation animation = RawAnimation.begin().then(name, Animation.LoopType.LOOP);
            this.animationHelper.syncAnimation(event, name, 2);
            return event.setAndContinue(animation);
        };
    }

    private AnimationController.AnimationStateHandler<WeaponAnimator> animateFlash() {
        return event -> {
            boolean sas;
            int cooldown = this.shootingHandler.getCooldown(this.getEntity(), this.arm);
            boolean isShooting = this.rate <= cooldown;
            boolean bl = sas = cooldown > 0;
            if (this.shootingHandler.isShooting(this.getEntity(), this.arm)) {
                return event.setAndContinue(RawAnimation.begin().then(SHOT_LEFT, Animation.LoopType.PLAY_ONCE).then(WAIT, Animation.LoopType.LOOP));
            }
            return event.setAndContinue(RawAnimation.begin().then(WAIT, Animation.LoopType.LOOP));
        };
    }

    private boolean isGun() {
        return this.getStack().m_41720_() instanceof WeaponItem;
    }
}

