/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.content.blocks.foundry_basin;

import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import fr.lucreeper74.createmetallurgy.content.blocks.foundry_basin.FoundryBasinBlockEntity;
import java.util.Collections;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class FoundryBasinRecipe
extends ProcessingRecipe<SmartInventory> {
    public static boolean match(FoundryBasinBlockEntity basin, Recipe<?> recipe) {
        FoundryBasinRecipe basinRecipe;
        FilteringBehaviour filter = basin.getFilter();
        if (filter == null) {
            return false;
        }
        boolean filterTest = filter.test(recipe.m_8043_(basin.m_58904_().m_9598_()));
        if (recipe instanceof FoundryBasinRecipe && (basinRecipe = (FoundryBasinRecipe)recipe).getRollableResults().isEmpty() && !basinRecipe.getFluidResults().isEmpty()) {
            filterTest = filter.test((FluidStack)basinRecipe.getFluidResults().get(0));
        }
        if (!filterTest) {
            return false;
        }
        return FoundryBasinRecipe.apply(basin, recipe, true);
    }

    public static boolean apply(FoundryBasinBlockEntity basin, Recipe<?> recipe) {
        return FoundryBasinRecipe.apply(basin, recipe, false);
    }

    private static boolean apply(FoundryBasinBlockEntity basin, Recipe<?> recipe, boolean test) {
        boolean isBasinRecipe = recipe instanceof FoundryBasinRecipe;
        IItemHandler availableItems = (IItemHandler)basin.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        IFluidHandler availableFluids = (IFluidHandler)basin.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
        if (availableItems == null || availableFluids == null) {
            return false;
        }
        BlazeBurnerBlock.HeatLevel heat = BasinBlockEntity.getHeatLevelOf((BlockState)basin.m_58904_().m_8055_(basin.m_58899_().m_6625_(1)));
        if (isBasinRecipe && !((FoundryBasinRecipe)recipe).getRequiredHeat().testBlazeBurner(heat)) {
            return false;
        }
        LinkedList ingredients = new LinkedList(recipe.m_7527_());
        NonNullList fluidIngredients = isBasinRecipe ? ((FoundryBasinRecipe)recipe).getFluidIngredients() : Collections.emptyList();
        for (boolean simulate : Iterate.trueAndFalse) {
            Object ingredient2;
            if (!simulate && test) {
                return true;
            }
            int[] extractedItemsFromSlot = new int[availableItems.getSlots()];
            int[] extractedFluidsFromTank = new int[availableFluids.getTanks()];
            block1: for (Object ingredient2 : ingredients) {
                for (int slot = 0; slot < availableItems.getSlots(); ++slot) {
                    ItemStack extracted;
                    if (simulate && availableItems.getStackInSlot(slot).m_41613_() <= extractedItemsFromSlot[slot] || !ingredient2.test(extracted = availableItems.extractItem(slot, 1, true))) continue;
                    if (!simulate) {
                        availableItems.extractItem(slot, 1, false);
                    }
                    int n = slot;
                    extractedItemsFromSlot[n] = extractedItemsFromSlot[n] + 1;
                    continue block1;
                }
                return false;
            }
            boolean fluidsAffected = false;
            ingredient2 = fluidIngredients.iterator();
            block3: while (ingredient2.hasNext()) {
                FluidIngredient fluidIngredient = (FluidIngredient)ingredient2.next();
                int amountRequired = fluidIngredient.getRequiredAmount();
                for (int tank = 0; tank < availableFluids.getTanks(); ++tank) {
                    FluidStack fluidStack = availableFluids.getFluidInTank(tank);
                    if (simulate && fluidStack.getAmount() <= extractedFluidsFromTank[tank] || !fluidIngredient.test(fluidStack)) continue;
                    int drainedAmount = Math.min(amountRequired, fluidStack.getAmount());
                    if (!simulate) {
                        fluidStack.shrink(drainedAmount);
                        fluidsAffected = true;
                    }
                    if ((amountRequired -= drainedAmount) != 0) continue;
                    int n = tank;
                    extractedFluidsFromTank[n] = extractedFluidsFromTank[n] + drainedAmount;
                    continue block3;
                }
                return false;
            }
            if (fluidsAffected) {
                ((SmartFluidTankBehaviour)basin.getBehaviour(SmartFluidTankBehaviour.INPUT)).forEach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
                ((SmartFluidTankBehaviour)basin.getBehaviour(SmartFluidTankBehaviour.OUTPUT)).forEach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
            }
            if (!(recipe instanceof FoundryBasinRecipe)) continue;
            FoundryBasinRecipe basinRecipe = (FoundryBasinRecipe)recipe;
            if (!ItemHandlerHelper.insertItemStacked((IItemHandler)basin.getOutputInventory(), (ItemStack)basinRecipe.m_8043_(basin.m_58904_().m_9598_()).m_41777_(), (boolean)simulate).m_41619_()) {
                return false;
            }
            SmartInventory outputInv = basin.getOutputInventory();
            outputInv.allowInsertion();
            for (ItemStack output : basinRecipe.rollResults()) {
                if (ItemHandlerHelper.insertItemStacked((IItemHandler)outputInv, (ItemStack)output.m_41777_(), (boolean)simulate).m_41619_()) continue;
                return false;
            }
            outputInv.forbidInsertion();
            IFluidHandler targetTank = (IFluidHandler)basin.getOutputTank().getCapability().orElse(null);
            for (FluidStack fluidResult : basinRecipe.getFluidResults()) {
                IFluidHandler.FluidAction action = simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE;
                int fill = targetTank instanceof SmartFluidTankBehaviour.InternalFluidHandler ? ((SmartFluidTankBehaviour.InternalFluidHandler)targetTank).forceFill(fluidResult.copy(), action) : targetTank.fill(fluidResult.copy(), action);
                if (fill == fluidResult.getAmount()) continue;
                return false;
            }
        }
        return true;
    }

    protected FoundryBasinRecipe(IRecipeTypeInfo type, ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super(type, params);
    }

    protected int getMaxInputCount() {
        return 3;
    }

    protected int getMaxOutputCount() {
        return 4;
    }

    protected int getMaxFluidInputCount() {
        return 4;
    }

    protected int getMaxFluidOutputCount() {
        return 2;
    }

    protected boolean canRequireHeat() {
        return true;
    }

    protected boolean canSpecifyDuration() {
        return true;
    }

    public boolean matches(SmartInventory inv, @Nonnull Level worldIn) {
        return false;
    }
}

