/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.dawnoftime.dawnoftime.block.general.FireplaceBlock;
import org.dawnoftime.dawnoftime.block.templates.ChimneyBlockDoT;
import org.dawnoftime.dawnoftime.block.templates.ConnectedVerticalBlock;
import org.dawnoftime.dawnoftime.block.templates.ConnectedVerticalSidedBlock;
import org.dawnoftime.dawnoftime.block.templates.ConnectedVerticalSidedPlanBlock;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedBlock;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;
import org.dawnoftime.dawnoftime.util.Utils;
import org.dawnoftime.dawnoftime.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class ConnectedVerticalSidedPlanFireplaceBlock
extends ConnectedVerticalSidedPlanBlock {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;

    public ConnectedVerticalSidedPlanFireplaceBlock(BlockBehaviour.Properties properties) {
        super(properties, VoxelShapes.MULTIBLOCK_FIREPLACE_SHAPES);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LIT});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int index = state.m_61143_(ConnectedVerticalBlock.VERTICAL_CONNECTION) == BlockStatePropertiesAA.VerticalConnection.NONE ? 0 : 1;
        return index + ((Direction)state.m_61143_((Property)ConnectedVerticalSidedBlock.FACING)).m_122416_() * 2;
    }

    @Override
    public InteractionResult m_6227_(BlockState stateIn, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player.m_21205_() != null && player.m_21205_().m_41720_() instanceof BlockItem && ((BlockItem)player.m_21205_().m_41720_()).m_40614_() instanceof ConnectedVerticalSidedPlanFireplaceBlock) {
            return InteractionResult.PASS;
        }
        if (stateIn.m_61143_(ConnectedVerticalBlock.VERTICAL_CONNECTION) != BlockStatePropertiesAA.VerticalConnection.BOTH && stateIn.m_61143_(ConnectedVerticalBlock.VERTICAL_CONNECTION) != BlockStatePropertiesAA.VerticalConnection.UNDER) {
            int activation = Utils.changeBlockLitStateWithItemOrCreativePlayer(stateIn, worldIn, pos, player, handIn);
            if (activation >= 0) {
                Direction direction = (Direction)stateIn.m_61143_((Property)ConnectedVerticalSidedBlock.FACING);
                worldIn.m_8055_(pos.m_121945_(direction.m_122428_())).m_60690_(worldIn, pos.m_121945_(direction.m_122428_()), (Block)this, pos, false);
                worldIn.m_8055_(pos.m_121945_(direction.m_122427_())).m_60690_(worldIn, pos.m_121945_(direction.m_122427_()), stateIn.m_60734_(), pos, false);
                ConnectedVerticalSidedPlanFireplaceBlock.updateChimneys(activation == 1, stateIn, pos, worldIn);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public void m_5581_(Level worldIn, BlockState state, BlockHitResult hit, Projectile projectile) {
        int activation = -1;
        if (!((Boolean)state.m_61143_((Property)WaterloggedBlock.WATERLOGGED)).booleanValue() && !((Boolean)state.m_61143_((Property)FireplaceBlock.LIT)).booleanValue()) {
            if (projectile instanceof AbstractArrow) {
                activation = 1;
            }
        } else if (((Boolean)state.m_61143_((Property)FireplaceBlock.LIT)).booleanValue() && (projectile instanceof Snowball || projectile instanceof ThrowableProjectile && PotionUtils.m_43579_((ItemStack)((ThrowableItemProjectile)projectile).m_7846_()).m_43488_().size() <= 0)) {
            activation = 0;
        }
        if (activation >= 0) {
            boolean isActivated;
            BlockPos pos = hit.m_82425_();
            boolean bl = isActivated = activation == 1;
            if (!worldIn.m_5776_()) {
                state = (BlockState)state.m_61124_((Property)FireplaceBlock.LIT, (Comparable)Boolean.valueOf(isActivated));
                worldIn.m_7731_(pos, state, 10);
                worldIn.m_5594_(null, pos, isActivated ? SoundEvents.f_11936_ : SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (!isActivated && worldIn.m_5776_()) {
                for (int i = 0; i < worldIn.f_46441_.m_188503_(1) + 1; ++i) {
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123796_, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), (double)(worldIn.f_46441_.m_188501_() / 4.0f), 2.5E-5, (double)(worldIn.f_46441_.m_188501_() / 4.0f));
                }
            }
            ConnectedVerticalSidedPlanFireplaceBlock.updateChimneys(isActivated, state, pos, worldIn);
            Direction direction = (Direction)state.m_61143_((Property)ConnectedVerticalSidedBlock.FACING);
            worldIn.m_8055_(pos.m_121945_(direction.m_122427_())).m_60690_(worldIn, pos.m_121945_(direction.m_122427_()), (Block)this, pos, false);
            worldIn.m_8055_(pos.m_121945_(direction.m_122428_())).m_60690_(worldIn, pos.m_121945_(direction.m_122428_()), (Block)this, pos, false);
        }
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockState newState;
        if (state.m_61143_(ConnectedVerticalBlock.VERTICAL_CONNECTION) != BlockStatePropertiesAA.VerticalConnection.BOTH && state.m_61143_(ConnectedVerticalBlock.VERTICAL_CONNECTION) != BlockStatePropertiesAA.VerticalConnection.UNDER && (newState = worldIn.m_8055_(fromPos)).m_60734_() == this) {
            Direction facing = (Direction)state.m_61143_((Property)ConnectedVerticalSidedBlock.FACING);
            if (newState.m_61143_((Property)ConnectedVerticalSidedBlock.FACING) == facing) {
                if ((facing.equals((Object)Direction.NORTH) || facing.equals((Object)Direction.SOUTH)) && fromPos.m_123343_() != pos.m_123343_()) {
                    return;
                }
                if ((facing.equals((Object)Direction.EAST) || facing.equals((Object)Direction.WEST)) && fromPos.m_123341_() != pos.m_123341_()) {
                    return;
                }
                boolean burning = (Boolean)newState.m_61143_((Property)LIT);
                if (burning != (Boolean)state.m_61143_((Property)LIT)) {
                    if (((Boolean)newState.m_61143_((Property)LIT)).booleanValue() && ((Boolean)state.m_61143_((Property)WaterloggedBlock.WATERLOGGED)).booleanValue()) {
                        return;
                    }
                    worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(burning)), 10);
                    BlockPos newPos = pos.m_121945_(facing.m_122427_()).equals((Object)fromPos) ? pos.m_121945_(facing.m_122428_()) : pos.m_121945_(facing.m_122427_());
                    worldIn.m_8055_(newPos).m_60690_(worldIn, newPos, (Block)this, pos, false);
                }
            }
        }
    }

    public static void updateChimneys(boolean isActivatedIn, BlockState blockStateIn, BlockPos posIn, Level worldIn) {
        BlockPos pos = posIn;
        BlockState blockState = null;
        while ((blockState = worldIn.m_8055_(pos)) != null && blockState.m_60734_() instanceof ConnectedVerticalSidedPlanFireplaceBlock) {
            pos = pos.m_7494_();
        }
        pos = pos.m_7495_();
        ConnectedVerticalSidedPlanFireplaceBlock.updateChimneyConductsAtSide(isActivatedIn, pos.m_7494_(), worldIn);
        ConnectedVerticalSidedPlanFireplaceBlock.updateRightChimneys(isActivatedIn, blockStateIn, pos, worldIn);
        ConnectedVerticalSidedPlanFireplaceBlock.updateLeftChimneys(isActivatedIn, blockStateIn, pos, worldIn);
    }

    public static void updateLeftChimneys(boolean isActivatedIn, BlockState blockStateIn, BlockPos posIn, Level worldIn) {
        ConnectedVerticalSidedPlanFireplaceBlock.updateChimneyConductsAtSide(isActivatedIn, posIn.m_7494_(), worldIn);
        Direction facing = (Direction)blockStateIn.m_61143_((Property)ConnectedVerticalSidedBlock.FACING);
        BlockStatePropertiesAA.HorizontalConnection horizontalConnection = (BlockStatePropertiesAA.HorizontalConnection)((Object)blockStateIn.m_61143_(ConnectedVerticalSidedPlanBlock.HORIZONTAL_CONNECTION));
        if (BlockStatePropertiesAA.HorizontalConnection.RIGHT.equals((Object)horizontalConnection) || BlockStatePropertiesAA.HorizontalConnection.BOTH.equals((Object)horizontalConnection)) {
            BlockPos rightBlockPos = null;
            if (Direction.NORTH.equals((Object)facing) || Direction.SOUTH.equals((Object)facing)) {
                rightBlockPos = posIn.m_7918_(-1, 0, 0);
            } else if (Direction.EAST.equals((Object)facing) || Direction.WEST.equals((Object)facing)) {
                rightBlockPos = posIn.m_7918_(0, 0, -1);
            }
            BlockState leftBlockState = worldIn.m_8055_(rightBlockPos);
            if (leftBlockState.m_60734_() instanceof ConnectedVerticalSidedPlanFireplaceBlock) {
                ConnectedVerticalSidedPlanFireplaceBlock.updateLeftChimneys(isActivatedIn, blockStateIn, rightBlockPos, worldIn);
            }
        }
    }

    public static void updateRightChimneys(boolean isActivatedIn, BlockState blockStateIn, BlockPos posIn, Level worldIn) {
        ConnectedVerticalSidedPlanFireplaceBlock.updateChimneyConductsAtSide(isActivatedIn, posIn.m_7494_(), worldIn);
        Direction facing = (Direction)blockStateIn.m_61143_((Property)ConnectedVerticalSidedBlock.FACING);
        BlockStatePropertiesAA.HorizontalConnection horizontalConnection = (BlockStatePropertiesAA.HorizontalConnection)((Object)blockStateIn.m_61143_(ConnectedVerticalSidedPlanBlock.HORIZONTAL_CONNECTION));
        if (BlockStatePropertiesAA.HorizontalConnection.LEFT.equals((Object)horizontalConnection) || BlockStatePropertiesAA.HorizontalConnection.BOTH.equals((Object)horizontalConnection)) {
            BlockPos rightBlockPos = null;
            if (Direction.NORTH.equals((Object)facing) || Direction.SOUTH.equals((Object)facing)) {
                rightBlockPos = posIn.m_7918_(1, 0, 0);
            } else if (Direction.EAST.equals((Object)facing) || Direction.WEST.equals((Object)facing)) {
                rightBlockPos = posIn.m_7918_(0, 0, 1);
            }
            BlockState rightBlockState = worldIn.m_8055_(rightBlockPos);
            if (rightBlockState.m_60734_() instanceof ConnectedVerticalSidedPlanFireplaceBlock) {
                ConnectedVerticalSidedPlanFireplaceBlock.updateRightChimneys(isActivatedIn, blockStateIn, rightBlockPos, worldIn);
            }
        }
    }

    public static void updateChimneyConductsAtSide(boolean isActivatedIn, BlockPos blockPosIn, Level worldIn) {
        BlockState blockState = worldIn.m_8055_(blockPosIn);
        if (blockState.m_60734_() instanceof ChimneyBlockDoT) {
            ChimneyBlockDoT.updateAllChimneyConductParts(isActivatedIn, blockState, blockPosIn, worldIn);
        }
    }

    public boolean m_7361_(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluid) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() || fluid.m_76152_() != Fluids.f_76193_) {
            return false;
        }
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            world.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)WaterloggedBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 10);
        world.m_186469_(pos, fluid.m_76152_(), fluid.m_76152_().m_6718_((LevelReader)world));
        return true;
    }

    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (stateIn.m_61143_(ConnectedVerticalBlock.VERTICAL_CONNECTION) != BlockStatePropertiesAA.VerticalConnection.BOTH && stateIn.m_61143_(ConnectedVerticalBlock.VERTICAL_CONNECTION) != BlockStatePropertiesAA.VerticalConnection.UNDER && ((Boolean)stateIn.m_61143_((Property)LIT)).booleanValue()) {
            if (rand.m_188503_(24) == 0) {
                worldIn.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11784_, SoundSource.BLOCKS, 0.5f + rand.m_188501_(), rand.m_188501_() * 0.7f + 0.6f, false);
            }
            for (int i = 0; i < 3; ++i) {
                worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + rand.m_188500_() * 0.5 + 0.25, (double)pos.m_123342_() + rand.m_188500_() * 0.5 + (double)0.6f, (double)pos.m_123343_() + rand.m_188500_() * 0.5 + 0.25, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        Utils.addTooltip(tooltip, "fireplace");
    }
}

