/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.config;

import de.markusbordihn.easymobfarm.config.Config;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmType;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class MobFarmBonusConfig
extends Config {
    public static final String CONFIG_FILE_NAME = "mob_farm_bonus.cfg";
    public static final String CONFIG_FILE_HEADER = " Mob Farm Bonus Configuration\n\n This configuration file allows you to define the bonus drops for the Mob Farms.\n\n Configuration Format:\n --------------------\n <mob_farm_name>::<tier_level>::<entity_type> = <item_name>::<amount>::<chance 1 of x>\n\n Available Mob Farm Types:\n ------------------------\n - animal_plains_farm: For animals like cows, sheep, chickens, pigs\n - bee_hive_farm: For bees and honey production\n - desert_farm: For desert mobs like husks, rabbits, camels\n - iron_golem_farm: For iron golems and poppy drops\n - jungle_farm: For jungle mobs like parrots, pandas, ocelots\n - monster_plains_cave_farm: For common monsters like zombies, skeletons, spiders\n - nether_fortress_farm: For nether mobs like blazes, magma cubes, wither skeletons\n - ocean_farm: For ocean mobs like cod, salmon, squid, guardians\n - swamp_farm: For swamp mobs like frogs, slimes, witches\n\n Tier Levels (better farms = better bonus chances):\n -------------------------------------------------\n - 0: Basic tier (lowest bonus chance)\n - 1: Improved tier (better bonus chance)\n - 2: Advanced tier (good bonus chance)\n - 3: Elite tier (highest bonus chance)\n\n Configuration Examples:\n ----------------------\n Basic bee farm with 1 in 20 chance for honeycomb:\n   bee_hive_farm::0::minecraft:bee = minecraft:honeycomb::1::20\n\n Elite bee farm with 1 in 5 chance for honeycomb:\n   bee_hive_farm::3::minecraft:bee = minecraft:honeycomb::1::5\n\n Iron golem farm with bonus iron ingots:\n   iron_golem_farm::2::minecraft:iron_golem = minecraft:iron_ingot::2::8\n\n Multiple bonus items for the same mob (different lines):\n   ocean_farm::1::minecraft:cod = minecraft:cod::1::10\n   ocean_farm::1::minecraft:cod = minecraft:bone_meal::1::25\n\n Important Notes:\n ---------------\n - Lower chance numbers = higher drop probability (1 = always, 100 = 1% chance)\n - To disable a bonus drop, set the amount to 0\n - Each mob farm type targets specific biome-appropriate mobs\n - Higher tier farms have better default bonus chances\n\n";
    public static final String LOG_PREFIX = "[MobFarmBonusConfig]";
    private static final Random random = new Random();
    private static final HashMap<String, HashMap<Integer, ItemStack>> mobFarmBonusMap = new HashMap();
    private static final HashMap<String, HashMap<Integer, ItemStack>> defaultMobFarmBonusMap = new HashMap();

    public static void registerConfig() {
        MobFarmBonusConfig.registerConfigFile(CONFIG_FILE_NAME, CONFIG_FILE_HEADER);
        MobFarmBonusConfig.parseConfigFile();
    }

    public static void parseConfigFile() {
        File configFile = MobFarmBonusConfig.getConfigFile(CONFIG_FILE_NAME);
        Properties properties = MobFarmBonusConfig.readConfigFile(configFile);
        Properties unmodifiedProperties = (Properties)properties.clone();
        defaultMobFarmBonusMap.forEach((mobFarmName, bonusMap) -> {
            if (!properties.containsKey(mobFarmName)) {
                bonusMap.forEach((chance, itemStack) -> {
                    String itemName = BuiltInRegistries.f_257033_.m_7981_((Object)itemStack.m_41720_()).toString();
                    String value = itemName + "::" + itemStack.m_41613_() + "::" + chance;
                    properties.setProperty((String)mobFarmName, value);
                });
            }
        });
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String[] keyParts = MobFarmBonusConfig.parseKey((String)key);
            if (keyParts == null) {
                return;
            }
            String mobFarmName = keyParts[0];
            String entityType = keyParts[2];
            String[] valueParts = MobFarmBonusConfig.parseValue((String)value);
            if (valueParts == null || valueParts[0].isEmpty()) {
                return;
            }
            String itemName = valueParts[0];
            try {
                int tierLevel = Integer.parseInt(keyParts[1]);
                int amount = Integer.parseInt(valueParts[1]);
                int chance = Integer.parseInt(valueParts[2]);
                MobFarmBonusConfig.addBonusDropEntry(mobFarmName, tierLevel, entityType, chance, itemName, amount);
            }
            catch (NumberFormatException e) {
                log.error("{} Invalid number format in config file {}: key={}, value={}", (Object)LOG_PREFIX, (Object)CONFIG_FILE_NAME, key, value);
            }
        }));
        MobFarmBonusConfig.updateConfigFileIfChanged(configFile, CONFIG_FILE_HEADER, properties, unmodifiedProperties);
    }

    public static String getMobFarmKey(String mobFarmName, int tierLevel, String entityType) {
        return mobFarmName + "::" + tierLevel + "::" + entityType;
    }

    public static void addBonusDropEntry(String mobFarmName, int tierLevel, String entityType, int chance, String itemName, int amount) {
        Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(itemName));
        if (item == Items.f_41852_) {
            log.error("{} Invalid item name {} in config file {}", (Object)LOG_PREFIX, (Object)itemName, (Object)CONFIG_FILE_NAME);
            return;
        }
        try {
            MobFarmType mobFarmType = MobFarmType.valueOf(mobFarmName.toUpperCase(Locale.ROOT));
            MobFarmBonusConfig.addBonusDropEntry(mobFarmType, tierLevel, entityType, chance, new ItemStack((ItemLike)item, amount));
        }
        catch (IllegalArgumentException e) {
            log.error("{} Invalid mob farm name {} in config file {}", (Object)LOG_PREFIX, (Object)mobFarmName, (Object)CONFIG_FILE_NAME);
        }
    }

    public static void addBonusDropEntry(MobFarmType mobFarmType, int tierLevel, String entityType, int chance, ItemStack itemStack) {
        String mobFarmKey = MobFarmBonusConfig.getMobFarmKey(mobFarmType.getId(), tierLevel, entityType);
        if (itemStack.m_41619_()) {
            log.error("{} Invalid item stack {} in config file {}", (Object)LOG_PREFIX, (Object)itemStack, (Object)CONFIG_FILE_NAME);
            return;
        }
        if (BuiltInRegistries.f_256780_.m_6612_(new ResourceLocation(entityType)).isEmpty()) {
            log.error("{} Invalid entity type {} in config file {}", (Object)LOG_PREFIX, (Object)entityType, (Object)CONFIG_FILE_NAME);
            return;
        }
        log.info("{} Add {} with a chance of 1 of {} for {}.", (Object)LOG_PREFIX, (Object)mobFarmKey, (Object)chance, (Object)itemStack);
        mobFarmBonusMap.computeIfAbsent(mobFarmKey, k -> new HashMap()).put(chance, itemStack);
    }

    public static ItemStack getBonusDropEntry(MobFarmType mobFarmType, int tierLevel, EntityType<?> entityType) {
        return MobFarmBonusConfig.getBonusDropEntry(mobFarmType.getId(), tierLevel, String.valueOf(BuiltInRegistries.f_256780_.m_7981_(entityType)));
    }

    public static ItemStack getBonusDropEntry(String mobFarmName, int tierLevel, String entityType) {
        if (!MobFarmBonusConfig.hasBonusDrop(mobFarmName, tierLevel, entityType)) {
            return ItemStack.f_41583_;
        }
        return mobFarmBonusMap.get(MobFarmBonusConfig.getMobFarmKey(mobFarmName, tierLevel, entityType)).entrySet().stream().map(Map.Entry::getValue).findFirst().orElse(ItemStack.f_41583_);
    }

    public static ItemStack getBonusDrop(MobFarmType mobFarmType, int tierLevel, EntityType<?> entityType) {
        return MobFarmBonusConfig.getBonusDrop(mobFarmType.getId(), tierLevel, String.valueOf(BuiltInRegistries.f_256780_.m_7981_(entityType)));
    }

    public static ItemStack getBonusDrop(String mobFarmName, int tierLevel, String entityType) {
        if (!MobFarmBonusConfig.hasBonusDrop(mobFarmName, tierLevel, entityType)) {
            return ItemStack.f_41583_;
        }
        return mobFarmBonusMap.get(MobFarmBonusConfig.getMobFarmKey(mobFarmName, tierLevel, entityType)).entrySet().stream().filter(entry -> random.nextInt((Integer)entry.getKey()) == 0).map(Map.Entry::getValue).findFirst().orElse(ItemStack.f_41583_);
    }

    public static boolean hasBonusDrop(String mobFarmName, int tierLevel, EntityType<?> entityType) {
        return MobFarmBonusConfig.hasBonusDrop(mobFarmName, tierLevel, String.valueOf(BuiltInRegistries.f_256780_.m_7981_(entityType)));
    }

    public static boolean hasBonusDrop(String mobFarmName, int tierLevel, String entityType) {
        return mobFarmBonusMap.containsKey(MobFarmBonusConfig.getMobFarmKey(mobFarmName, tierLevel, entityType));
    }

    private static String[] parseKey(String key) {
        String[] keyParts = key.split("::");
        if (keyParts.length != 3) {
            log.error("Invalid key format in config file: {}", (Object)key);
            return null;
        }
        return keyParts;
    }

    private static String[] parseValue(String value) {
        String[] valueParts = value.split("::");
        if (valueParts.length != 3) {
            log.error("Invalid value format in config file: {}", (Object)value);
            return null;
        }
        return valueParts;
    }

    static {
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::0::minecraft:cow", new HashMap<Integer, ItemStack>(Map.of(20, new ItemStack((ItemLike)Items.f_42454_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::1::minecraft:cow", new HashMap<Integer, ItemStack>(Map.of(15, new ItemStack((ItemLike)Items.f_42454_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::2::minecraft:cow", new HashMap<Integer, ItemStack>(Map.of(10, new ItemStack((ItemLike)Items.f_42454_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::3::minecraft:cow", new HashMap<Integer, ItemStack>(Map.of(5, new ItemStack((ItemLike)Items.f_42454_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::0::minecraft:sheep", new HashMap<Integer, ItemStack>(Map.of(20, new ItemStack((ItemLike)Items.f_41870_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::1::minecraft:sheep", new HashMap<Integer, ItemStack>(Map.of(15, new ItemStack((ItemLike)Items.f_41870_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::2::minecraft:sheep", new HashMap<Integer, ItemStack>(Map.of(10, new ItemStack((ItemLike)Items.f_41870_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::3::minecraft:sheep", new HashMap<Integer, ItemStack>(Map.of(5, new ItemStack((ItemLike)Items.f_41870_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::0::minecraft:chicken", new HashMap<Integer, ItemStack>(Map.of(20, new ItemStack((ItemLike)Items.f_42521_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::1::minecraft:chicken", new HashMap<Integer, ItemStack>(Map.of(15, new ItemStack((ItemLike)Items.f_42521_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::2::minecraft:chicken", new HashMap<Integer, ItemStack>(Map.of(10, new ItemStack((ItemLike)Items.f_42521_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::3::minecraft:chicken", new HashMap<Integer, ItemStack>(Map.of(5, new ItemStack((ItemLike)Items.f_42521_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.BEE_HIVE_FARM.getId() + "::0::minecraft:bee", new HashMap<Integer, ItemStack>(Map.of(20, new ItemStack((ItemLike)Items.f_42784_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.BEE_HIVE_FARM.getId() + "::1::minecraft:bee", new HashMap<Integer, ItemStack>(Map.of(15, new ItemStack((ItemLike)Items.f_42784_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.BEE_HIVE_FARM.getId() + "::2::minecraft:bee", new HashMap<Integer, ItemStack>(Map.of(10, new ItemStack((ItemLike)Items.f_42784_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.BEE_HIVE_FARM.getId() + "::3::minecraft:bee", new HashMap<Integer, ItemStack>(Map.of(5, new ItemStack((ItemLike)Items.f_42784_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.DESERT_FARM.getId() + "::0::minecraft:husk", new HashMap<Integer, ItemStack>(Map.of(20, new ItemStack((ItemLike)Items.f_41830_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.DESERT_FARM.getId() + "::1::minecraft:husk", new HashMap<Integer, ItemStack>(Map.of(15, new ItemStack((ItemLike)Items.f_41830_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.DESERT_FARM.getId() + "::2::minecraft:husk", new HashMap<Integer, ItemStack>(Map.of(10, new ItemStack((ItemLike)Items.f_41830_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.DESERT_FARM.getId() + "::3::minecraft:husk", new HashMap<Integer, ItemStack>(Map.of(5, new ItemStack((ItemLike)Items.f_41830_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.DESERT_FARM.getId() + "::0::minecraft:rabbit", new HashMap<Integer, ItemStack>(Map.of(20, new ItemStack((ItemLike)Items.f_42649_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.DESERT_FARM.getId() + "::1::minecraft:rabbit", new HashMap<Integer, ItemStack>(Map.of(15, new ItemStack((ItemLike)Items.f_42649_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.DESERT_FARM.getId() + "::2::minecraft:rabbit", new HashMap<Integer, ItemStack>(Map.of(10, new ItemStack((ItemLike)Items.f_42649_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.DESERT_FARM.getId() + "::3::minecraft:rabbit", new HashMap<Integer, ItemStack>(Map.of(5, new ItemStack((ItemLike)Items.f_42649_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.IRON_GOLEM_FARM.getId() + "::0::minecraft:iron_golem", new HashMap<Integer, ItemStack>(Map.of(20, new ItemStack((ItemLike)Items.f_42416_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.IRON_GOLEM_FARM.getId() + "::1::minecraft:iron_golem", new HashMap<Integer, ItemStack>(Map.of(15, new ItemStack((ItemLike)Items.f_42416_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.IRON_GOLEM_FARM.getId() + "::2::minecraft:iron_golem", new HashMap<Integer, ItemStack>(Map.of(10, new ItemStack((ItemLike)Items.f_42416_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.IRON_GOLEM_FARM.getId() + "::3::minecraft:iron_golem", new HashMap<Integer, ItemStack>(Map.of(5, new ItemStack((ItemLike)Items.f_42416_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.JUNGLE_FARM.getId() + "::0::minecraft:parrot", new HashMap<Integer, ItemStack>(Map.of(20, new ItemStack((ItemLike)Items.f_42402_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.JUNGLE_FARM.getId() + "::1::minecraft:parrot", new HashMap<Integer, ItemStack>(Map.of(15, new ItemStack((ItemLike)Items.f_42402_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.JUNGLE_FARM.getId() + "::2::minecraft:parrot", new HashMap<Integer, ItemStack>(Map.of(10, new ItemStack((ItemLike)Items.f_42402_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.JUNGLE_FARM.getId() + "::3::minecraft:parrot", new HashMap<Integer, ItemStack>(Map.of(5, new ItemStack((ItemLike)Items.f_42402_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.JUNGLE_FARM.getId() + "::0::minecraft:panda", new HashMap<Integer, ItemStack>(Map.of(20, new ItemStack((ItemLike)Items.f_41911_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.JUNGLE_FARM.getId() + "::1::minecraft:panda", new HashMap<Integer, ItemStack>(Map.of(15, new ItemStack((ItemLike)Items.f_41911_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.JUNGLE_FARM.getId() + "::2::minecraft:panda", new HashMap<Integer, ItemStack>(Map.of(10, new ItemStack((ItemLike)Items.f_41911_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.JUNGLE_FARM.getId() + "::3::minecraft:panda", new HashMap<Integer, ItemStack>(Map.of(5, new ItemStack((ItemLike)Items.f_41911_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.MONSTER_PLAINS_CAVE_FARM.getId() + "::0::minecraft:zombie", new HashMap<Integer, ItemStack>(Map.of(20, new ItemStack((ItemLike)Items.f_42583_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.MONSTER_PLAINS_CAVE_FARM.getId() + "::1::minecraft:zombie", new HashMap<Integer, ItemStack>(Map.of(15, new ItemStack((ItemLike)Items.f_42583_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.MONSTER_PLAINS_CAVE_FARM.getId() + "::2::minecraft:zombie", new HashMap<Integer, ItemStack>(Map.of(10, new ItemStack((ItemLike)Items.f_42583_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.MONSTER_PLAINS_CAVE_FARM.getId() + "::3::minecraft:zombie", new HashMap<Integer, ItemStack>(Map.of(5, new ItemStack((ItemLike)Items.f_42583_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.NETHER_FORTRESS_FARM.getId() + "::0::minecraft:blaze", new HashMap<Integer, ItemStack>(Map.of(20, new ItemStack((ItemLike)Items.f_42585_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.NETHER_FORTRESS_FARM.getId() + "::1::minecraft:blaze", new HashMap<Integer, ItemStack>(Map.of(15, new ItemStack((ItemLike)Items.f_42585_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.NETHER_FORTRESS_FARM.getId() + "::2::minecraft:blaze", new HashMap<Integer, ItemStack>(Map.of(10, new ItemStack((ItemLike)Items.f_42585_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.NETHER_FORTRESS_FARM.getId() + "::3::minecraft:blaze", new HashMap<Integer, ItemStack>(Map.of(5, new ItemStack((ItemLike)Items.f_42585_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.NETHER_FORTRESS_FARM.getId() + "::0::minecraft:magma_cube", new HashMap<Integer, ItemStack>(Map.of(20, new ItemStack((ItemLike)Items.f_42542_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.NETHER_FORTRESS_FARM.getId() + "::1::minecraft:magma_cube", new HashMap<Integer, ItemStack>(Map.of(15, new ItemStack((ItemLike)Items.f_42542_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.NETHER_FORTRESS_FARM.getId() + "::2::minecraft:magma_cube", new HashMap<Integer, ItemStack>(Map.of(10, new ItemStack((ItemLike)Items.f_42542_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.NETHER_FORTRESS_FARM.getId() + "::3::minecraft:magma_cube", new HashMap<Integer, ItemStack>(Map.of(5, new ItemStack((ItemLike)Items.f_42542_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.OCEAN_FARM.getId() + "::0::minecraft:cod", new HashMap<Integer, ItemStack>(Map.of(20, new ItemStack((ItemLike)Items.f_42526_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.OCEAN_FARM.getId() + "::1::minecraft:cod", new HashMap<Integer, ItemStack>(Map.of(15, new ItemStack((ItemLike)Items.f_42526_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.OCEAN_FARM.getId() + "::2::minecraft:cod", new HashMap<Integer, ItemStack>(Map.of(10, new ItemStack((ItemLike)Items.f_42526_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.OCEAN_FARM.getId() + "::3::minecraft:cod", new HashMap<Integer, ItemStack>(Map.of(5, new ItemStack((ItemLike)Items.f_42526_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.OCEAN_FARM.getId() + "::0::minecraft:squid", new HashMap<Integer, ItemStack>(Map.of(20, new ItemStack((ItemLike)Items.f_42532_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.OCEAN_FARM.getId() + "::1::minecraft:squid", new HashMap<Integer, ItemStack>(Map.of(15, new ItemStack((ItemLike)Items.f_42532_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.OCEAN_FARM.getId() + "::2::minecraft:squid", new HashMap<Integer, ItemStack>(Map.of(10, new ItemStack((ItemLike)Items.f_42532_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.OCEAN_FARM.getId() + "::3::minecraft:squid", new HashMap<Integer, ItemStack>(Map.of(5, new ItemStack((ItemLike)Items.f_42532_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::0::minecraft:frog", new HashMap<Integer, ItemStack>(Map.of(20, new ItemStack((ItemLike)Items.f_42518_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::1::minecraft:frog", new HashMap<Integer, ItemStack>(Map.of(15, new ItemStack((ItemLike)Items.f_42518_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::2::minecraft:frog", new HashMap<Integer, ItemStack>(Map.of(10, new ItemStack((ItemLike)Items.f_42518_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::3::minecraft:frog", new HashMap<Integer, ItemStack>(Map.of(5, new ItemStack((ItemLike)Items.f_42518_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::0::minecraft:slime", new HashMap<Integer, ItemStack>(Map.of(20, new ItemStack((ItemLike)Items.f_42518_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::1::minecraft:slime", new HashMap<Integer, ItemStack>(Map.of(15, new ItemStack((ItemLike)Items.f_42518_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::2::minecraft:slime", new HashMap<Integer, ItemStack>(Map.of(10, new ItemStack((ItemLike)Items.f_42518_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::3::minecraft:slime", new HashMap<Integer, ItemStack>(Map.of(5, new ItemStack((ItemLike)Items.f_42518_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::0::minecraft:witch", new HashMap<Integer, ItemStack>(Map.of(20, new ItemStack((ItemLike)Items.f_42451_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::1::minecraft:witch", new HashMap<Integer, ItemStack>(Map.of(15, new ItemStack((ItemLike)Items.f_42451_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::2::minecraft:witch", new HashMap<Integer, ItemStack>(Map.of(10, new ItemStack((ItemLike)Items.f_42451_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::3::minecraft:witch", new HashMap<Integer, ItemStack>(Map.of(5, new ItemStack((ItemLike)Items.f_42451_, 1))));
    }
}

