/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding;

import net.minecraftforge.common.ForgeConfigSpec;

public class ClientConfig {
    private static final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    public static final Visuals visuals = new Visuals(builder);
    public static final ForgeConfigSpec spec = builder.build();

    public static class Visuals {
        public final ForgeConfigSpec.BooleanValue showBlockPreviews;
        public final ForgeConfigSpec.BooleanValue onlyShowBlockPreviewsWhenBuilding;
        public final ForgeConfigSpec.IntValue maxBlockPreviews;
        public final ForgeConfigSpec.IntValue appearAnimationLength;
        public final ForgeConfigSpec.IntValue breakAnimationLength;

        public Visuals(ForgeConfigSpec.Builder builder) {
            builder.push("Visuals");
            this.showBlockPreviews = builder.comment("Show previews of the blocks while placing them").define("showBlockPreviews", true);
            this.onlyShowBlockPreviewsWhenBuilding = builder.comment("Show block previews only when actively using a build mode").define("onlyShowBlockPreviewsWhenBuilding", true);
            this.maxBlockPreviews = builder.comment("Don't show block previews when placing more than this many blocks. The outline will always be rendered.").defineInRange("maxBlockPreviews", 400, 0, 5000);
            this.appearAnimationLength = builder.comment(new String[]{"How long it takes for a block to appear when placed in ticks.", "Set to 0 to disable animation."}).defineInRange("appearAnimationLength", 5, 0, 100);
            this.breakAnimationLength = builder.comment(new String[]{"How long the break animation is in ticks.", "Set to 0 to disable animation."}).defineInRange("breakAnimationLength", 10, 0, 100);
            builder.pop();
        }
    }
}

