/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.utilities;

import net.minecraft.client.Minecraft;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import nl.requios.effortlessbuilding.capability.CapabilityHandler;
import nl.requios.effortlessbuilding.utilities.BlockEntry;

@OnlyIn(value=Dist.CLIENT)
public class ClientBlockUtilities {
    public static boolean determineIfLookingAtInteractiveObject(Minecraft mc, Level level) {
        boolean result = false;
        if (mc.f_91077_ != null) {
            BlockHitResult blockHitResult;
            BlockState blockState;
            if (mc.f_91077_.m_6662_() == HitResult.Type.BLOCK && (blockState = level.m_8055_((blockHitResult = (BlockHitResult)mc.f_91077_).m_82425_())).m_155947_()) {
                result = true;
            }
            if (mc.f_91077_.m_6662_() == HitResult.Type.ENTITY) {
                result = true;
            }
        }
        return result;
    }

    public static void playSoundIfFurtherThanNormal(Player player, BlockEntry blockEntry, boolean breaking) {
        if (Minecraft.m_91087_().f_91077_ != null && Minecraft.m_91087_().f_91077_.m_6662_() == HitResult.Type.BLOCK) {
            return;
        }
        if (blockEntry == null || blockEntry.newBlockState == null) {
            return;
        }
        SoundType soundType = blockEntry.newBlockState.m_60734_().getSoundType(blockEntry.newBlockState, (LevelReader)player.m_9236_(), blockEntry.blockPos, (Entity)player);
        SoundEvent soundEvent = breaking ? soundType.m_56775_() : soundType.m_56777_();
        player.m_9236_().m_5594_(player, player.m_20183_(), soundEvent, SoundSource.BLOCKS, 0.6f, soundType.m_56774_());
    }

    public static BlockHitResult getLookingAtFar(Player player) {
        Level world = player.m_9236_();
        float raytraceRange = CapabilityHandler.getPlacementReach(player, false);
        Vec3 look = player.m_20154_();
        Vec3 start = new Vec3(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_());
        Vec3 end = new Vec3(player.m_20185_() + look.f_82479_ * (double)raytraceRange, player.m_20186_() + (double)player.m_20192_() + look.f_82480_ * (double)raytraceRange, player.m_20189_() + look.f_82481_ * (double)raytraceRange);
        return world.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
    }
}

