/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.compat.crafttweaker.handler;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.component.BuiltinRecipeComponents;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.component.IRecipeComponent;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.IngredientUtil;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import novamachina.exnihilosequentia.world.item.crafting.CrushingRecipe;
import novamachina.exnihilosequentia.world.item.crafting.ItemStackWithChance;

@IRecipeHandler.For(value=CrushingRecipe.class)
public class CrushingRecipeHandler
implements IRecipeHandler<CrushingRecipe> {
    IRecipeComponent<List<ItemStackWithChance>> STACK_WITH_CHANCE = IRecipeComponent.simple((ResourceLocation)new ResourceLocation("exnihilosequentia", "output/stack_with_chance"), (TypeToken)new TypeToken<List<ItemStackWithChance>>(){}, List::equals);

    public String dumpToCommandString(IRecipeManager<? super CrushingRecipe> manager, CrushingRecipe recipe) {
        StringJoiner dropJoiner = new StringJoiner(", ");
        for (ItemStackWithChance drop : recipe.getDrops()) {
            dropJoiner.add(String.format("ItemStackWithChance.of(%s, %f)", IItemStack.of((ItemStack)drop.getStack()).getCommandString(), Float.valueOf(drop.getChance())));
        }
        return String.format("<recipetype:exnihilosequentia:crushing>.addRecipe(%s, [%s]);", StringUtil.quoteAndEscape((ResourceLocation)recipe.m_6423_()), dropJoiner);
    }

    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager<? super CrushingRecipe> manager, CrushingRecipe firstRecipe, U secondRecipe) {
        CrushingRecipe second = (CrushingRecipe)secondRecipe;
        return IngredientUtil.canConflict((Ingredient)firstRecipe.getInput(), (Ingredient)second.getInput());
    }

    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super CrushingRecipe> manager, CrushingRecipe recipe) {
        IIngredient ingredient = IIngredient.fromIngredient((Ingredient)recipe.getInput());
        IDecomposedRecipe decomposition = IDecomposedRecipe.builder().with(BuiltinRecipeComponents.Input.INGREDIENTS, (Object)ingredient).with(BuiltinRecipeComponents.Output.ITEMS, recipe.getOutputsWithoutChance().stream().map(IItemStack::of).toList()).with(this.STACK_WITH_CHANCE, recipe.getDrops()).build();
        return Optional.of(decomposition);
    }

    public Optional<CrushingRecipe> recompose(IRecipeManager<? super CrushingRecipe> manager, ResourceLocation name, IDecomposedRecipe recipe) {
        IIngredient input = (IIngredient)recipe.getOrThrowSingle(BuiltinRecipeComponents.Input.INGREDIENTS);
        List drops = (List)recipe.getOrThrowSingle(this.STACK_WITH_CHANCE);
        if (input.isEmpty()) {
            throw new IllegalArgumentException("Invalid input: empty ingredient");
        }
        if (drops.isEmpty()) {
            throw new IllegalArgumentException("Invalid drop list: empty list");
        }
        return Optional.of(new CrushingRecipe(name, input.asVanillaIngredient(), (ItemStackWithChance[])drops.toArray(ItemStackWithChance[]::new)));
    }
}

