/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.compat.crafttweaker.handler;

import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.component.IRecipeComponent;
import com.blamejared.crafttweaker.api.recipe.component.RecipeComponentEqualityCheckers;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;
import novamachina.exnihilosequentia.world.item.crafting.HeatRecipe;

@IRecipeHandler.For(value=HeatRecipe.class)
public class HeatRecipeHandler
implements IRecipeHandler<HeatRecipe> {
    IRecipeComponent<Block> BLOCK_INPUT = IRecipeComponent.simple((ResourceLocation)new ResourceLocation("exnihilosequentia", "input/block_input"), (TypeToken)new TypeToken<Block>(){}, (block, block2) -> block.m_49966_().m_60713_(block2));
    IRecipeComponent<Integer> OUTPUT_AMOUNT = IRecipeComponent.simple((ResourceLocation)new ResourceLocation("exnihilosequentia", "output/amount"), (TypeToken)new TypeToken<Integer>(){}, RecipeComponentEqualityCheckers::areNumbersEqual);
    IRecipeComponent<StatePropertiesPredicate> PROPERTIES = IRecipeComponent.simple((ResourceLocation)new ResourceLocation("exnihilosequentia", "meta/properties"), (TypeToken)new TypeToken<StatePropertiesPredicate>(){}, this::compareProperties);

    public String dumpToCommandString(IRecipeManager<? super HeatRecipe> manager, HeatRecipe recipe) {
        ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)recipe.getInputBlock());
        return String.format("<recipetype:exnihilosequentia:heat>.addRecipe(%s, %d, %s, %s);", StringUtil.quoteAndEscape((ResourceLocation)recipe.m_6423_()), recipe.getAmount(), String.format("<block:%s:%s>", blockId.m_135827_(), blockId.m_135815_()), this.encodeProperties(recipe.getProperties()));
    }

    private String encodeProperties(StatePropertiesPredicate properties) {
        JsonObject props = properties.m_67666_().getAsJsonObject();
        StringBuilder builder = new StringBuilder("StatePropertiesPredicate.create()");
        for (Map.Entry entry : props.entrySet()) {
            builder.append(String.format(".property(\"%s\", <appropriate property value>)", entry.getKey()));
        }
        builder.append(".build()");
        return builder.toString();
    }

    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager<? super HeatRecipe> manager, HeatRecipe firstRecipe, U secondRecipe) {
        HeatRecipe second = (HeatRecipe)secondRecipe;
        return firstRecipe.getInputBlock().m_49966_().m_60713_(second.getInputBlock()) && this.compareProperties(firstRecipe.getProperties(), second.getProperties());
    }

    private boolean compareProperties(StatePropertiesPredicate first, StatePropertiesPredicate second) {
        JsonObject firstProps = first.m_67666_().getAsJsonObject();
        JsonObject secondProps = second.m_67666_().getAsJsonObject();
        for (Map.Entry entry : firstProps.entrySet()) {
            if (!secondProps.has((String)entry.getKey())) {
                return false;
            }
            if (secondProps.get((String)entry.getKey()).equals(entry.getValue())) continue;
            return false;
        }
        for (Map.Entry entry : secondProps.entrySet()) {
            if (!firstProps.has((String)entry.getKey())) {
                return false;
            }
            if (firstProps.get((String)entry.getKey()).equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super HeatRecipe> manager, HeatRecipe recipe) {
        IDecomposedRecipe decomposition = IDecomposedRecipe.builder().with(this.BLOCK_INPUT, (Object)recipe.getInputBlock()).with(this.OUTPUT_AMOUNT, (Object)recipe.getAmount()).with(this.PROPERTIES, (Object)recipe.getProperties()).build();
        return Optional.of(decomposition);
    }

    public Optional<HeatRecipe> recompose(IRecipeManager<? super HeatRecipe> manager, ResourceLocation name, IDecomposedRecipe recipe) {
        Block input = (Block)recipe.getOrThrowSingle(this.BLOCK_INPUT);
        int amount = (Integer)recipe.getOrThrowSingle(this.OUTPUT_AMOUNT);
        StatePropertiesPredicate properties = (StatePropertiesPredicate)recipe.getOrThrowSingle(this.PROPERTIES);
        if (input == Blocks.f_50016_) {
            throw new IllegalArgumentException("Invalid input block: is air block");
        }
        if (amount <= 0) {
            throw new IllegalArgumentException("Invalid heat value: " + amount);
        }
        return Optional.of(new HeatRecipe(name, input, amount, properties));
    }
}

