/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.registries;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import net.minecraft.world.level.block.state.BlockState;
import novamachina.exnihilosequentia.world.item.crafting.HeatRecipe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeatRegistry {
    private static Logger log = LoggerFactory.getLogger(HeatRegistry.class);
    @Nonnull
    private final List<HeatRecipe> recipeList = new ArrayList<HeatRecipe>();
    private final LoadingCache<BlockState, Integer> cache;

    public HeatRegistry() {
        CacheLoader<BlockState, Integer> loader = new CacheLoader<BlockState, Integer>(){

            public Integer load(BlockState key) {
                return HeatRegistry.this.recipeList.stream().filter(recipe -> recipe.isMatch(key)).findFirst().map(HeatRecipe::getAmount).orElse(0);
            }
        };
        this.cache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)loader);
    }

    public void clearRecipes() {
        this.recipeList.clear();
        this.cache.invalidateAll();
    }

    public int getHeatAmount(@Nonnull BlockState entry) {
        try {
            return (Integer)this.cache.get((Object)entry);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public List<HeatRecipe> getRecipeList() {
        return this.recipeList;
    }

    public void setRecipes(@Nonnull List<HeatRecipe> recipes) {
        log.debug("Heat Registry recipes: " + recipes.size());
        this.recipeList.addAll(recipes);
        this.cache.invalidateAll();
    }
}

