/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.data.recipes;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import novamachina.exnihilosequentia.world.item.crafting.EXNRecipeSerializers;
import novamachina.novacore.data.recipes.RecipeBuilder;
import novamachina.novacore.util.FluidStackUtils;

public class TransitionRecipeBuilder
extends RecipeBuilder<TransitionRecipeBuilder> {
    private final Ingredient catalyst;
    private final FluidStack fluidInTank;
    private final FluidStack result;

    protected TransitionRecipeBuilder(FluidStack fluidInTank, Ingredient catalyst, FluidStack result) {
        super(EXNRecipeSerializers.TRANSITION_RECIPE_SERIALIZER.recipeSerializer());
        this.fluidInTank = fluidInTank;
        this.catalyst = catalyst;
        this.result = result;
    }

    public static TransitionRecipeBuilder transition(FluidStack fluidInTank, ItemLike catalyst, FluidStack result) {
        return TransitionRecipeBuilder.transition(fluidInTank, Ingredient.m_43929_((ItemLike[])new ItemLike[]{catalyst}), result);
    }

    public static TransitionRecipeBuilder transition(FluidStack fluidInTank, TagKey<Item> catalyst, FluidStack result) {
        return TransitionRecipeBuilder.transition(fluidInTank, Ingredient.m_204132_(catalyst), result);
    }

    public static TransitionRecipeBuilder transition(FluidStack fluidInTank, Ingredient catalyst, FluidStack result) {
        return new TransitionRecipeBuilder(fluidInTank, catalyst, result);
    }

    protected void validate(ResourceLocation id) {
        Preconditions.checkNotNull((Object)this.fluidInTank, (Object)"Fluid in tank cannot be null");
        Preconditions.checkArgument((!this.fluidInTank.isEmpty() ? 1 : 0) != 0, (Object)"Fluid in tank amount amount cannot be 0");
        Preconditions.checkNotNull((Object)this.fluidInTank, (Object)"Catalyst cannot be null.");
        Preconditions.checkNotNull((Object)this.result, (Object)"Fluid result cannot be null");
        Preconditions.checkArgument((!this.result.isEmpty() ? 1 : 0) != 0, (Object)"Fluid result amount amount cannot be 0");
    }

    protected TransitionRecipeResult getResult(ResourceLocation id) {
        return new TransitionRecipeResult(id);
    }

    public class TransitionRecipeResult
    extends RecipeBuilder.RecipeResult {
        public TransitionRecipeResult(ResourceLocation id) {
            super((RecipeBuilder)TransitionRecipeBuilder.this, id);
        }

        public void m_7917_(JsonObject json) {
            json.add("fluidInTank", FluidStackUtils.serialize((FluidStack)TransitionRecipeBuilder.this.fluidInTank));
            json.add("catalyst", TransitionRecipeBuilder.this.catalyst.m_43942_());
            json.add("result", FluidStackUtils.serialize((FluidStack)TransitionRecipeBuilder.this.result));
        }
    }
}

