/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.world.level.block;

import java.security.SecureRandom;
import java.util.Random;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import novamachina.exnihilosequentia.common.Config;
import novamachina.exnihilosequentia.common.compat.top.ITOPInfoProvider;
import novamachina.exnihilosequentia.tags.ExNihiloTags;
import novamachina.exnihilosequentia.world.level.block.EXNBlocks;
import novamachina.exnihilosequentia.world.level.block.InfestedLeavesBlock;
import novamachina.exnihilosequentia.world.level.block.entity.EXNBlockEntityTypes;
import novamachina.exnihilosequentia.world.level.block.entity.InfestingLeavesBlockEntity;
import novamachina.novacore.util.StringUtils;
import org.jetbrains.annotations.Nullable;

public class InfestingLeavesBlock
extends Block
implements EntityBlock,
ITOPInfoProvider {
    @Nonnull
    private static final Random random = new SecureRandom();

    public InfestingLeavesBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(0.2f).m_60918_(SoundType.f_56740_).m_60955_().m_60922_((blockState, blockGetter, blockPos, entityType) -> false));
    }

    public static void finishInfestingBlock(@Nonnull Level world, @Nonnull BlockPos pos) {
        world.m_46597_(pos, ((InfestedLeavesBlock)EXNBlocks.INFESTED_LEAVES.block()).m_49966_());
    }

    public static void normalToInfesting(@Nonnull Level world, @Nonnull BlockPos pos) {
        world.m_46597_(pos, ((InfestingLeavesBlock)EXNBlocks.INFESTING_LEAVES.block()).m_49966_());
    }

    public static void spread(@Nonnull Level world, @Nonnull BlockPos pos) {
        if (!world.m_5776_()) {
            NonNullList<BlockPos> nearbyLeaves = InfestingLeavesBlock.getNearbyLeaves(world, pos);
            nearbyLeaves.forEach(leafPos -> {
                if (random.nextDouble() <= Config.getSpreadChance()) {
                    InfestingLeavesBlock.normalToInfesting(world, leafPos);
                }
            });
        }
    }

    @Nonnull
    private static NonNullList<BlockPos> getNearbyLeaves(@Nonnull Level world, @Nonnull BlockPos pos) {
        NonNullList nearbyLeaves = NonNullList.m_122779_();
        BlockPos.m_121990_((BlockPos)new BlockPos(pos.m_123341_() - 1, pos.m_123342_() - 1, pos.m_123343_() - 1), (BlockPos)new BlockPos(pos.m_123341_() + 1, pos.m_123342_() + 1, pos.m_123343_() + 1)).forEach(item -> {
            if (world.m_8055_(item).m_204336_(ExNihiloTags.INFESTABLE)) {
                nearbyLeaves.add((Object)new BlockPos((Vec3i)item));
            }
        });
        return nearbyLeaves;
    }

    @Override
    public void addProbeInfo(@Nonnull ProbeMode probeMode, @Nonnull IProbeInfo iProbeInfo, @Nonnull Player playerEntity, @Nonnull Level world, @Nonnull BlockState blockState, @Nonnull IProbeHitData iProbeHitData) {
        InfestingLeavesBlockEntity infestingLeavesBlockEntity;
        if (probeMode == ProbeMode.EXTENDED && (infestingLeavesBlockEntity = (InfestingLeavesBlockEntity)world.m_7702_(iProbeHitData.getPos())) != null) {
            iProbeInfo.text((Component)Component.m_237110_((String)"waila.progress", (Object[])new Object[]{StringUtils.formatPercent((Float)Float.valueOf((float)infestingLeavesBlockEntity.getProgress() / 100.0f))}));
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new InfestingLeavesBlockEntity((BlockEntityType<? extends InfestingLeavesBlockEntity>)EXNBlockEntityTypes.INFESTING_LEAVES_ENTITY.getType(), pPos, pState);
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        if (!level.f_46443_) {
            return (level1, blockPos, blockState, t) -> {
                if (t instanceof InfestingLeavesBlockEntity) {
                    InfestingLeavesBlockEntity tile = (InfestingLeavesBlockEntity)t;
                    tile.tickServer();
                }
            };
        }
        return null;
    }
}

