/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.model.light;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import me.paulf.fairylights.client.model.light.EasyMeshBuilder;
import me.paulf.fairylights.server.feature.light.Light;
import me.paulf.fairylights.server.feature.light.LightBehavior;
import me.paulf.fairylights.util.AABBBuilder;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import org.joml.Quaternionf;

public abstract class LightModel<T extends LightBehavior>
extends Model {
    protected final ModelPart lit;
    protected final ModelPart litTint;
    protected final ModelPart litTintGlow;
    protected final ModelPart unlit;
    protected float brightness = 1.0f;
    protected float red = 1.0f;
    protected float green = 1.0f;
    protected float blue = 1.0f;
    @Nullable
    private AABB bounds;
    private double floorOffset = Double.NaN;
    private boolean powered;

    public LightModel(ModelPart root) {
        super(RenderType::m_110473_);
        this.lit = root.m_171324_("lit");
        this.litTint = root.m_171324_("lit_tint");
        this.litTintGlow = root.m_171324_("lit_tint_glow");
        this.unlit = root.m_171324_("unlit");
    }

    public AABB getBounds() {
        if (this.bounds == null) {
            PoseStack matrix = new PoseStack();
            AABBVertexBuilder builder = new AABBVertexBuilder();
            this.m_7695_(matrix, builder, 0, 0, 1.0f, 1.0f, 1.0f, 1.0f);
            this.renderTranslucent(matrix, builder, 0, 0, 1.0f, 1.0f, 1.0f, 1.0f);
            this.bounds = builder.build();
        }
        return this.bounds;
    }

    public double getFloorOffset() {
        if (Double.isNaN(this.floorOffset)) {
            AABBVertexBuilder builder = new AABBVertexBuilder();
            this.m_7695_(new PoseStack(), builder, 0, 0, 1.0f, 1.0f, 1.0f, 1.0f);
            this.floorOffset = builder.build().f_82289_ - this.getBounds().f_82289_;
        }
        return this.floorOffset;
    }

    public void animate(Light<?> light, T behavior, float delta) {
        this.powered = light.isPowered();
    }

    public void m_7695_(PoseStack matrix, VertexConsumer builder, int light, int overlay, float r, float g, float b, float a) {
        this.unlit.m_104306_(matrix, builder, light, overlay, r, g, b, a);
        int emissiveLight = this.getLight(light);
        this.lit.m_104306_(matrix, builder, emissiveLight, overlay, r, g, b, a);
        this.litTint.m_104306_(matrix, builder, emissiveLight, overlay, r * this.red, g * this.green, b * this.blue, a);
    }

    public void renderTranslucent(PoseStack matrix, VertexConsumer builder, int light, int overlay, float r, float g, float b, float a) {
        float v = this.brightness;
        this.litTintGlow.m_104306_(matrix, builder, this.getLight(light), overlay, r * this.red * v + (1.0f - v), g * this.green * v + (1.0f - v), b * this.blue * v + (1.0f - v), v * 0.15f + 0.2f);
    }

    protected int getLight(int packedLight) {
        return (int)Math.max(this.brightness * 15.0f * 16.0f, this.powered ? 0.0f : (float)(packedLight & 0xFF)) | packedLight & 0xFF0000;
    }

    protected static float[] toEuler(Quaternionf q) {
        float r11 = 2.0f * (q.x() * q.y() + q.w() * q.z());
        float r12 = q.w() * q.w() + q.x() * q.x() - q.y() * q.y() - q.z() * q.z();
        float r21 = -2.0f * (q.x() * q.z() - q.w() * q.y());
        float r31 = 2.0f * (q.y() * q.z() + q.w() * q.x());
        float r32 = q.w() * q.w() - q.x() * q.x() - q.y() * q.y() + q.z() * q.z();
        return new float[]{(float)Mth.m_14136_((double)r31, (double)r32), (float)Math.asin(r21), (float)Mth.m_14136_((double)r11, (double)r12)};
    }

    static class AABBVertexBuilder
    implements VertexConsumer {
        final AABBBuilder builder = new AABBBuilder();

        AABBVertexBuilder() {
        }

        public VertexConsumer m_5483_(double x, double y, double z) {
            this.builder.include(x, y, z);
            return this;
        }

        public VertexConsumer m_6122_(int r, int g, int b, int a) {
            return this;
        }

        public VertexConsumer m_7421_(float u, float v) {
            return this;
        }

        public VertexConsumer m_7122_(int u, int v) {
            return this;
        }

        public VertexConsumer m_7120_(int u, int v) {
            return this;
        }

        public VertexConsumer m_5601_(float x, float y, float z) {
            return this;
        }

        public void m_5752_() {
        }

        public void m_7404_(int r, int g, int b, int a) {
        }

        public void m_141991_() {
        }

        AABB build() {
            return this.builder.build();
        }
    }

    static interface ModelPartFactory {
        public EasyMeshBuilder create(String var1, int var2, int var3);
    }

    static class BulbBuilder {
        EasyMeshBuilder base;
        EasyMeshBuilder glow;

        public BulbBuilder(EasyMeshBuilder base, EasyMeshBuilder glow) {
            this.base = base;
            this.glow = glow;
        }

        public BulbBuilder setUV(int u, int v) {
            this.base.setTextureOffset(u, v);
            this.glow.setTextureOffset(u, v);
            return this;
        }

        void addBox(float x, float y, float z, float width, float height, float depth) {
            this.addBox(x, y, z, width, height, depth, 0.0f);
        }

        void addBox(float x, float y, float z, float width, float height, float depth, float expand) {
            this.addBox(x, y, z, width, height, depth, expand, 0.7f);
        }

        void addBox(float x, float y, float z, float width, float height, float depth, float expand, float glow) {
            this.base.addBox(x, y, z, width, height, depth, expand);
            this.glow.addBox(x, y, z, width, height, depth, expand + glow);
        }

        BulbBuilder createChild(String name, int u, int v) {
            return this.createChild(name, u, v, EasyMeshBuilder::new);
        }

        BulbBuilder createChild(String name, int u, int v, ModelPartFactory factory) {
            EasyMeshBuilder base = factory.create(name, u, v);
            EasyMeshBuilder glow = factory.create(name, u, v);
            this.base.addChild(base);
            this.glow.addChild(glow);
            return new BulbBuilder(base, glow);
        }

        public void setPosition(float x, float y, float z) {
            this.base.setRotationPoint(x, y, z);
            this.glow.setRotationPoint(x, y, z);
        }

        public void setAngles(float x, float y, float z) {
            this.base.xRot = x;
            this.base.yRot = y;
            this.base.zRot = z;
            this.glow.xRot = x;
            this.glow.yRot = y;
            this.glow.zRot = z;
        }
    }

    public record LightMeshHelper(EasyMeshBuilder lit, EasyMeshBuilder litTint, EasyMeshBuilder litTintGlow, EasyMeshBuilder unlit, List<EasyMeshBuilder> extra) {
        public BulbBuilder createBulb() {
            return new BulbBuilder(this.litTint(), this.litTintGlow());
        }

        public LayerDefinition build() {
            MeshDefinition def = new MeshDefinition();
            this.lit().build(def.m_171576_());
            this.litTint().build(def.m_171576_());
            this.litTintGlow().build(def.m_171576_());
            this.unlit().build(def.m_171576_());
            for (EasyMeshBuilder builder : this.extra()) {
                builder.build(def.m_171576_());
            }
            return LayerDefinition.m_171565_((MeshDefinition)def, (int)128, (int)128);
        }

        public EasyMeshBuilder parented(String name) {
            EasyMeshBuilder result = new EasyMeshBuilder(name);
            result.addChild(this.lit());
            result.addChild(this.litTint());
            result.addChild(this.litTintGlow());
            result.addChild(this.unlit());
            for (EasyMeshBuilder builder : this.extra()) {
                result.addChild(builder);
            }
            return result;
        }

        public static LightMeshHelper create() {
            EasyMeshBuilder lit = new EasyMeshBuilder("lit");
            EasyMeshBuilder litTint = new EasyMeshBuilder("lit_tint");
            EasyMeshBuilder litTintGlow = new EasyMeshBuilder("lit_tint_glow");
            EasyMeshBuilder unlit = new EasyMeshBuilder("unlit");
            return new LightMeshHelper(lit, litTint, litTintGlow, unlit, new ArrayList<EasyMeshBuilder>());
        }
    }
}

