/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.renderer.block.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import me.paulf.fairylights.client.model.light.LightModel;
import me.paulf.fairylights.client.renderer.block.entity.LightRenderer;
import me.paulf.fairylights.server.block.LightBlock;
import me.paulf.fairylights.server.block.entity.LightBlockEntity;
import me.paulf.fairylights.server.feature.light.Light;
import me.paulf.fairylights.server.feature.light.LightBehavior;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class LightBlockEntityRenderer
implements BlockEntityRenderer<LightBlockEntity> {
    private final LightRenderer lights = new LightRenderer(arg_0 -> ((BlockEntityRendererProvider.Context)context).m_173582_(arg_0));

    public LightBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(LightBlockEntity entity, float delta, PoseStack matrix, MultiBufferSource source, int packedLight, int packedOverlay) {
        this.render(entity, delta, matrix, source, packedLight, packedOverlay, entity.getLight());
    }

    private <T extends LightBehavior> void render(LightBlockEntity entity, float delta, PoseStack matrix, MultiBufferSource source, int packedLight, int packedOverlay, Light<T> light) {
        LightModel model = this.lights.getModel(light, -1);
        AABB box = model.getBounds();
        BlockState state = entity.m_58900_();
        AttachFace face = (AttachFace)state.m_61143_((Property)LightBlock.f_53179_);
        float rotation = ((Direction)state.m_61143_((Property)LightBlock.f_54117_)).m_122435_();
        matrix.m_85836_();
        matrix.m_85837_(0.5, 0.5, 0.5);
        matrix.m_252781_(Axis.f_252436_.m_252977_(180.0f - rotation));
        if (light.getVariant().isOrientable()) {
            if (face == AttachFace.WALL) {
                matrix.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            } else if (face == AttachFace.FLOOR) {
                matrix.m_252781_(Axis.f_252529_.m_252977_(-180.0f));
            }
            matrix.m_85837_(0.0, 0.5, 0.0);
        } else if (face == AttachFace.CEILING) {
            matrix.m_85837_(0.0, 0.25, 0.0);
        } else if (face == AttachFace.WALL) {
            matrix.m_85837_(0.0, 0.1875, 0.125);
        } else {
            matrix.m_85837_(0.0, -box.f_82289_ - model.getFloorOffset() - 0.5, 0.0);
        }
        this.lights.render(matrix, this.lights.start(source), light, model, delta, packedLight, packedOverlay);
        matrix.m_85849_();
    }
}

