/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.connection;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

public final class SymbolSet {
    private static final float SCALE = 0.0625f;
    private final int height;
    private final String description;
    private final Int2ObjectMap<Symbol> chars;

    private SymbolSet(Builder builder) {
        this.height = builder.height;
        this.description = builder.description;
        this.chars = Int2ObjectMaps.unmodifiable((Int2ObjectMap)new Int2ObjectOpenHashMap(builder.symbols));
    }

    public float getHeight() {
        return (float)this.height * 0.0625f;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean contains(int character) {
        return this.chars.containsKey(character);
    }

    public float getWidth(char character) {
        return (float)((Symbol)this.chars.getOrDefault((int)character, (Object)Symbol.UNKNOWN)).width * 0.0625f;
    }

    public static class Builder {
        final int height;
        final String description;
        final Int2ObjectMap<Symbol> symbols = new Int2ObjectOpenHashMap();

        public Builder(int height, String description) {
            this.height = height;
            this.description = description;
        }

        public Builder add(String codepoints, int width) {
            codepoints.chars().forEach(codepoint -> this.add(codepoint, width));
            return this;
        }

        public Builder add(int codepoint, int width) {
            this.symbols.put(codepoint, (Object)new Symbol(width));
            return this;
        }

        public SymbolSet build() {
            return new SymbolSet(this);
        }
    }

    private static class Symbol {
        public static final Symbol UNKNOWN = new Symbol(0);
        private final int width;

        public Symbol(int width) {
            this.width = width;
        }
    }
}

