/*
 * Decompiled with CFR 0.152.
 */
package umpaz.farmersrespite.data.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.content.fluids.transfer.EmptyingRecipe;
import com.simibubi.create.content.fluids.transfer.FillingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import umpaz.farmersrespite.common.registry.FRRecipeSerializers;

public class KettlePouringRecipeBuilder {
    private final ItemStack container;
    private final Fluid fluid;
    private final int amount;
    private final ItemStack output;

    private KettlePouringRecipeBuilder(ItemStack container, Fluid fluid, int amount, ItemStack output) {
        this.container = container;
        this.fluid = fluid;
        this.amount = amount;
        this.output = output;
    }

    public static void kettlePouringRecipe(ItemLike container, Fluid fluid, int amount, ItemLike output, Consumer<FinishedRecipe> consumer) {
        new KettlePouringRecipeBuilder(container.m_5456_().m_7968_(), fluid, amount, output.m_5456_().m_7968_()).build(consumer);
    }

    public void build(Consumer<FinishedRecipe> consumerIn) {
        ResourceLocation outputLocation = ForgeRegistries.ITEMS.getKey((Object)this.output.m_41720_());
        this.build(consumerIn, "farmersrespite:pouring/" + outputLocation.m_135815_());
    }

    public void build(Consumer<FinishedRecipe> consumerIn, String save) {
        ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((Object)this.output.m_41720_());
        if (new ResourceLocation(save).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Pouring Recipe " + save + " should remove its 'save' argument");
        }
        this.build(consumerIn, new ResourceLocation(save));
    }

    public void build(Consumer<FinishedRecipe> consumerIn, ResourceLocation id) {
        consumerIn.accept(new Result(id, this.container, this.fluid, this.amount, this.output));
        if (!id.toString().equals("farmersrespite:pouring/potion")) {
            new ProcessingRecipeBuilder(FillingRecipe::new, new ResourceLocation("farmersrespite", id.m_135815_().replace("pouring/", ""))).require(this.fluid, this.amount).require((ItemLike)this.container.m_41720_()).output(this.output).build(consumerIn);
            new ProcessingRecipeBuilder(EmptyingRecipe::new, new ResourceLocation("farmersrespite", id.m_135815_().replace("pouring/", ""))).require((ItemLike)this.output.m_41720_()).output(this.fluid, this.amount).output(this.container).build(consumerIn);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final ItemStack container;
        private final Fluid fluid;
        private final int amount;
        private final ItemStack output;

        public Result(ResourceLocation idIn, ItemStack containerIn, Fluid fluidIn, int amountIn, ItemStack outputIn) {
            this.id = idIn;
            this.container = containerIn;
            this.fluid = fluidIn;
            this.amount = amountIn;
            this.output = outputIn;
        }

        public void m_7917_(JsonObject json) {
            JsonObject objectContainer = new JsonObject();
            objectContainer.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.container.m_41720_()).toString());
            json.add("container", (JsonElement)objectContainer);
            if (this.container.m_41782_()) {
                objectContainer.addProperty("nbt", this.output.m_41783_().toString());
            }
            JsonObject objectContainer1 = new JsonObject();
            objectContainer1.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.output.m_41720_()).toString());
            if (this.output.m_41782_()) {
                objectContainer1.addProperty("nbt", this.output.m_41783_().toString());
            }
            json.add("output", (JsonElement)objectContainer1);
            json.addProperty("fluid", ForgeRegistries.FLUIDS.getKey((Object)this.fluid).toString());
            json.addProperty("amount", (Number)this.amount);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)FRRecipeSerializers.KETTLE_POURING.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

