/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.entity;

import java.util.Locale;
import java.util.Random;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.farmingforblockheads.FarmingForBlockheadsConfig;
import net.blay09.mods.farmingforblockheads.block.ModBlocks;
import net.blay09.mods.farmingforblockheads.block.entity.MarketBlockEntity;
import net.blay09.mods.farmingforblockheads.entity.MerchantGoal;
import net.blay09.mods.farmingforblockheads.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MerchantEntity
extends PathfinderMob {
    private static final Random rand = new Random();
    private BlockPos marketPos;
    private Direction facing;
    private boolean spawnAnimationStarted;
    private boolean spawnDone;
    private SpawnAnimationType spawnAnimation = SpawnAnimationType.MAGIC;
    private BlockPos marketEntityPos;
    private int diggingAnimation;
    private BlockState diggingBlockState;
    private ResourceLocation textureLocation;

    public MerchantEntity(EntityType<MerchantEntity> type, Level level) {
        super(type, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Zombie.class, 8.0f, 0.6, 0.6));
        this.f_21345_.m_25352_(5, (Goal)new MerchantGoal(this, 0.6));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Zombie.m_34328_().m_22268_(Attributes.f_22279_, 0.5);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        MarketBlockEntity market = this.getMarketTileEntity();
        if (market != null) {
            Balm.getNetworking().openGui(player, (MenuProvider)market);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.marketPos != null) {
            compound.m_128356_("MarketPos", this.marketPos.m_121878_());
        }
        if (this.facing != null) {
            compound.m_128344_("Facing", (byte)this.facing.m_122411_());
        }
        compound.m_128379_("SpawnDone", this.spawnDone);
        compound.m_128344_("SpawnAnimation", (byte)this.spawnAnimation.ordinal());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (!this.m_8077_()) {
            String merchantName = FarmingForBlockheadsConfig.getActive().getRandomMerchantName(rand);
            this.m_6593_((Component)Component.m_237113_((String)merchantName));
        }
        if (compound.m_128441_("MarketPos")) {
            this.setMarket(BlockPos.m_122022_((long)compound.m_128454_("MarketPos")), Direction.m_122376_((int)compound.m_128445_("Facing")));
        }
        this.spawnDone = compound.m_128471_("SpawnDone");
        this.spawnAnimation = SpawnAnimationType.values()[compound.m_128445_("SpawnAnimation")];
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public boolean m_8023_() {
        return true;
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12506_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12505_;
    }

    public void m_8119_() {
        super.m_8119_();
        Level level = this.m_9236_();
        if (!level.f_46443_ && this.f_19797_ % 20 == 0 && !this.isMarketValid()) {
            level.m_7605_((Entity)this, (byte)12);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (!this.spawnDone && !this.spawnAnimationStarted) {
            this.spawnAnimationStarted = true;
            switch (this.spawnAnimation) {
                case DIGGING: {
                    level.m_7605_((Entity)this, (byte)13);
                    break;
                }
                case FALLING: {
                    level.m_7605_((Entity)this, (byte)14);
                    break;
                }
                case MAGIC: {
                    level.m_7605_((Entity)this, (byte)15);
                }
            }
        }
        if (this.diggingAnimation > 0) {
            --this.diggingAnimation;
            double posX = this.m_20185_();
            double posY = this.m_20186_();
            double posZ = this.m_20189_();
            for (int i = 0; i < 4; ++i) {
                BlockState diggingState = this.diggingBlockState != null ? this.diggingBlockState : Blocks.f_50493_.m_49966_();
                level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, diggingState), posX, posY, posZ, Math.random() * 2.0 - 1.0, Math.random() * 4.0, Math.random() * 2.0 - 1.0);
                level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, diggingState), posX, posY, posZ, (Math.random() - 0.5) * 0.5, Math.random() * 0.5, (Math.random() - 0.5) * 0.5);
            }
            if (this.diggingAnimation % 2 == 0) {
                level.m_7785_(posX, posY, posZ, SoundType.f_56739_.m_56778_(), SoundSource.BLOCKS, 0.2f, (float)(Math.random() + 0.5), false);
            }
        }
    }

    public void m_7822_(byte id) {
        Level level = this.m_9236_();
        if (id == 12) {
            this.disappear();
        } else if (id == 13) {
            this.diggingBlockState = level.m_8055_(this.m_20183_().m_7495_());
            this.diggingAnimation = 60;
        } else if (id == 14) {
            BlockPos pos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING, this.m_20183_());
            level.m_7785_((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), (SoundEvent)ModSounds.falling.get(), SoundSource.NEUTRAL, 0.2f, 1.0f, false);
        } else if (id == 15) {
            double posX = this.m_20185_();
            double posY = this.m_20186_();
            double posZ = this.m_20189_();
            level.m_7785_(posX + 0.5, posY + 1.0, posZ + 0.5, SoundEvents.f_11874_, SoundSource.NEUTRAL, 0.2f, 1.0f, false);
            for (int i = 0; i < 50; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123815_, posX + 0.5, posY + 1.0, posZ + 0.5, (Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.5);
            }
            level.m_7106_((ParticleOptions)ParticleTypes.f_123813_, posX + 0.5, posY + 1.0, posZ + 0.5, 0.0, 0.0, 0.0);
        } else {
            super.m_7822_(id);
        }
    }

    protected void m_6475_(DamageSource damageSource, float damageAmount) {
        if (!this.spawnDone && damageSource == this.m_9236_().m_269111_().m_268989_()) {
            double posX = this.m_20185_();
            double posY = this.m_20186_();
            double posZ = this.m_20189_();
            this.m_9236_().m_7785_(posX, posY, posZ, this.m_7975_(damageSource), SoundSource.NEUTRAL, 1.0f, 2.0f, false);
            this.spawnDone = true;
            return;
        }
        super.m_6475_(damageSource, damageAmount);
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 1.62f;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        if (Math.random() < 0.001) {
            this.m_6593_((Component)Component.m_237113_((String)(Math.random() <= 0.5 ? "Pam" : "Blay")));
        } else {
            String merchantName = FarmingForBlockheadsConfig.getActive().getRandomMerchantName(rand);
            this.m_6593_((Component)Component.m_237113_((String)merchantName));
        }
        return super.m_6518_(level, difficulty, mobSpawnType, spawnGroupData, compoundTag);
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public boolean m_6162_() {
        return FarmingForBlockheadsConfig.getActive().treatMerchantsLikeBabies;
    }

    public void setMarket(BlockPos marketPos, Direction facing) {
        this.marketPos = marketPos;
        this.marketEntityPos = marketPos.m_121945_(facing.m_122424_());
        this.facing = facing;
    }

    @Nullable
    public BlockPos getMarketEntityPosition() {
        return this.marketEntityPos;
    }

    public boolean isAtMarket() {
        return this.marketEntityPos != null && this.m_20238_(Vec3.m_82512_((Vec3i)this.marketEntityPos.m_121945_(this.facing.m_122424_()))) <= 1.0;
    }

    @Nullable
    private MarketBlockEntity getMarketTileEntity() {
        if (this.marketPos == null) {
            return null;
        }
        BlockEntity tileEntity = this.m_9236_().m_7702_(this.marketPos);
        if (tileEntity instanceof MarketBlockEntity) {
            MarketBlockEntity market = (MarketBlockEntity)tileEntity;
            return market;
        }
        return null;
    }

    private boolean isMarketValid() {
        return this.marketPos != null && this.m_9236_().m_8055_(this.marketPos).m_60734_() == ModBlocks.market;
    }

    public void setToFacingAngle() {
        float facingAngle = this.facing.m_122435_();
        this.m_19915_(facingAngle, 0.0f);
        this.m_5616_(facingAngle);
        this.m_5618_(facingAngle);
    }

    private void disappear() {
        double posX = this.m_20185_();
        double posY = this.m_20186_();
        double posZ = this.m_20189_();
        Level level = this.m_9236_();
        level.m_7785_(posX, posY, posZ, SoundEvents.f_11874_, SoundSource.NEUTRAL, 1.0f, 1.0f, false);
        for (int i = 0; i < 50; ++i) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123815_, posX, posY + 1.0, posZ, (Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.5);
        }
        level.m_7106_((ParticleOptions)ParticleTypes.f_123813_, posX, posY + 1.0, posZ, 0.0, 0.0, 0.0);
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public void setSpawnAnimation(SpawnAnimationType spawnAnimation) {
        this.spawnAnimation = spawnAnimation;
    }

    public int getDiggingAnimation() {
        return this.diggingAnimation;
    }

    public void m_6593_(@Nullable Component component) {
        super.m_6593_(component);
        this.textureLocation = null;
    }

    @Nullable
    public ResourceLocation getTextureLocation() {
        Component customName = this.m_7770_();
        if (this.textureLocation == null && customName != null) {
            String normalizedName = customName.getString();
            normalizedName = normalizedName.replaceAll("[^A-Za-z0-9]", "_");
            normalizedName = normalizedName.toLowerCase(Locale.ENGLISH);
            this.textureLocation = new ResourceLocation("farmingforblockheads", "textures/entity/merchant_" + normalizedName + ".png");
        } else if (this.textureLocation != null && customName == null) {
            this.textureLocation = null;
        }
        return this.textureLocation;
    }

    public static enum SpawnAnimationType {
        MAGIC,
        FALLING,
        DIGGING;

    }
}

