/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import whocraft.tardis_refined.constants.ModMessages;

public class TRConfig {
    public static Common COMMON;
    public static ForgeConfigSpec COMMON_SPEC;
    public static Server SERVER;
    public static ForgeConfigSpec SERVER_SPEC;
    public static Client CLIENT;
    public static ForgeConfigSpec CLIENT_SPEC;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        Pair specServerPair = new ForgeConfigSpec.Builder().configure(Server::new);
        SERVER_SPEC = (ForgeConfigSpec)specServerPair.getRight();
        SERVER = (Server)specServerPair.getLeft();
        Pair specClientPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specClientPair.getRight();
        CLIENT = (Client)specClientPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue COMPATIBILITY_IP;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("compatibility");
            this.COMPATIBILITY_IP = builder.comment("Toggle Immersive Portals compatibility (TR 2.0+). 2.0 has limited support").translation(ModMessages.CONFIG_IP_COMPAT).define("immersive_portals_support", true);
            builder.pop();
        }
    }

    public static class Server {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> BANNED_DIMENSIONS;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> ADVENTURE_MODE_DEFAULTS;
        public final ForgeConfigSpec.BooleanValue ADVENTURE_MODE;

        public Server(ForgeConfigSpec.Builder builder) {
            builder.push("travel");
            this.BANNED_DIMENSIONS = builder.translation("config.tardis_refined.banned_dimensions").comment("A list of Dimensions the TARDIS cannot land in.").defineList("banned_dimensions", (List)Lists.newArrayList((Object[])new String[]{"example:dimension"}), String.class::isInstance);
            this.ADVENTURE_MODE_DEFAULTS = builder.translation("config.tardis_refined.adventure_mode_defaults").comment("A list of Dimensions that are automatically sampled").defineList("adventure_mode_defaults", (List)Lists.newArrayList((Object[])new String[]{"minecraft:overworld"}), String.class::isInstance);
            this.ADVENTURE_MODE = builder.translation("config.tardis_refined.adventure_mode").comment("Toggles whether players must discover and sample dimensions before they can travel there").define("adventure_mode", false);
            builder.pop();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue CONTROL_NAMES;
        public final ForgeConfigSpec.BooleanValue PLAY_CONSOLE_IDLE_ANIMATIONS;
        public final ForgeConfigSpec.BooleanValue RENDER_VORTEX_IN_DOOR;
        public final ForgeConfigSpec.BooleanValue USE_INTERNAL_SHADERS;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.push("rendering");
            this.CONTROL_NAMES = builder.comment("Toggle control name rendering").translation(ModMessages.CONFIG_CONTROL_NAMES).define("control_name_rendering", true);
            this.PLAY_CONSOLE_IDLE_ANIMATIONS = builder.comment("Play idle console animations").translation(ModMessages.CONFIG_IDLE_CONSOLE_ANIMS).define("console_idle_animations", true);
            this.RENDER_VORTEX_IN_DOOR = builder.comment("Skip Vortex rendering").translation(ModMessages.CONFIG_RENDER_VORTEX_IN_DOOR).define("render_vortex_in_door", true);
            this.USE_INTERNAL_SHADERS = builder.comment("Use Custom Internal Shaders").translation(ModMessages.CONFIG_CUSTOM_SHADERS).define("use_internal_shaders", true);
            builder.pop();
        }
    }
}

