/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.model.blockentity.console;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.jeryn.frame.tardis.Frame;
import net.minecraft.client.Minecraft;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import whocraft.tardis_refined.TRConfig;
import whocraft.tardis_refined.client.TardisClientData;
import whocraft.tardis_refined.client.model.blockentity.console.ConsoleUnit;
import whocraft.tardis_refined.common.block.console.GlobalConsoleBlock;
import whocraft.tardis_refined.common.blockentity.console.GlobalConsoleBlockEntity;

public class FactoryConsoleModel
extends HierarchicalModel
implements ConsoleUnit {
    public static final AnimationDefinition IDLE = Frame.loadAnimation(new ResourceLocation("tardis_refined", "frame/console/factory/idle.json"));
    public static final AnimationDefinition FLIGHT = Frame.loadAnimation(new ResourceLocation("tardis_refined", "frame/console/factory/flight.json"));
    public static final AnimationDefinition CRASH = Frame.loadAnimation(new ResourceLocation("tardis_refined", "frame/console/factory/crash.json"));
    public static final AnimationDefinition POWER_ON = Frame.loadAnimation(new ResourceLocation("tardis_refined", "frame/console/factory/power_on.json"));
    public static final AnimationDefinition POWER_OFF = Frame.loadAnimation(new ResourceLocation("tardis_refined", "frame/console/factory/power_off.json"));
    private static final ResourceLocation FACTORY_TEXTURE = new ResourceLocation("tardis_refined", "textures/blockentity/console/factory/factory_console.png");
    private final ModelPart root;
    private final ModelPart throttleLever;
    private final ModelPart handbrake;

    public FactoryConsoleModel(ModelPart root) {
        this.root = root;
        this.throttleLever = Frame.findPart(this, "lever2");
        this.handbrake = Frame.findPart(this, "lever3");
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.m_142109_().m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @Override
    public void renderConsole(GlobalConsoleBlockEntity globalConsoleBlock, Level level, PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        boolean powered = globalConsoleBlock == null || (Boolean)globalConsoleBlock.m_58900_().m_61143_((Property)GlobalConsoleBlock.POWERED) != false;
        int tickCount = Minecraft.m_91087_().f_91074_.f_19797_;
        TardisClientData reactions = TardisClientData.getInstance((ResourceKey<Level>)level.m_46472_());
        if (globalConsoleBlock != null) {
            if (powered) {
                if (globalConsoleBlock.getTicksBooting() > 0) {
                    if (!globalConsoleBlock.powerOn.m_216984_()) {
                        globalConsoleBlock.powerOff.m_216973_();
                        globalConsoleBlock.powerOn.m_216977_(tickCount);
                    }
                    this.m_233381_(globalConsoleBlock.powerOn, POWER_ON, tickCount);
                }
                if (reactions.isFlying()) {
                    this.m_233381_(reactions.ROTOR_ANIMATION, FLIGHT, tickCount);
                } else if (reactions.isCrashing()) {
                    this.m_233381_(reactions.CRASHING_ANIMATION, CRASH, tickCount);
                } else if (((Boolean)TRConfig.CLIENT.PLAY_CONSOLE_IDLE_ANIMATIONS.get()).booleanValue()) {
                    this.m_233381_(globalConsoleBlock.liveliness, IDLE, tickCount);
                }
            } else {
                if (!globalConsoleBlock.powerOff.m_216984_()) {
                    globalConsoleBlock.powerOn.m_216973_();
                    globalConsoleBlock.powerOff.m_216977_(tickCount);
                }
                this.m_233381_(globalConsoleBlock.powerOff, POWER_OFF, tickCount);
            }
            this.throttleLever.f_104203_ = -125.0f - 30.0f * ((float)reactions.getThrottleStage() / 5.0f);
            this.handbrake.f_104203_ = reactions.isHandbrakeEngaged() ? -155.0f : -125.0f;
        }
        this.m_142109_().m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void m_6973_(Entity entity, float f, float g, float h, float i, float j) {
    }

    @Override
    public ResourceLocation getDefaultTexture() {
        return FACTORY_TEXTURE;
    }
}

